def ror5(x, i):
    """
    Rotate right x[0:5] by i positions
    """
    assert 0 <= i <= 5
    return ((x >> i) | (x << (5-i))) & 0x1f

assert ror5(0x1f, 1) == 0x1f
assert ror5(0x10, 1) == 0x08
assert ror5(0x08, 1) == 0x04
assert ror5(0x10, 3) == 0x02
assert ror5(0x1, 1) == 0x10

def f_iter(x):
    x = (x + 0x55) & 0x1f
    x = ror5(x, 3)
    return (x * 3) & 0x1f

def run():
    lst = [f_iter(i) for i in range(32)]

    after_perm = '89349536319392163324855876422573'
    before_perm = [after_perm[f_iter(i)] for i in range(32)]
    print(''.join(before_perm))

if __name__ == '__main__':
    run()
