
/**
* This adds {fileName, lineNumber} annotations to React component definitions
* and to jsx tag literals.
*
*
* == JSX Literals ==
*
* <sometag />
*
* becomes:
*
* <sometag __source={{fileName: 'this/file.js', lineNumber: 10}}/>
*/

"use strict";

var _interopRequireDefault = require("babel-runtime/helpers/interop-require-default")["default"];

exports.__esModule = true;

var _path = require("path");

var _path2 = _interopRequireDefault(_path);

var TRACE_ID = "__source";

exports["default"] = function (_ref) {
  var t = _ref.types;

  function makeTrace(fileName, lineNumber) {
    var fileNameLiteral = fileName != null ? t.stringLiteral(fileName) : t.nullLiteral();
    var fileLineLiteral = lineNumber != null ? t.numericLiteral(lineNumber) : t.nullLiteral();
    var fileNameProperty = t.objectProperty(t.identifier("fileName"), fileNameLiteral);
    var lineNumberProperty = t.objectProperty(t.identifier("lineNumber"), fileLineLiteral);
    return t.objectExpression([fileNameProperty, lineNumberProperty]);
  }

  var visitor = {
    JSXOpeningElement: function JSXOpeningElement(node, state) {
      var id = t.jSXIdentifier(TRACE_ID);
      var fileName = state.file.log.filename !== "unknown" ? _path2["default"].relative(__dirname, state.file.log.filename) : null;
      var trace = makeTrace(fileName, node.container.openingElement.loc.start.line);

      node.container.openingElement.attributes.push(t.jSXAttribute(id, t.jSXExpressionContainer(trace)));
    }
  };

  return {
    visitor: visitor
  };
};

module.exports = exports["default"];