;initialize all the other needed things

;initialize DirectDraw

;in order to avoid problems with incompatible direct draw *.LIBs
;we use run-time loading of DLLs and their functions.
;For doing that we need 2 functions within kernel32.dll

		segment .data USE32

		dllname db "ddraw.dll",0
		functionname db "DirectDrawCreate",0

		segment .code USE32

		EXTERN LoadLibraryA
		IMPORT LoadLibraryA kernel32.dll
		EXTERN GetProcAddress
		IMPORT GetProcAddress kernel32.dll

		push dword dllname
		call [LoadLibraryA]
;eax is now the hInstance of the dll (or zero if the function failed)

		push dword functionname
		push eax
		call [GetProcAddress]

;now we have the adress of the DirectDrawCreate function in eax.
;lets start with creating a DirectDrawInterface

		segment .data USE32

		 DDrawIsInitialized dd 0

;store vtable adresses of DirectDraw interfaces here

		 OurDirectDrawInterface   dd 0
		 OurPrimarySurface        dd 0
		 OurOffscreenSurface      dd 0
		 ClipperForPrimarySurface dd 0

		segment .code USE32

;create a DirectDraw interface
		push dword 0
		push dword OurDirectDrawInterface
		push dword 0
		call eax
		or eax,eax ;success ?
		jnz near WM_QUIT_received

;setting up DirectDraw:
;1. set the Cooperative Level. 
;This is done in the COM way of calling functions.
;First, a macro making the conversion easier is established
;NOTE: it uses the EDI register !!!

		%macro DXfunction_ 2 
		 mov edi,[%1] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+%2] ; callziel
		  push dword [%1]
		  call edi
		%endmacro

;this version is extended with code showing errors
;the 3rd and 4th parameter form the text of the
;error message if an error occurs
		%macro DXfunction 4 "Error" , "DirectX function failed" 
		 mov edi,[%1] ;edi = DD-Objekt(adresse)
		 mov edi,[edi]   ;edi = VTable(adresse)
		 mov edi,[edi+%2] ; callziel
		  push dword [%1]
		  call edi
		or eax,eax
		jz %%noerrmsg
		 push dword MB_ICONHAND + MB_OK
		 push dword %%MessageBoxTitle
	  	 push dword %%MessageBoxContent
		 push dword 0
		 call [MessageBoxA]
		 jmp WM_QUIT_received

		%%noerrmsg:

		segment .data USE32

		%%MessageBoxTitle:
		 db "DirectX Function Call Failed" ,0
		%%MessageBoxContent:
		 db %3, " : ", %4 ,0

		segment .code USE32

		%endmacro


;and now the function call
		push dword DDSCL_NORMAL
		push dword 0
		DXfunction OurDirectDrawInterface, DDSETCOOPERATIVELEVEL ,"OurDirectDrawInterface", "DDSETCOOPERATIVELEVEL"

;2. create a primary surface and an offscreen surface

		segment .data USE32

		SurfaceDescription:
		times DDSURFACEDESC_size db 0

		segment .code USE32

;set up the DDSURFACEDESC structure for telling DirectDraw that a 
;PrimarySurface is needed
		mov dword [SurfaceDescription+DDSURFACEDESC.dwSize],DDSURFACEDESC_size
		mov dword [SurfaceDescription+DDSURFACEDESC.ddssurfCaps],DDSCAPS_PRIMARYSURFACE 

		push dword 0
		push dword OurPrimarySurface
		push dword SurfaceDescription
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "OurDirectDrawInterface", "DDCREATESURFACE"

;create the offscreen surface according to the primary surface
		mov dword [SurfaceDescription+DDSURFACEDESC.dwSize],DDSURFACEDESC_size
		mov dword [SurfaceDescription+DDSURFACEDESC.dwsurfFlags],DDSD_HEIGHT + DDSD_WIDTH + DDSD_CAPS + DDSD_PIXELFORMAT

		push dword SurfaceDescription
		DXfunction OurPrimarySurface, DDSGETCAPS, "OurPrimarySurface", "DDSGETCAPS"

;change settings to our needs so that the offscreen surface fits our needs 
		mov dword [SurfaceDescription+DDSURFACEDESC.dwSize],DDSURFACEDESC_size
		mov dword [SurfaceDescription+DDSURFACEDESC.dwsurfFlags],DDSD_HEIGHT + DDSD_WIDTH + DDSD_CAPS + DDSD_PITCH
		mov dword [SurfaceDescription+DDSURFACEDESC.ddssurfCaps],DDSCAPS_OFFSCREENPLAIN  
		mov dword [SurfaceDescription+DDSURFACEDESC.dwHeight],256 
		mov dword [SurfaceDescription+DDSURFACEDESC.dwWidth],256 
		mov dword [SurfaceDescription+DDSURFACEDESC.lPitch],0 

		push dword 0
		push dword OurOffscreenSurface
		push dword SurfaceDescription
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "OurDirectDrawInterface", "DDCREATESURFACE"

;create a clipper and set it to the program window

		push dword 0
		push dword ClipperForPrimarySurface
		push dword 0
		DXfunction OurDirectDrawInterface, DDCREATECLIPPER, "OurDirectDrawInterface", "DDCREATECLIPPER"

		push dword [Windowhandle]
		push dword 0
		DXfunction ClipperForPrimarySurface, DDCSETHWND, "ClipperForPrimarySurface", "DDCSETHWND"
		 push dword [ClipperForPrimarySurface]
		 DXfunction OurPrimarySurface, DDSSETCLIPPER, "OurPrimarySurface", "DDSSETCLIPPER"

;get the coordinates of our window
		 push dword BlitRect
		 push dword [Windowhandle]
		 call [GetWindowRect]
	
;Now we have 2 Surfaces (and a clipper). That is all we need here fore drawing.

;initialize DirectSoundCapture

		segment .data USE32

		dsounddllname db "dsound.dll",0
		dsoundfunctionname db "DirectSoundCaptureCreate",0

;I did not found a useful dsound.inc at all. So the DirectSound settings
;needed are included here, too

		DSCBUFFERDESC:
		DSCdwSize        dd 20
		DSCdwFlags       dd 0
		DSCdwBufferBytes dd 1024
		DSCreserved      dd 0
		DSClpwfxFormat   dd 0

		DSCBSTART_LOOPING equ 1
		CREATECAPTUREBUFFER equ 12
		START equ 36
		STOP equ 40

		DSC_WAVEFORMATEX:
		DSCwFormatTag      dw WAVE_FORMAT_PCM
		DSCnChannels       dw 1
		DSCnSamplesPerSec  dd 11025
		DSCnAvgBytesPerSec dd 11025
		DSCnBlockAlign     dw 1
		DSCwBitsPerSample  dw 8
		DSCcbSize          dw 0

		OurDSoundCapture       dd 0
		OurDSoundCaptureBuffer dd 0

		segment .code USE32

		push dword dsounddllname
		call [LoadLibraryA]
		push dword dsoundfunctionname
		push eax
		call [GetProcAddress]

		push dword 0
		push dword OurDSoundCapture
		push dword 0
		call eax
		or eax,eax
		jnz near WM_QUIT_received

		mov dword [DSClpwfxFormat], DSC_WAVEFORMATEX

;create a capture buffer through the DirectSoundCapture object
		push dword 0
		push dword OurDSoundCaptureBuffer
		push dword DSCBUFFERDESC
		DXfunction OurDSoundCapture, CREATECAPTUREBUFFER, "OurDSoundCapture", "CREATECAPTUREBUFFER"

;start the recording
		push dword DSCBSTART_LOOPING
		DXfunction OurDSoundCaptureBuffer, START, "OurDSoundCaptureBuffer", "START"

;set a flag that initialization has finished
		mov dword [DDrawIsInitialized],1
