;NASM Win32 coding tutorial pt. 2.718  -  by T$ (ts@deinmeister.de)
;
;compile with:
;NASMW.EXE -fobj win003_n.asm
;link with:
;ALINK.EXE -c -oPE  -subsys gui win001_n win32.lib win003.res

;Everything written in part 1.2 won`t be repeated here - if something is still curious,
;a look into the first two parts may help

		%include "..\..\inc\win32n.inc"       
		%include "..\..\inc\nddraw.inc"

		EXTERN GetModuleHandleA
		IMPORT GetModuleHandleA kernel32.dll
		EXTERN RegisterClassExA
		IMPORT RegisterClassExA user32.dll
		EXTERN LoadIconA
		IMPORT LoadIconA user32.dll
		EXTERN LoadCursorA
		IMPORT LoadCursorA user32.dll
		EXTERN CreateWindowExA
		IMPORT CreateWindowExA user32.dll
		EXTERN GetMessageA
		IMPORT GetMessageA user32.dll
		EXTERN PeekMessageA
		IMPORT PeekMessageA user32.dll
		EXTERN DispatchMessageA
		IMPORT DispatchMessageA user32.dll
		EXTERN ExitProcess
		IMPORT ExitProcess kernel32.dll
		EXTERN DefWindowProcA
		IMPORT DefWindowProcA user32.dll
		EXTERN PostQuitMessage
		IMPORT PostQuitMessage user32.dll
		EXTERN MessageBoxA
		IMPORT MessageBoxA user32.dll
		EXTERN SendMessageA
		IMPORT SendMessageA user32.dll
		EXTERN GetWindowRect
		IMPORT GetWindowRect user32.dll

		segment .data USE32

;Definition of the window class:

		OurWindowclass:
		istruc WNDCLASSEX
		    at WNDCLASSEX.cbSize,          dd  WNDCLASSEX_size
		    at WNDCLASSEX.style,           dd  CS_VREDRAW + CS_HREDRAW
		    at WNDCLASSEX.lpfnWndProc,     dd  Windowprocedure
		    at WNDCLASSEX.cbClsExtra,      dd  0
		    at WNDCLASSEX.cbWndExtra,      dd  0
		    at WNDCLASSEX.hInstance,       dd  0
		    at WNDCLASSEX.hIcon,           dd  0
		    at WNDCLASSEX.hCursor,         dd  0
		    at WNDCLASSEX.hbrBackground,   dd  COLOR_HIGHLIGHT
		    at WNDCLASSEX.lpszMenuName,    dd  Menuname
		    at WNDCLASSEX.lpszClassName,   dd  Windowclassname
		    at WNDCLASSEX.hIconSm,         dd  0
	    	iend

		Windowhandle dd 0

;the following constants describe the content of the message structure residing on the stack:
		MSGhWnd   equ 0
		MSGmsg    equ 4
		MSGwParam equ 8
		MSGlParam equ 12

;GetMessage requires a buffer for an incoming Message (one Message = 7 DWORDS):
		MessageBuffer dd 0,0,0,0,0,0,0

		Windowclassname db "OurWindowclass",0
		Windowname db "Cheap Direct (D)RAW Osci",0

;Name of Ressources:
		Menuname db "Win003menu",0
		Picturename db "Nuke",0
		Cursorname db "Fisch",0

;these constants are stand for themselves - change them, if you want ;-)
		WindowsizeInX equ 300
		WindowsizeInY equ 200
		WindowpositionInX equ 100
		WindowpositionInY equ 120



		segment .code USE32

		..start


		push dword 0
		call [GetModuleHandleA]
		mov [OurWindowclass+WNDCLASSEX.hInstance],eax

		push dword Picturename
		push dword [OurWindowclass+WNDCLASSEX.hInstance]
		call [LoadIconA]
		mov [OurWindowclass+WNDCLASSEX.hIcon],eax
		push dword Cursorname
		push dword [OurWindowclass+WNDCLASSEX.hInstance]
		call [LoadCursorA]
		mov [OurWindowclass+WNDCLASSEX.hCursor],eax

		push dword OurWindowclass
		call [RegisterClassExA]

		push dword 0
		push dword [OurWindowclass+WNDCLASSEX.hInstance]
		push dword 0
		push dword 0
		push dword WindowsizeInY
		push dword WindowsizeInX
		push dword WindowpositionInY
		push dword WindowpositionInX
		push dword WS_CAPTION + WS_MAXIMIZEBOX + WS_MINIMIZEBOX + WS_SIZEBOX + WS_SYSMENU + WS_VISIBLE
		push dword Windowname
		push dword Windowclassname
		push dword WS_EX_CLIENTEDGE + WS_EX_WINDOWEDGE
		call [CreateWindowExA]
		mov [Windowhandle],eax

;do startup init crap
%include "startup_n.inc"

;The most important place in a windows program: The Message Pump / Message Loop. 

		MessagePumpStart:
		call MainDrawingProcedure

		push dword 0
		push dword 0
		push dword 0
		push dword 0
		push dword MessageBuffer
		call [PeekMessageA]
		or eax,eax
		jz MessagePumpStart

		push dword 0
		push dword 0
		push dword 0
		push dword MessageBuffer
		call [GetMessageA]
		or eax,eax
		jz WM_QUIT_received
		push dword MessageBuffer
		call [DispatchMessageA]
		jmp MessagePumpStart


		WM_QUIT_received:
		push dword 0
		call [ExitProcess]

;------------
;the window procedure
		Windowprocedure:

;check interesting messages here
		%include "msgproc_n.inc"

		cmp dword [esp+4+MSGmsg],WM_DESTROY
		je Selfdestruction
		jmp [DefWindowProcA]

		Selfdestruction:
; process cleanup shit here
		%include "cleanup_n.inc"
		push dword 0
		call [PostQuitMessage]
		xor eax,eax
		ret 16

		%include "blitproc_n.inc"
