;* Coded by Serge | (C)hardCode | http://bizarrecreations.webjump.com

BITS 32

%include "win32n.inc"
%include "nwinx.inc"
%include "kernel32n.inc"
%include "user32n.inc"
%include "gdi32n.inc"
%include "..\..\inc\nasmgl.inc"

GLOBAL _WinMain


section .data

MyClassName db 'NasmClass32',0
WinTitleString db 'OpenGL torus for NASM',0

 align 4

glHalf dd 0.5

Roll dd 0
rotstep dd 1.35

light0Pos dd 0.70,0.70,1.25,0.00

mat0_Ambient  dd 0.01,0.01,0.01,1.0
mat0_Diffuse  dd 0.85,0.85,0.2,1.0
mat0_Specular dd 0.5,0.5,0.5,1.0
mat0_Shine    dd 20.0

mat1_Ambient  dd 0.01,0.01,0.01,1.0
mat1_Diffuse  dd 0.05,0.07,0.8,1.0
mat1_Specular dd 0.5,0.5,0.5,1.0
mat1_Shine    dd 20.0


msg:
    istruc MSG
    iend

wc:
 istruc WNDCLASSEX
     at WNDCLASSEX.cbSize,	dd 12*4
     at WNDCLASSEX.style, 	dd CS_OWNDC | CS_HREDRAW | CS_VREDRAW
     at WNDCLASSEX.lpfnWndProc, dd winProc
     at WNDCLASSEX.cbClsExtra,	dd 0
     at WNDCLASSEX.cbWndExtra, 	dd 0
     at WNDCLASSEX.hInstance,	dd 0
     at WNDCLASSEX.hIcon,	dd 0
     at WNDCLASSEX.hCursor,	dd 0
     at WNDCLASSEX.hbrBackground, dd COLOR_GRAYTEXT
     at WNDCLASSEX.lpszMenuName,  dd 0
     at WNDCLASSEX.lpszClassName, dd MyClassName
     at WNDCLASSEX.hIconSm,       dd 0
    iend

ps:
 istruc PAINTSTRUCT
 iend


pfd:
 istruc PIXELFORMATDESCRIPTOR
 iend
pfdsize equ $-pfd

crect:
 istruc RECT
 iend

section .bss
hInstance resd 1
hWnd resd 1
hDC resd 1 ; GDI device context
hRC resd 1 ; OpenGL rendering context

section .text

PROC GL_Resize,w,h
var left,8
var right,8 
var bottom,8
var top,8
endvar
 fld dword [glHalf]
 fst qword [ebp+.right]   ; 0.5
 fst qword [ebp+.top]     ;  0.5
 fchs
 fst qword [ebp+.left]    ; -0.5
 fstp qword [ebp+.bottom] ; -0.5
 _glMatrixMode GL_PROJECTION
 _glLoadIdentity
 fild dword [ebp+.w]
 fild dword [ebp+.h]
 ; take care of aspect ratio
 mov eax,[ebp+.w]
 cmp eax,[ebp+.h]
 jbe .less
   fdivp st1,st0  ; w/h
   fld st0
   fmul qword [ebp+.right]
   fxch
   fmul qword [ebp+.left]
   fstp qword [ebp+.left]
   fstp qword [ebp+.right]
 jmp .done
 .less:
   fdivrp st1,st0 ; h/w
   fld st0
   fmul qword [ebp+.top]
   fxch
   fmul qword [ebp+.bottom]
   fstp qword [ebp+.bottom]
   fstp qword [ebp+.top]
 .done:
 _glFrustum ebp+.left,ebp+.right,ebp+.bottom,ebp+.top,1.0,3.0
 _glMatrixMode GL_MODELVIEW
 _glViewport 0,0,[ebp+.w],[ebp+.h]
ENDP

PROC SetupOpenGL,hWnd
nolocals
 push dword [ebp+.hWnd]
 call GetDC
 mov [hDC],eax

 push edi
 mov edi,dword pfd
 mov ecx,pfdsize/4
 xor eax,eax
 rep stosd
 pop edi

 mov word [pfd+PIXELFORMATDESCRIPTOR.nSize],pfdsize
 mov word [pfd+PIXELFORMATDESCRIPTOR.nVersion],1
 mov dword [pfd+PIXELFORMATDESCRIPTOR.dwFlags],PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER | PFD_DRAW_TO_WINDOW
 mov dword [pfd+PIXELFORMATDESCRIPTOR.dwLayerMask],PFD_MAIN_PLANE
 mov byte [pfd+PIXELFORMATDESCRIPTOR.iPixelType],PFD_TYPE_RGBA
 mov byte [pfd+PIXELFORMATDESCRIPTOR.cColorBits],16
 mov byte [pfd+PIXELFORMATDESCRIPTOR.cDepthBits],16
 mov byte [pfd+PIXELFORMATDESCRIPTOR.cAccumBits],0
 mov byte [pfd+PIXELFORMATDESCRIPTOR.cStencilBits],0
 push dword pfd
 push dword [hDC]
 call ChoosePixelFormat

 push dword pfd
 push eax
 push dword [hDC]
 call SetPixelFormat

 push dword [hDC]
 call wglCreateContext
 mov [hRC],eax
 push dword [hRC]
 push dword [hDC]
 call wglMakeCurrent

 ; position viewer
 _glMatrixMode GL_MODELVIEW
 _glTranslatef 0.0,0.0,-2.0

 ; position light0
 push dword light0Pos
 push dword GL_POSITION
 push dword GL_LIGHT0
 call glLightfv

 _glEnable GL_LIGHTING
 _glEnable GL_LIGHT0
 _glEnable GL_DEPTH_TEST
 _glEnable GL_CULL_FACE
 _glShadeModel GL_SMOOTH
ENDP


PROC KillOpenGL,hWnd
nolocals
 push dword 0
 push dword 0
 call wglMakeCurrent
 push dword [hRC]
 call wglDeleteContext
 push dword [hDC]
 push dword [ebp+.hWnd]
 call ReleaseDC
ENDP


PROC SelectMaterial,matNum
nolocals
 cmp dword [ebp+.matNum],0
 jnz .mat1
  _glMaterialfv GL_FRONT,GL_AMBIENT,mat0_Ambient
  _glMaterialfv GL_FRONT,GL_DIFFUSE,mat0_Diffuse
  _glMaterialfv GL_FRONT,GL_SPECULAR,mat0_Specular
  _glMaterialf GL_FRONT,GL_SHININESS,[mat0_Shine]
 jmp short .exit
.mat1:
  _glMaterialfv GL_FRONT,GL_AMBIENT,mat1_Ambient
  _glMaterialfv GL_FRONT,GL_DIFFUSE,mat1_Diffuse
  _glMaterialfv GL_FRONT,GL_SPECULAR,mat1_Specular
  _glMaterialf GL_FRONT,GL_SHININESS,[mat1_Shine]
.exit:
ENDP


PROC winProc,hWnd,uMsg,wParam,lParam
nolocals
 mov edx,dword .casetab
 mov eax,[ebp+.uMsg]
.walk:
 cmp dword [edx],-1
 jz .def
 cmp eax,[edx]
 lea edx,[edx+8]
 jnz .walk
 jmp dword [edx-4]
.def:
 push dword [ebp+.lParam]
 push dword [ebp+.wParam]
 push dword [ebp+.uMsg]
 push dword [ebp+.hWnd]
 call DefWindowProc
 jmp .exit
  align 4
.casetab:
 dd WM_PAINT,.paint
 dd WM_SIZE,.size
 dd WM_CREATE,.create
 dd WM_DESTROY,.destroy
 dd WM_KEYDOWN,.key
 dd -1
.paint:
 push dword ps
 push dword [ebp+.hWnd]
 call BeginPaint
 call GL_Paint
 push dword ps
 push dword [ebp+.hWnd]
 call EndPaint
 jmp .done
.create:
 push dword [ebp+.hWnd]
 call SetupOpenGL
 push dword crect
 push dword [ebp+.hWnd]
 call GetClientRect
 invoke GL_Resize,dword [crect+RECT.right],dword [crect+RECT.bottom]
 jmp short .done
.size:
 cmp dword [hRC],0
 jz .done
 push dword crect
 push dword [ebp+.hWnd]
 call GetClientRect
 invoke GL_Resize,dword [crect+RECT.right],dword [crect+RECT.bottom]
 jmp short .done
.destroy:
 invoke KillOpenGL,dword [ebp+.hWnd]
 push dword 0
 call PostQuitMessage
 jmp short .done
.key:
 cmp dword [ebp+.wParam],VK_ESCAPE
 jz .esc
 jmp .def
.esc:
 push dword 0
 push dword 0
 push dword WM_CLOSE
 push dword [ebp+.hWnd]
 call PostMessage
 jmp short .done
.done:
 sub eax,eax
.exit:
ENDP

_WinMain:
 push dword 0
 call GetModuleHandle
 mov [dword wc+WNDCLASSEX.hInstance],eax
 push dword IDC_ARROW
 push dword 0
 call LoadCursor
 mov [dword wc+WNDCLASSEX.hCursor],eax
 push dword wc
 call RegisterClassEx
 push dword 0
 push dword [wc+WNDCLASSEX.hInstance]
 push dword 0
 push dword 0
 push dword 300
 push dword 300
 push dword 16
 push dword 16
 push dword WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS
 push dword WinTitleString
 push dword MyClassName
 push dword 0
 call CreateWindowEx
 mov [hWnd],eax
 push dword SW_SHOWDEFAULT
 push eax
 call ShowWindow
 push dword [hWnd]
 call UpdateWindow
winmainmsgloop:
 push dword 0
 push dword 0
 push dword [hWnd]
 call InvalidateRect ; forse WM_PAINT
 sub eax,eax
 mov edi,dword msg
 push eax
 push eax
 push eax
 push edi
 call GetMessage
 test eax,eax
 jz quitmsgposted
 push edi
 push edi
 call TranslateMessage
 call DispatchMessage
 jmp winmainmsgloop
quitmsgposted:
 mov eax,[dword msg+MSG.wParam]
 push eax
 call ExitProcess



PROC glTorus,majorRadius,minorRadius,numMajor,numMinor
var baseMat
var majorStep,minorStep
var a,b
var sin0,cos0,sin1,cos1
;* normals
var n0X,n0Y,n0Z,n1X,n1Y,n1Z
;* vertices
var v0X,v0Y,v0Z,v1X,v1Y,v1Z
endvar
 fldpi
 fadd st0,st0
 fld st0
 fidiv dword [ebp+.numMinor]
 fxch
 fidiv dword [ebp+.numMajor]  ; FPU: majorStep=2PI/numMajor, minorStep=2PI/numMinor
 mov ecx,[ebp+.numMajor]
 fstp dword [ebp+.majorStep]
 fstp dword [ebp+.minorStep]
.majorLoop:
 push ecx
 mov eax,[ebp+.numMajor]
 sub eax,ecx
 push eax
 fild dword [esp]
 fmul dword [ebp+.majorStep]
 fld st0
 fadd dword [ebp+.majorStep]  ; b,a
 fsincos                      ; cos(b),sin(b),a
 fxch st2                     ; a,sin(b),cos(b)
 fsincos                      ; cos(a),sin(a),sin(b),cos(b),majorStep,minorStep
 pop eax
 and eax,1
 mov [ebp+.baseMat],eax
 fstp dword [ebp+.cos0]
 fstp dword [ebp+.sin0]
 fstp dword [ebp+.sin1]
 fstp dword [ebp+.cos1]
 _glBegin GL_TRIANGLE_STRIP
 mov ecx,[ebp+.numMinor]
.minorLoop:
 push ecx
 mov eax,dword [ebp+.numMinor]
 sub eax,ecx
 push eax
 fild dword [esp]
 fmul dword [ebp+.minorStep]
 fsincos           ; cos(x),sin(x)
 fld st0
 fmul dword [ebp+.minorRadius]
 fadd dword [ebp+.majorRadius]  ; r=cos(x)*minorRadius+majorRadius,cos(x),sin(x)
 fxch st2
 fmul dword [ebp+.minorRadius]  ; z=minorRadius*sin(x),cos(x),r
 fxch                           ; cos(x),z,r
 ; calc normals & vertices
 fld st0
 fmul dword [ebp+.cos0]
 fstp dword [ebp+.n0X]
 fld st0
 fmul dword [ebp+.sin0]
 fstp dword [ebp+.n0Y]
 fld st0
 fmul dword [ebp+.cos1]
 fstp dword [ebp+.n1X]
 fmul dword [ebp+.sin1]
 fstp dword [ebp+.n1Y]
 fst dword [ebp+.v0Z]
 fst dword [ebp+.v1Z]
 fdiv dword [ebp+.minorRadius]
 fst dword [ebp+.n0Z]
 fstp dword [ebp+.n1Z]
 fld st0
 fmul dword [ebp+.cos0]
 fstp dword [ebp+.v0X]
 fld st0
 fmul dword [ebp+.sin0]
 fstp dword [ebp+.v0Y]
 fld st0
 fmul dword [ebp+.cos1]
 fstp dword [ebp+.v1X]
 fmul dword [ebp+.sin1]
 fstp dword [ebp+.v1Y]
 pop eax
 and eax,1
 add eax,[ebp+.baseMat]
 and eax,1
 invoke SelectMaterial,eax
 _glNormal3f ebp+.n0X,ebp+.n0Y,ebp+.n0Z
 _glVertex3f ebp+.v0X,ebp+.v0Y,ebp+.v0Z
 _glNormal3f ebp+.n1X,ebp+.n1Y,ebp+.n1Z
 _glVertex3f ebp+.v1X,ebp+.v1Y,ebp+.v1Z
 pop ecx
 dec ecx
 jns near .minorLoop
 _glEnd
 pop ecx
 dec ecx
 jnz near .majorLoop
ENDP


PROC GL_Paint
nolocals
 cmp dword [hRC],0
 jz near .exit
 ;**** clear framebuffer and depth-buffer
 push dword GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT
 call glClear
 ;**** rotate torus
 call glPushMatrix ; push viewer's matrix
 _glMatrixMode GL_MODELVIEW
 _glRotatef Roll,0.0,1.0,0.0 ; rotate around Y axis
 fld dword [Roll]
 fadd dword [rotstep]
 fstp dword [Roll]
 _glRotatef Roll,1.0,0.0,0.0 ; rotate around X axis

 ;**** draw torus
 push dword 24
 push dword 32
 gl_fpush 0.2
 gl_fpush 0.6
 call glTorus

 ;**** finish
 call glPopMatrix
 call glFinish
 push dword [hDC]
 call SwapBuffers
.exit:
ENDP
