/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.jpcap.capture.CaptureDeviceOpenException;
import net.sourceforge.jpcap.capture.CapturePacketException;
import net.sourceforge.jpcap.capture.PacketCapture;
import net.sourceforge.jpcap.capture.RawPacketListener;
import net.sourceforge.jpcap.net.RawPacket;

public class Mognet
implements RawPacketListener {
    private static final Object[] captureCols = new Object[]{"Type", "Source", "Dest", "SSID"};
    private static JTable captureTable = null;
    private static DefaultTableModel captureTableModel = null;
    private static JScrollPane captureScrollPane = null;
    private static JScrollBar captureScrollBar = null;
    private static JTextArea detailArea = null;
    private static JScrollPane detailScrollPane = null;
    private static JScrollBar detailScrollBar = null;
    private static JTable hexTable = null;
    private static DefaultTableModel hexTableModel = null;
    private static JScrollPane hexScrollPane = null;
    private static final int hexRowSize = 8;
    private static JTable asciiTable = null;
    private static DefaultTableModel asciiTableModel = null;
    private static JScrollPane asciiScrollPane = null;
    private static final int asciiRowSize = 8;
    private static JMenuItem fileMenuLoad = null;
    private static JCheckBoxMenuItem captureMenuStart = null;
    private static JCheckBoxMenuItem captureMenuStop = null;
    private static JCheckBoxMenuItem modeMenuSimple = null;
    private static JCheckBoxMenuItem modeMenuAdvanced = null;
    private static JCheckBoxMenuItem filterMenuAll = null;
    private static JCheckBoxMenuItem filterMenuData = null;
    private static JCheckBoxMenuItem filterMenuControl = null;
    private static JCheckBoxMenuItem filterMenuManagement = null;
    private static Container contents = null;
    private static JFrame frame = null;
    private static JSplitPane splitPane = null;
    private static JTabbedPane tabbedPane = null;
    private static JLabel status = null;
    private static Vector frameVector = null;
    private static int vectorSize = 100;
    private static int frameCount = 0;
    private static boolean captureEnabled = false;
    private static boolean simpleMode = false;

    public void rawPacketArrived(RawPacket rawPacket) {
        if (!captureEnabled) {
            return;
        }
        Mognet.addFrame(rawPacket);
    }

    public static void addFrame(RawPacket rawPacket) {
        byte[] byArray = rawPacket.getData();
        int n = (byArray[0] & 0xC) >> 2;
        int n2 = (byArray[0] & 0xF0) >> 4;
        int n3 = n << 4 | n2;
        int n4 = byArray[1] & 1;
        int n5 = byArray[1] & 2;
        Object[] objectArray = new Object[4];
        byte[] byArray2 = new byte[6];
        byte[] byArray3 = new byte[6];
        objectArray[0] = (String)P80211.subtypeHash.get(new Integer(n3));
        switch (n3) {
            case 32: {
                if (n4 == 0 && n5 == 0) {
                    System.arraycopy(byArray, 4, byArray2, 0, 6);
                    System.arraycopy(byArray, 10, byArray3, 0, 6);
                } else if (n4 == 0 && n5 == 1) {
                    System.arraycopy(byArray, 4, byArray2, 0, 6);
                    System.arraycopy(byArray, 16, byArray3, 0, 6);
                } else if (n4 == 1 && n5 == 0) {
                    System.arraycopy(byArray, 16, byArray2, 0, 6);
                    System.arraycopy(byArray, 10, byArray3, 0, 6);
                } else if (n4 == 1 && n5 == 1) {
                    System.arraycopy(byArray, 16, byArray2, 0, 6);
                    System.arraycopy(byArray, 24, byArray3, 0, 6);
                }
                objectArray[1] = MognetUtils.getHex(byArray3);
                objectArray[2] = MognetUtils.getHex(byArray2);
                objectArray[3] = new String();
                break;
            }
            case 8: {
                System.arraycopy(byArray, 4, byArray2, 0, 6);
                System.arraycopy(byArray, 10, byArray3, 0, 6);
                int n6 = byArray[37] & 0xFF;
                byte[] byArray4 = new byte[n6];
                if (38 + n6 < byArray.length) {
                    System.arraycopy(byArray, 38, byArray4, 0, n6);
                }
                objectArray[1] = MognetUtils.getHex(byArray3);
                objectArray[2] = MognetUtils.getHex(byArray2);
                objectArray[3] = new String(byArray4);
                break;
            }
            default: {
                objectArray[1] = new String();
                objectArray[2] = objectArray[1];
                objectArray[3] = objectArray[1];
            }
        }
        captureTableModel.addRow(objectArray);
        captureScrollBar.setValue(captureScrollBar.getMaximum());
        if (simpleMode) {
            frameVector.add(frameCount, null);
        } else {
            frameVector.add(frameCount, byArray);
        }
        ++frameCount;
    }

    private void layoutGui() {
        frame = new JFrame("Mognet");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        contents = frame.getContentPane();
        contents.setLayout(new BorderLayout());
        status = new JLabel("Click Capture/Start to begin");
        JMenuBar jMenuBar = new JMenuBar();
        frame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        fileMenuLoad = new JMenu("Load Frames from File");
        fileMenuLoad.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                fileMenuLoad.removeAll();
                File[] fileArray = new File(".").listFiles();
                int n = 0;
                int n2 = 0;
                while (n2 < fileArray.length) {
                    object = fileArray[n2].toString();
                    if (((String)object).indexOf("mognet-") != -1 && ((String)object).endsWith(".log")) {
                        JMenuItem jMenuItem = new JMenuItem((String)object);
                        jMenuItem.addActionListener(new LoadListener((String)object, status));
                        fileMenuLoad.add(jMenuItem);
                        ++n;
                    }
                    ++n2;
                }
                if (n == 0) {
                    object = new JMenuItem("No logs found");
                    fileMenuLoad.add((Component)object);
                }
            }
        });
        JMenuItem jMenuItem = new JMenuItem("Save Frames to File");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    new LogWriter(frameVector);
                    status.setText("Saved " + frameCount + " frames");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    status.setText("Error saving to file");
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(fileMenuLoad);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        JMenu jMenu2 = new JMenu("Capture");
        jMenu2.setMnemonic(67);
        captureMenuStart = new JCheckBoxMenuItem("Start", captureEnabled);
        captureMenuStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                captureEnabled = !captureEnabled;
                captureMenuStop.setState(false);
                status.setText("Capture started");
            }
        });
        captureMenuStop = new JCheckBoxMenuItem("Stop", !captureEnabled);
        captureMenuStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                captureEnabled = !captureEnabled;
                captureMenuStart.setState(false);
                status.setText("Capture stopped");
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Clear frames");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MognetUtils.clearTable(captureTableModel);
                detailArea.setText("");
                frameCount = 0;
            }
        });
        jMenu2.add(captureMenuStart);
        jMenu2.add(captureMenuStop);
        jMenu2.add(jMenuItem3);
        JMenu jMenu3 = new JMenu("Mode");
        jMenu3.setMnemonic(77);
        modeMenuSimple = new JCheckBoxMenuItem("Simple", simpleMode);
        modeMenuSimple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                simpleMode = !simpleMode;
                modeMenuAdvanced.setState(false);
                splitPane.setBottomComponent(null);
            }
        });
        modeMenuAdvanced = new JCheckBoxMenuItem("Advanced", !simpleMode);
        modeMenuAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                simpleMode = !simpleMode;
                modeMenuSimple.setState(false);
                splitPane.setBottomComponent(tabbedPane);
                splitPane.setDividerLocation(0.5);
            }
        });
        jMenu3.add(modeMenuSimple);
        jMenu3.add(modeMenuAdvanced);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        captureTableModel = new DefaultTableModel(captureCols, 0);
        captureTable = new JTable(captureTableModel);
        captureTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    int n = listSelectionModel.getMinSelectionIndex();
                    byte[] byArray = (byte[])frameVector.elementAt(n);
                    if (byArray != null) {
                        status.setText("Frame number: " + n + ", Frame size: " + byArray.length + " bytes");
                        detailArea.setText(P80211.dissect(byArray));
                        MognetUtils.showHex(byArray, hexTableModel, 8);
                        MognetUtils.showAscii(byArray, asciiTableModel, 8);
                    }
                }
            }
        });
        captureScrollPane = new JScrollPane(captureTable);
        captureScrollBar = captureScrollPane.getVerticalScrollBar();
        detailArea = new JTextArea();
        detailScrollPane = new JScrollPane(detailArea);
        detailScrollBar = detailScrollPane.getVerticalScrollBar();
        Object[] objectArray = new Object[8];
        int n = 0;
        while (n < 8) {
            objectArray[n] = new Integer(n);
            ++n;
        }
        hexTableModel = new DefaultTableModel(0, 8);
        hexTableModel.setColumnIdentifiers(objectArray);
        hexTable = new JTable(hexTableModel);
        hexScrollPane = new JScrollPane(hexTable);
        Object[] objectArray2 = new Object[8];
        int n2 = 0;
        while (n2 < 8) {
            objectArray2[n2] = new Integer(n2);
            ++n2;
        }
        asciiTableModel = new DefaultTableModel(0, 8);
        asciiTableModel.setColumnIdentifiers(objectArray2);
        asciiTable = new JTable(asciiTableModel);
        asciiScrollPane = new JScrollPane(asciiTable);
        tabbedPane = new JTabbedPane(1);
        tabbedPane.insertTab("Detail", null, detailScrollPane, null, 0);
        tabbedPane.insertTab("Hex Dump", null, hexScrollPane, null, 1);
        tabbedPane.insertTab("ASCII Dump", null, asciiScrollPane, null, 2);
        splitPane = new JSplitPane(0, false);
        splitPane.setTopComponent(captureScrollPane);
        if (simpleMode) {
            splitPane.setBottomComponent(null);
        } else {
            splitPane.setBottomComponent(tabbedPane);
        }
        contents.add((Component)splitPane, "Center");
        contents.add((Component)status, "South");
        ((Component)frame).setSize(400, 300);
        frame.show();
        splitPane.setDividerLocation(0.5);
    }

    public Mognet(String string) {
        try {
            if (System.getProperty("os.arch").indexOf("arm") != -1) {
                simpleMode = true;
            }
            P80211.initHash();
            PacketCapture packetCapture = new PacketCapture();
            frameVector = new Vector(vectorSize, vectorSize);
            this.layoutGui();
            packetCapture.addRawPacketListener((RawPacketListener)this);
            packetCapture.open(string, true);
            packetCapture.capture(-1);
        }
        catch (CaptureDeviceOpenException captureDeviceOpenException) {
            System.out.println("Invalid device name passed to Mognet.");
            System.out.println("Check device name and status.");
            System.exit(1);
        }
        catch (CapturePacketException capturePacketException) {
            System.out.println("Device not available.");
            System.out.println("Try 'ifconfig " + string + " up' and re-run Mognet.");
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        if (string == null) {
            System.out.println("Specify a device on the command line, ex: java Mognet eth1");
            System.exit(1);
        }
        new Mognet(string);
    }
}

