/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class P80211 {
    static final int MGT_FRAME = 0;
    static final int CONTROL_FRAME = 1;
    static final int DATA_FRAME = 2;
    static final int DATA_SHORT_HDR_LEN = 24;
    static final int DATA_LONG_HDR_LEN = 30;
    static final int MGT_FRAME_HDR_LEN = 24;
    static final int MGT_ASSOC_REQ = 0;
    static final int MGT_ASSOC_RESP = 1;
    static final int MGT_REASSOC_REQ = 2;
    static final int MGT_REASSOC_RESP = 3;
    static final int MGT_PROBE_REQ = 4;
    static final int MGT_PROBE_RESP = 5;
    static final int MGT_BEACON = 8;
    static final int MGT_ATIM = 9;
    static final int MGT_DISASS = 10;
    static final int MGT_AUTHENTICATION = 11;
    static final int MGT_DEAUTHENTICATION = 12;
    static final int CTRL_PS_POLL = 26;
    static final int CTRL_RTS = 27;
    static final int CTRL_CTS = 28;
    static final int CTRL_ACKNOWLEDGEMENT = 29;
    static final int CTRL_CFP_END = 30;
    static final int CTRL_CFP_ENDACK = 31;
    static final int DATA = 32;
    static final int DATA_CF_ACK = 33;
    static final int DATA_CF_POLL = 34;
    static final int DATA_CF_ACK_POLL = 35;
    static final int DATA_NULL_FUNCTION = 36;
    static final int DATA_CF_ACK_NOD = 37;
    static final int DATA_CF_POLL_NOD = 38;
    static final int DATA_CF_ACK_POLL_NOD = 39;
    static final int FLAG_TO_DS = 1;
    static final int FLAG_FROM_DS = 2;
    static final int FLAG_MORE_FRAGMENTS = 4;
    static final int FLAG_RETRY = 8;
    static final int FLAG_POWER_MGT = 16;
    static final int FLAG_MORE_DATA = 32;
    static final int FLAG_WEP = 64;
    static final int FLAG_ORDER = 128;
    static final int TAG_SSID = 0;
    static final int TAG_SUPP_RATES = 1;
    static final int TAG_FH_PARAMETER = 2;
    static final int TAG_DS_PARAMETER = 3;
    static final int TAG_CF_PARAMETER = 4;
    static final int TAG_TIM = 5;
    static final int TAG_IBSS_PARAMETER = 6;
    static final int TAG_CHALLENGE_TEXT = 16;
    public static Hashtable typeHash = null;
    public static Hashtable subtypeHash = null;
    public static Hashtable tagHash = null;
    public static Hashtable reasonHash = null;
    public static Hashtable statusHash = null;

    public static String dissect(byte[] byArray) {
        byte[] byArray2 = new byte[6];
        byte[] byArray3 = new byte[6];
        byte[] byArray4 = new byte[6];
        int n = byArray[0] & 3;
        int n2 = (byArray[0] & 0xC) >> 2;
        int n3 = (byArray[0] & 0xF0) >> 4;
        int n4 = n2 << 4 | n3;
        int n5 = byArray[1] & 1;
        int n6 = (byArray[1] & 2) >> 1;
        int n7 = (byArray[1] & 4) >> 2;
        int n8 = (byArray[1] & 8) >> 3;
        int n9 = (byArray[1] & 0x10) >> 4;
        int n10 = (byArray[1] & 0x20) >> 5;
        int n11 = (byArray[1] & 0x40) >> 6;
        int n12 = (byArray[1] & 0x80) >> 7;
        int n13 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n14 = byArray[23] & 0xF;
        int n15 = (byArray[23] & 0xF0) << 4 | (byArray[22] & 0xF) << 4 | (byArray[22] & 0xF0) >> 4;
        switch (n2) {
            case 2: {
                if (n5 == 0 && n6 == 0) {
                    System.arraycopy(byArray, 4, byArray2, 0, 6);
                    System.arraycopy(byArray, 10, byArray3, 0, 6);
                    System.arraycopy(byArray, 16, byArray4, 0, 6);
                    break;
                }
                if (n5 == 0 && n6 == 1) {
                    System.arraycopy(byArray, 4, byArray2, 0, 6);
                    System.arraycopy(byArray, 16, byArray3, 0, 6);
                    System.arraycopy(byArray, 10, byArray4, 0, 6);
                    break;
                }
                if (n5 == 1 && n6 == 0) {
                    System.arraycopy(byArray, 16, byArray2, 0, 6);
                    System.arraycopy(byArray, 10, byArray3, 0, 6);
                    System.arraycopy(byArray, 4, byArray4, 0, 6);
                    break;
                }
                if (n5 != 1 || n6 != 1) break;
                System.arraycopy(byArray, 16, byArray2, 0, 6);
                System.arraycopy(byArray, 24, byArray3, 0, 6);
                break;
            }
            case 0: {
                System.arraycopy(byArray, 4, byArray2, 0, 6);
                System.arraycopy(byArray, 10, byArray3, 0, 6);
                System.arraycopy(byArray, 16, byArray4, 0, 6);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Source address: " + MognetUtils.getHex(byArray3));
        stringBuffer.append("\nDestination address: " + MognetUtils.getHex(byArray2));
        stringBuffer.append("\nBSS Id: " + MognetUtils.getHex(byArray4));
        stringBuffer.append("\nFragment number: " + n14);
        stringBuffer.append("\nSequence number: " + n15);
        stringBuffer.append("\n");
        stringBuffer.append("\nProtocol version: " + n);
        stringBuffer.append("\nFrame type: " + (String)typeHash.get(new Integer(n2)));
        stringBuffer.append("\nFrame sub-type: " + (String)subtypeHash.get(new Integer(n4)));
        stringBuffer.append("\nFrame entering DS: " + n5);
        stringBuffer.append("\nFrame exiting AP: " + n6);
        stringBuffer.append("\nData is fragmented: " + n7);
        stringBuffer.append("\nFrame is being retransmitted: " + n8);
        stringBuffer.append("\nWill station go to sleep: " + n9);
        stringBuffer.append("\nData buffered for STA at AP: " + n10);
        stringBuffer.append("\nIs WEP enabled: " + n11);
        stringBuffer.append("\nIs strictly ordered: " + n12);
        stringBuffer.append("\nDuration: " + n13);
        stringBuffer.append("\n");
        switch (n4) {
            case 8: {
                stringBuffer.append(P80211.getTimestamp(byArray, 24));
                stringBuffer.append(P80211.getBeaconInterval(byArray, 32));
                stringBuffer.append(P80211.getCapabilityInfo(byArray, 34));
                stringBuffer.append(P80211.getTaggedParams(byArray, 36));
                break;
            }
            case 0: {
                stringBuffer.append(P80211.getCapabilityInfo(byArray, 23));
                stringBuffer.append(P80211.getListenInterval(byArray, 25));
                stringBuffer.append(P80211.getTaggedParams(byArray, 28));
                break;
            }
            case 1: {
                stringBuffer.append(P80211.getCapabilityInfo(byArray, 23));
                stringBuffer.append(P80211.getStatusCode(byArray, 25));
                stringBuffer.append(P80211.getAssociationId(byArray, 27));
                stringBuffer.append(P80211.getTaggedParams(byArray, 30));
                break;
            }
            case 2: {
                stringBuffer.append(P80211.getCapabilityInfo(byArray, 23));
                stringBuffer.append(P80211.getListenInterval(byArray, 25));
                stringBuffer.append(P80211.getCurrentAddress(byArray, 27));
                stringBuffer.append(P80211.getTaggedParams(byArray, 33));
                break;
            }
            case 3: {
                stringBuffer.append(P80211.getCapabilityInfo(byArray, 23));
                stringBuffer.append(P80211.getStatusCode(byArray, 25));
                stringBuffer.append(P80211.getAssociationId(byArray, 27));
                stringBuffer.append(P80211.getTaggedParams(byArray, 29));
                break;
            }
            case 4: {
                stringBuffer.append(P80211.getTaggedParams(byArray, 24));
                break;
            }
            case 5: {
                stringBuffer.append(P80211.getTimestamp(byArray, 24));
                stringBuffer.append(P80211.getBeaconInterval(byArray, 32));
                stringBuffer.append(P80211.getCapabilityInfo(byArray, 34));
                stringBuffer.append(P80211.getTaggedParams(byArray, 36));
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                stringBuffer.append(P80211.getReasonCode(byArray, 23));
                break;
            }
            case 11: {
                stringBuffer.append(P80211.getAuthAlgNumber(byArray, 23));
                stringBuffer.append(P80211.getAuthSeqNumber(byArray, 25));
                stringBuffer.append(P80211.getStatusCode(byArray, 27));
                stringBuffer.append(P80211.getTaggedParams(byArray, 29));
                break;
            }
            case 12: {
                stringBuffer.append(P80211.getReasonCode(byArray, 23));
                break;
            }
            case 26: {
                stringBuffer.append(P80211.getAssociationId(byArray, 4));
                stringBuffer.append(P80211.getBSSID(byArray, 6));
                stringBuffer.append(P80211.getTransmitterAddress(byArray, 10));
                break;
            }
            case 27: {
                stringBuffer.append(P80211.getReceiverAddress(byArray, 4));
                stringBuffer.append(P80211.getTransmitterAddress(byArray, 10));
                break;
            }
            case 28: {
                stringBuffer.append(P80211.getReceiverAddress(byArray, 4));
                break;
            }
            case 29: {
                stringBuffer.append(P80211.getReceiverAddress(byArray, 4));
                break;
            }
            case 30: {
                stringBuffer.append(P80211.getReceiverAddress(byArray, 4));
                stringBuffer.append(P80211.getBSSID(byArray, 10));
                break;
            }
            case 31: {
                stringBuffer.append(P80211.getReceiverAddress(byArray, 4));
                stringBuffer.append(P80211.getBSSID(byArray, 10));
            }
        }
        return stringBuffer.toString();
    }

    private static String getReceiverAddress(byte[] byArray, int n) {
        byte[] byArray2 = new byte[6];
        System.arraycopy(byArray, n, byArray2, 0, 6);
        return new String("\nReceiver address: " + MognetUtils.getHex(byArray2));
    }

    private static String getTransmitterAddress(byte[] byArray, int n) {
        byte[] byArray2 = new byte[6];
        System.arraycopy(byArray, n, byArray2, 0, 6);
        return new String("\nTransmitter address: " + MognetUtils.getHex(byArray2));
    }

    private static String getBSSID(byte[] byArray, int n) {
        byte[] byArray2 = new byte[6];
        System.arraycopy(byArray, n, byArray2, 0, 6);
        return new String("\nBSS Id: " + MognetUtils.getHex(byArray2));
    }

    private static String getAuthAlgNumber(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        String string = n2 == 0 ? "Open System" : "Shared Key";
        return new String("\nAuthentication type: " + string);
    }

    private static String getAuthSeqNumber(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String("\nAuthentication sequence number: " + n2);
    }

    private static String getTimestamp(byte[] byArray, int n) {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 24, byArray2, 0, 8);
        return new String("\nTimestamp: 0x" + MognetUtils.getHex(byArray2));
    }

    private static String getBeaconInterval(byte[] byArray, int n) {
        float f = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String("\nBeacon interval: " + f / 1000.0f + " seconds");
    }

    private static String getCapabilityInfo(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String("\nCapability info: 0x" + Integer.toHexString(n2));
    }

    private static String getListenInterval(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String("\nListen interval: 0x" + Integer.toHexString(n2));
    }

    private static String getStatusCode(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String("\nStatus code: " + statusHash.get(new Integer(n2)));
    }

    private static String getAssociationId(byte[] byArray, int n) {
        int n2 = (byArray[28] & 0xDF) << 8 | byArray[27] & 0xFF;
        return new String("\nAssociation ID: " + n2);
    }

    private static String getReasonCode(byte[] byArray, int n) {
        int n2 = (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return new String("\nReason code: " + reasonHash.get(new Integer(n2)));
    }

    private static String getCurrentAddress(byte[] byArray, int n) {
        byte[] byArray2 = new byte[6];
        System.arraycopy(byArray, n, byArray2, 0, 6);
        return "\nCurrent address: " + MognetUtils.getHex(byArray2);
    }

    private static String getTaggedParams(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n + 1 < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            String string = (String)tagHash.get(new Integer(n2));
            int n3 = byArray[n + 1] & 0xFF;
            byte[] byArray2 = new byte[n3];
            if (n + 2 + n3 > byArray.length) {
                return new String("\nInvalid Tag Parameters: Frame Possibly Corrupt");
            }
            System.arraycopy(byArray, n + 2, byArray2, 0, n3);
            switch (n2) {
                case 0: {
                    stringBuffer.append("\n" + string + ": " + new String(byArray2));
                    break;
                }
                case 1: {
                    stringBuffer.append("\n" + string + ": ");
                    int n4 = 0;
                    while (n4 < byArray2.length) {
                        int n5 = byArray2[n4] & 0x7F;
                        stringBuffer.append(n5 * 500 / 1000 + " ");
                        ++n4;
                    }
                    break;
                }
                case 2: {
                    stringBuffer.append("\n" + string + ": " + MognetUtils.getHex(byArray2));
                    break;
                }
                case 3: {
                    stringBuffer.append("\n" + string + ": " + new Integer(byArray2[0]));
                    break;
                }
                case 4: {
                    stringBuffer.append("\n" + string + ": " + MognetUtils.getHex(byArray2));
                    break;
                }
                case 5: {
                    stringBuffer.append("\n" + string + ": " + MognetUtils.getHex(byArray2));
                    break;
                }
                case 6: {
                    stringBuffer.append("\n" + string + ": " + MognetUtils.getHex(byArray2));
                    break;
                }
                case 16: {
                    stringBuffer.append("\n" + string + ": " + new String(byArray2));
                    break;
                }
                default: {
                    stringBuffer.append("\n" + string + ": " + MognetUtils.getHex(byArray2));
                }
            }
            n += n3 + 2;
        }
        return stringBuffer.toString();
    }

    public static void initHash() {
        typeHash = new Hashtable();
        typeHash.put(new Integer(0), "Management Frame");
        typeHash.put(new Integer(1), "Control Frame");
        typeHash.put(new Integer(2), "Data Frame");
        subtypeHash = new Hashtable();
        subtypeHash.put(new Integer(0), "Association Request");
        subtypeHash.put(new Integer(1), "Association Response");
        subtypeHash.put(new Integer(2), "Reassociation Request");
        subtypeHash.put(new Integer(3), "Reassociation Response");
        subtypeHash.put(new Integer(4), "Probe Request");
        subtypeHash.put(new Integer(5), "Probe Response");
        subtypeHash.put(new Integer(8), "Beacon frame");
        subtypeHash.put(new Integer(9), "ATIM");
        subtypeHash.put(new Integer(10), "Dissassociate");
        subtypeHash.put(new Integer(11), "Authentication");
        subtypeHash.put(new Integer(12), "Deauthentication");
        subtypeHash.put(new Integer(26), "Power-Save poll");
        subtypeHash.put(new Integer(27), "Request-to-send");
        subtypeHash.put(new Integer(28), "Clear-to-send");
        subtypeHash.put(new Integer(29), "Acknowledgement");
        subtypeHash.put(new Integer(30), "CF-End (Control-frame)");
        subtypeHash.put(new Integer(31), "CF-End + CF-Ack (Control-frame)");
        subtypeHash.put(new Integer(32), "Data");
        subtypeHash.put(new Integer(33), "Data + CF-Acknowledgement");
        subtypeHash.put(new Integer(34), "Data + CF-Poll");
        subtypeHash.put(new Integer(35), "Data + CF-Acknowledgement/Poll");
        subtypeHash.put(new Integer(36), "Null function (No data)");
        subtypeHash.put(new Integer(37), "Data + Acknowledgement (No data)");
        subtypeHash.put(new Integer(38), "Data + CF-Poll (No data)");
        subtypeHash.put(new Integer(39), "Data + CF-Acknowledgement/Poll (No data)");
        tagHash = new Hashtable();
        tagHash.put(new Integer(0), "SSID");
        tagHash.put(new Integer(1), "Supported Rates");
        tagHash.put(new Integer(2), "FH Parameters");
        tagHash.put(new Integer(3), "Current Channel");
        tagHash.put(new Integer(4), "CF Parameters");
        tagHash.put(new Integer(5), "Traffic Indication Map");
        tagHash.put(new Integer(6), "IBSS Parameters");
        tagHash.put(new Integer(16), "Challenge Text");
        reasonHash = new Hashtable();
        reasonHash.put(new Integer(0), "Reserved");
        reasonHash.put(new Integer(1), "Unspecified reason");
        reasonHash.put(new Integer(2), "Previous authentication no longer valid");
        reasonHash.put(new Integer(3), "Deauthenticated because sending STA is leaving (has left) IBSS or ESS");
        reasonHash.put(new Integer(4), "Disassociated due to inactivity");
        reasonHash.put(new Integer(5), "Disassociated because AP is unable to handle all currently associated stations");
        reasonHash.put(new Integer(6), "Class 2 frame received from nonauthenticated station");
        reasonHash.put(new Integer(7), "Class 3 frame received from nonassociated station");
        reasonHash.put(new Integer(8), "Disassociated because sending STA is leaving (has left) BSS");
        reasonHash.put(new Integer(9), "Station requesting (re)association is not authenticated with responding station");
        statusHash = new Hashtable();
        statusHash.put(new Integer(0), "Successful");
        statusHash.put(new Integer(1), "Unspecified failure");
        statusHash.put(new Integer(10), "Cannot support all requested capabilities in the Capability information field");
        statusHash.put(new Integer(11), "Reassociation denied due to inability to confirm that association exists");
        statusHash.put(new Integer(12), "Association denied due to reason outside the scope of this standard");
        statusHash.put(new Integer(13), "Responding station does not support the specified authentication algorithm");
        statusHash.put(new Integer(14), "Received an Authentication frame with authentication sequence transaction sequence number out of expected sequence");
        statusHash.put(new Integer(15), "Authentication rejected because of challenge failure");
        statusHash.put(new Integer(16), "Authentication rejected due to timeout waiting for next frame in sequence");
        statusHash.put(new Integer(17), "Association denied because AP is unable to handle additional associated stations");
        statusHash.put(new Integer(18), "Association denied due to requesting station not supporting all of the datarates in the BSSBasicServiceSet Parameter");
    }
}

