#!/bin/sh

export BUILD_ROOT=`pwd`			# build home
export JAVA_HOME=/usr/lib/java		# location of java vm
export SHARED_PCAP=false			# false=static, true=shared
export SYS_TYPE=i386			# armv4l for StrongARM cpus
export HOSTTYPE=i386			# host os architecture
export OSTYPE=linux			# host os type

#sanity checks
if [ ! -r libpcap-*gz ]; then
        echo libpcap-current.tar.gz not found in current directory.
        exit 1
fi

if [ ! -r jpcap-*gz ]; then
	echo jpcap*.tar.gz not found in current directory.
	exit 1
fi

if [ ! -d $JAVA_HOME ];	then
	echo Java not found at $JAVA_HOME
	exit 1
fi


if [ -d $JAVA_HOME/jre ]; then
	export VM_HOME=$JAVA_HOME/jre
else
	echo Your JAVA_HOME environment points to a JRE, not a JDK.
	echo A JDK is required to compile jpcap.
	echo After jpcap is compiled, Mognet can be run
	echo with either a JDK or a JRE.
	echo
	echo Please obtain a JDK and re-run the install script.
	exit 1
fi


#copies symbol.ttf to jvm's font directory
if [ ! -r $VM_HOME/lib/fonts/symbol.ttf ]; then
	cp misc/symbol.ttf $JAVA_HOME/jre/lib/fonts
	echo symbol.ttf --symbol-medium-r-normal--*-%d-*-*-p-*-adobe-fontspecific >> $JAVA_HOME/jre/lib/fonts/fonts.dir
fi


#decompress libpcap, compile and install to /usr/local/lib
cd $BUILD_ROOT
tar zxf libpcap-*.tar.gz
cd libpcap-*
./configure
if [ $SHARED_PCAP == true ]; then
	patch -tp1 < ../misc/libpcap-shared.patch
fi
make
make install
if [ $SHARED_PCAP == true ]; then
	cp libpcap-*.so /usr/local/lib
	ldconfig /usr/local/lib
fi

#decompress jpcap, set to compile with our recently compiled 
#libpcap (shared or static), compile the shared object, install
cd $BUILD_ROOT
tar zxf jpcap-*.tar.gz
cd jpcap-*
cp jars/net*.jar $JAVA_HOME/jre/lib/ext
cd src/java/net/sourceforge/jpcap/capture
rm libjpcap.so
export MAKE_HOME=$BUILD_ROOT/jpcap-*/make

if [ $SHARED_PCAP == true ]; then
	sed s#/usr/lib/libpcap.a#/usr/local/lib/libpcap.so.0#g makefile >> makefile
else
	sed s#/usr/lib/libpcap.a#/usr/local/lib/libpcap.a#g makefile >> makefile
fi

make
cp libjpcap.so $VM_HOME/lib/$SYS_TYPE


#copy the Mognet jar file into the VM's classpath.
cd $BUILD_ROOT
if [ -x $JAVA_HOME/lib/ext/Mognet.jar ]; then
	rm $JAVA_HOME/lib/ext/Mognet.jar
fi
cp Mognet.jar $JAVA_HOME/lib/ext


echo
echo Run Mognet by typing 'java Mognet devicename' [ex: java Mognet eth1]
echo
unset BUILD_ROOT; unset VM_HOME; unset SHARED_PCAP; unset SYS_TYPE; unset HOSTTYPE; unset OSTYPE
