/*
Mognet, 802.11b Frame Analyzer
Copyright (C) 2001 Sean Whalen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import net.sourceforge.jpcap.net.*;
import net.sourceforge.jpcap.util.*;

import java.awt.event.*;
import java.io.*;

import javax.swing.*;

public class LoadListener implements ActionListener
{
	private String filename		=null;
	private JLabel status		=null;

	public LoadListener(String filename, JLabel status)
	{
		this.filename=filename;
		this.status=status;
	}

	private static int bitswap(int bits)
	{
		byte b1,b2,b3,b4;
		b1=(byte)((bits & 0xff000000)>>24);
		b2=(byte)((bits & 0x00ff0000)>>16);
		b3=(byte)((bits & 0x0000ff00)>>8);
		b4=(byte)(bits & 0x000000ff);
		return(b4<<24 | b3<<16 | b2<<8 | b1);
	}

	public void actionPerformed(ActionEvent ev)
	{
		try
		{
			File logfile=new File(filename);
			DataInputStream dis=new DataInputStream(new FileInputStream(logfile));
			
			int magic=bitswap(dis.readInt());
			int versionMajor=bitswap(dis.readInt());
			int thisZone=bitswap(dis.readInt());
			int sigFigs=bitswap(dis.readInt());
			int snaplen=bitswap(dis.readInt());//max packet length
			int network=bitswap(dis.readInt());//data link type
			int frameCount=0;
			long i=24;
			long logSize=logfile.length();

			while(i<logSize)
			{
				int tsSeconds=bitswap(dis.readInt());
				int tsMicroseconds=bitswap(dis.readInt());
				int savedLength=bitswap(dis.readInt());
				int actualLength=bitswap(dis.readInt());
				if(savedLength>65535)
				{
					status.setText("Log file has corrupt entry, loading aborted");
					return;
				}
				byte[] data=new byte[savedLength];
				dis.read(data, 0, data.length);

				RawPacket rawPacket=new RawPacket(new Timeval(tsSeconds, tsMicroseconds), data, 0);
				Mognet.addFrame(rawPacket);
				i+=32+data.length;
				frameCount++;
			}

			status.setText("Loaded "+frameCount+" frames from "+filename);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
}
