/*
Mognet, 802.11b Frame Analyzer
Copyright (C) 2001 Sean Whalen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.io.*;
import java.util.*;

public class LogWriter
{
	private DataOutputStream dos=null;

	public LogWriter() throws IOException
	{
		writeHeader();
	}

	public LogWriter(Vector vector) throws IOException
	{
		writeHeader();
		int saveFrameCount=vector.size();

		for(int i=0; i<saveFrameCount; i++)
		{
			byte[] data=(byte[])vector.get(i);
			write(data);
		}
	}

	private void writeHeader() throws IOException
	{
		File logfile=new File("mognet-"+new Date().getTime()+".log");
		dos=new DataOutputStream(new FileOutputStream(logfile));
		dos.writeInt(0xd4c3b2a1);//magic num
		dos.writeInt(0x02000400);//major/minor version
		dos.writeInt(0x00000000);//zone offset
		dos.writeInt(0x00000000);//offset accuracy
		dos.writeInt(0xffff0000);//mtu
		dos.writeInt(0x69000000);//data link type
	}

	public void write(byte[] data) throws IOException
	{
		if(data!=null)
		{
			dos.writeInt(0);
			dos.writeInt(0);
			dos.writeInt(bitswap(data.length));
			dos.writeInt(bitswap(data.length));
			dos.write(data, 0, data.length);
		}

		dos.flush();
	}

	private static int bitswap(int bits)
	{
		byte b1,b2,b3,b4;
		b1=(byte)((bits & 0xff000000)>>24);
		b2=(byte)((bits & 0x00ff0000)>>16);
		b3=(byte)((bits & 0x0000ff00)>>8);
		b4=(byte)(bits & 0x000000ff);
		return(b4<<24 | b3<<16 | b2<<8 | b1);
	}
}
