/*
Mognet, 802.11b Frame Analyzer
Copyright (C) 2001 Sean Whalen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import javax.swing.table.*;

public class MognetUtils
{
	public static void showHex(byte[] frame, DefaultTableModel model, int rowSize)
	{
		clearTable(model);
		Object[] hexRow=new Object[rowSize];

		for(int i=0; i<frame.length; i++)
		{
			int dec1=(frame[i] & 0xf0) >> 4;
			int dec2=frame[i] & 0x0f;
			hexRow[i%rowSize]=Integer.toHexString(dec1)+Integer.toHexString(dec2);

			if((i+1)%rowSize==0 || i==frame.length-1)
			{
				model.addRow(hexRow);
				if(frame.length-i<rowSize)
				{
					hexRow=new Object[frame.length-i];
				}
			}
		}
	}

	public static void showAscii(byte[] frame, DefaultTableModel model, int rowSize)
	{
		clearTable(model);
		Object[] asciiRow=new Object[rowSize];

		for(int i=0; i<frame.length; i++)
		{
			int dec=frame[i] & 0xff;

			if(dec>=32 && dec<=126)
			{
				asciiRow[i%rowSize]=new Character((char)dec);
			}
			else
			{
				asciiRow[i%rowSize]=new Character('.');
			}

			if((i+1)%rowSize==0 || i==frame.length-1)
			{
				model.addRow(asciiRow);
				if(frame.length-i<rowSize)
				{
					asciiRow=new Object[frame.length-i];
				}
			}
		}
	}

	public static String getHex(byte[] data)
	{
		String hex=new String();

		for(int i=0; i<data.length; i++)
		{
			int dec1=(data[i] & 0xf0) >> 4;
			int dec2=data[i] & 0x0f;
			String hex1=Integer.toHexString(dec1);
			String hex2=Integer.toHexString(dec2);
			hex+=hex1+hex2+" ";
		}

		return hex;
	}

	public static void clearTable(DefaultTableModel model)
	{
		int rows=model.getRowCount();

		if(rows>0)
		{
			for(int i=rows-1; i>=0; i--)
			{
				model.removeRow(i);
			}
		}
	}
}
