// $Id: IPPort.java,v 1.3 2001/06/07 21:50:56 pcharles Exp $

/***************************************************************************
 * Copyright (C) 2001, Patrick Charles and Jonas Lehmann                   *
 * Distributed under the Mozilla Public License                            *
 *   http://www.mozilla.org/NPL/MPL-1.1.txt                                *
 ***************************************************************************/
package net.sourceforge.jpcap.net;

import java.util.HashMap;


/**
 * IP port utility class.
 *
 * @author Patrick Charles and Jonas Lehmann
 * @version $Revision: 1.3 $
 * @lastModifiedBy $Author: pcharles $
 * @lastModifiedAt $Date: 2001/06/07 21:50:56 $
 */
public class IPPort implements IPPorts
{
  /**
   * Fetch a well-known IP port description.
   * @param code the code associated with the description.
   * @return a description of the ip port.
   */
  public static String getDescription(int port) {
    Integer c = new Integer(port);
    if(descriptions.containsKey(c)) 
      return (String)descriptions.get(c);
    else 
      if(port >= X11_BEGIN && port <= X11_END)
        return (String)descriptions.get(new Integer(X11));
    else
      return UNKNOWN;
  }

  /**
   * Fetch a well-known IP port name.
   * @param code the code associated with the name.
   * @return the name of the ip port.
   */
  public static String getName(int port) {
    Integer c = new Integer(port);
    if(names.containsKey(c)) 
      return (String)names.get(c);
    else 
      if(port >= X11_BEGIN && port <= X11_END)
        return (String)names.get(new Integer(X11));
    else 
      return c.toString();
  }

  /**
   * 'Human-readable' IP port descriptions.
   */
  private static HashMap descriptions = new HashMap();
  static {
    // todo: descriptions aren't descriptions
    descriptions.put(new Integer(IPPort.NONE), "no port specified");
    descriptions.put(new Integer(IPPort.RESERVED_0), "port 0 is reserved!");
    descriptions.put(new Integer(IPPort.TCPMUX), "tcpmux");
    descriptions.put(new Integer(IPPort.COMPRESSNET2), "compressnet2");
    descriptions.put(new Integer(IPPort.COMPRESSNET), "compressnet");
    descriptions.put(new Integer(IPPort.RJE), "rje");
    descriptions.put(new Integer(IPPort.ECHO), "echo");
    descriptions.put(new Integer(IPPort.DISCARD), "discard");
    descriptions.put(new Integer(IPPort.SYSTAT), "systat");
    descriptions.put(new Integer(IPPort.DAYTIME), "daytime");
    descriptions.put(new Integer(IPPort.QOTD), "qotd");
    descriptions.put(new Integer(IPPort.MSP), "msp");
    descriptions.put(new Integer(IPPort.CHARGEN), "chargen");
    descriptions.put(new Integer(IPPort.FTP_DATA), "ftp_data");
    descriptions.put(new Integer(IPPort.FTP), "file transfer protocol");
    descriptions.put(new Integer(IPPort.SSH), "secure shell protocol");
    descriptions.put(new Integer(IPPort.TELNET), "remote terminal protocol");
    descriptions.put(new Integer(IPPort.PRIV_MAIL), "priv_mail");
    descriptions.put(new Integer(IPPort.SMTP), "simple mail xfer protocol");
    descriptions.put(new Integer(IPPort.NSW_FE), "nsw_fe");
    descriptions.put(new Integer(IPPort.MSG_ICP), "msg_icp");
    descriptions.put(new Integer(IPPort.MSG_AUTH), "msg_auth");
    descriptions.put(new Integer(IPPort.DSP), "dsp");
    descriptions.put(new Integer(IPPort.PRIV_PRINT), "priv_print");
    descriptions.put(new Integer(IPPort.TIME), "time");
    descriptions.put(new Integer(IPPort.RAP), "rap");
    descriptions.put(new Integer(IPPort.RLP), "rlp");
    descriptions.put(new Integer(IPPort.GRAPHICS), "graphics");
    descriptions.put(new Integer(IPPort.NAME), "name");
    descriptions.put(new Integer(IPPort.NAMESERVER), "nameserver");
    descriptions.put(new Integer(IPPort.NICNAME), "nicname");
    descriptions.put(new Integer(IPPort.MPM_FLAGS), "mpm_flags");
    descriptions.put(new Integer(IPPort.MPM), "mpm");
    descriptions.put(new Integer(IPPort.MPM_SND), "mpm_snd");
    descriptions.put(new Integer(IPPort.NI_FTP), "ni_ftp");
    descriptions.put(new Integer(IPPort.AUDITD), "auditd");
    descriptions.put(new Integer(IPPort.TACACS), "tacacs");
    descriptions.put(new Integer(IPPort.RE_MAIL_CK), "re_mail_ck");
    descriptions.put(new Integer(IPPort.LA_MAINT), "la_maint");
    descriptions.put(new Integer(IPPort.XNS_TIME), "xns_time");
    descriptions.put(new Integer(IPPort.DOMAIN), "domain");
    descriptions.put(new Integer(IPPort.XNS_CH), "xns_ch");
    descriptions.put(new Integer(IPPort.ISI_GL), "isi_gl");
    descriptions.put(new Integer(IPPort.XNS_AUTH), "xns_auth");
    descriptions.put(new Integer(IPPort.PRIV_TERMINAL), "priv_terminal");
    descriptions.put(new Integer(IPPort.XNS_MAIL), "xns_mail");
    descriptions.put(new Integer(IPPort.PRIV_FILE), "priv_file");
    descriptions.put(new Integer(IPPort.NI_MAIL), "ni_mail");
    descriptions.put(new Integer(IPPort.ACAS), "acas");
    descriptions.put(new Integer(IPPort.WHOIS), "whois++");
    descriptions.put(new Integer(IPPort.COVIA), "covia");
    descriptions.put(new Integer(IPPort.TACACS_DS), "tacacs_ds");
    descriptions.put(new Integer(IPPort.SQLSNET), "sql*net");
    descriptions.put(new Integer(IPPort.BOOTPS), "bootps");
    descriptions.put(new Integer(IPPort.BOOTPC), "bootpc");
    descriptions.put(new Integer(IPPort.TFTP), "tftp");
    descriptions.put(new Integer(IPPort.GOPHER), "gopher");
    descriptions.put(new Integer(IPPort.NETRJS_1), "netrjs_1");
    descriptions.put(new Integer(IPPort.NETRJS_2), "netrjs_2");
    descriptions.put(new Integer(IPPort.NETRJS_3), "netrjs_3");
    descriptions.put(new Integer(IPPort.NETRJS_4), "netrjs_4");
    descriptions.put(new Integer(IPPort.PRIV_DIALOUT), "priv_dialout");
    descriptions.put(new Integer(IPPort.DEOS), "deos");
    descriptions.put(new Integer(IPPort.PRIV_RJE), "priv_rje");
    descriptions.put(new Integer(IPPort.VETTCP), "vettcp");
    descriptions.put(new Integer(IPPort.FINGER), "finger");
    descriptions.put(new Integer(IPPort.HTTP), "http");
    descriptions.put(new Integer(IPPort.WWW), "www");
    descriptions.put(new Integer(IPPort.HOSTS2_NS), "hosts2_ns");
    descriptions.put(new Integer(IPPort.XFER), "xfer");
    descriptions.put(new Integer(IPPort.MIT_ML_DEV), "mit_ml_dev");
    descriptions.put(new Integer(IPPort.CTF), "ctf");
    descriptions.put(new Integer(IPPort.MIT_ML_DEV2), "mit_ml_dev");
    descriptions.put(new Integer(IPPort.MFCOBOL), "mfcobol");
    descriptions.put(new Integer(IPPort.PRIV_TERMLINK), "priv_termlink");
    descriptions.put(new Integer(IPPort.KERBEROS), "kerberos");
    descriptions.put(new Integer(IPPort.SU_MIT_TG), "su_mit_tg");
    descriptions.put(new Integer(IPPort.DNSIX), "dnsix");
    descriptions.put(new Integer(IPPort.MIT_DOV), "mit_dov");
    descriptions.put(new Integer(IPPort.NPP), "npp");
    descriptions.put(new Integer(IPPort.DCP), "dcp");
    descriptions.put(new Integer(IPPort.OBJCALL), "objcall");
    descriptions.put(new Integer(IPPort.SUPDUP), "supdup");
    descriptions.put(new Integer(IPPort.DIXIE), "dixie");
    descriptions.put(new Integer(IPPort.SWIFT_RVF), "swift_rvf");
    descriptions.put(new Integer(IPPort.TACNEWS), "tacnews");
    descriptions.put(new Integer(IPPort.METAGRAM), "metagram");
    descriptions.put(new Integer(IPPort.NEWACCT), "newacct");
    descriptions.put(new Integer(IPPort.HOSTNAME), "hostname");
    descriptions.put(new Integer(IPPort.ISO_TSAP), "iso_tsap");
    descriptions.put(new Integer(IPPort.GPPITNP), "gppitnp");
    descriptions.put(new Integer(IPPort.ACR_NEMA), "acr_nema");
    descriptions.put(new Integer(IPPort.CSO), "cso");
    descriptions.put(new Integer(IPPort.CSNET_NS), "csnet_ns");
    descriptions.put(new Integer(IPPort.TSMUX_3COM), "3com_tsmux");
    descriptions.put(new Integer(IPPort.RTELNET), "rtelnet");
    descriptions.put(new Integer(IPPort.SNAGAS), "snagas");
    descriptions.put(new Integer(IPPort.POP2), "pop2");
    descriptions.put(new Integer(IPPort.POP3), "pop3");
    descriptions.put(new Integer(IPPort.SUNRPC), "sunrpc");
    descriptions.put(new Integer(IPPort.MCIDAS), "mcidas");
    descriptions.put(new Integer(IPPort.IDENT), "ident");
    descriptions.put(new Integer(IPPort.AUTH), "auth");
    descriptions.put(new Integer(IPPort.AUDIONEWS), "audionews");
    descriptions.put(new Integer(IPPort.SFTP), "sftp");
    descriptions.put(new Integer(IPPort.ANSANOTIFY), "ansanotify");
    descriptions.put(new Integer(IPPort.UUCP_PATH), "uucp_path");
    descriptions.put(new Integer(IPPort.SQLSERV), "sqlserv");
    descriptions.put(new Integer(IPPort.NNTP), "nntp");
    descriptions.put(new Integer(IPPort.CFDPTKT), "cfdptkt");
    descriptions.put(new Integer(IPPort.ERPC), "erpc");
    descriptions.put(new Integer(IPPort.SMAKYNET), "smakynet");
    descriptions.put(new Integer(IPPort.NTP), "ntp");
    descriptions.put(new Integer(IPPort.ANSATRADER), "ansatrader");
    descriptions.put(new Integer(IPPort.LOCUS_MAP), "locus_map");
    descriptions.put(new Integer(IPPort.NXEDIT), "nxedit");
    descriptions.put(new Integer(IPPort.LOCUS_CON), "locus_con");
    descriptions.put(new Integer(IPPort.GSS_XLICEN), "gss_xlicen");
    descriptions.put(new Integer(IPPort.PWDGEN), "pwdgen");
    descriptions.put(new Integer(IPPort.CISCO_FNA), "cisco_fna");
    descriptions.put(new Integer(IPPort.CISCO_TNA), "cisco_tna");
    descriptions.put(new Integer(IPPort.CISCO_SYS), "cisco_sys");
    descriptions.put(new Integer(IPPort.STATSRV), "statsrv");
    descriptions.put(new Integer(IPPort.INGRES_NET), "ingres_net");
    descriptions.put(new Integer(IPPort.EPMAP), "epmap");
    descriptions.put(new Integer(IPPort.PROFILE), "profile");
    descriptions.put(new Integer(IPPort.NETBIOS_NS), "netbios_ns");
    descriptions.put(new Integer(IPPort.NETBIOS_DGM), "netbios_dgm");
    descriptions.put(new Integer(IPPort.NETBIOS_SSN), "netbios_ssn");
    descriptions.put(new Integer(IPPort.EMFIS_DATA), "emfis_data");
    descriptions.put(new Integer(IPPort.EMFIS_CNTL), "emfis_cntl");
    descriptions.put(new Integer(IPPort.BL_IDM), "bl_idm");
    descriptions.put(new Integer(IPPort.IMAP), "imap");
    descriptions.put(new Integer(IPPort.UMA), "uma");
    descriptions.put(new Integer(IPPort.UAAC), "uaac");
    descriptions.put(new Integer(IPPort.ISO_TP0), "iso_tp0");
    descriptions.put(new Integer(IPPort.ISO_IP), "iso_ip");
    descriptions.put(new Integer(IPPort.JARGON), "jargon");
    descriptions.put(new Integer(IPPort.AED_512), "aed_512");
    descriptions.put(new Integer(IPPort.SQL_NET), "sql_net");
    descriptions.put(new Integer(IPPort.HEMS), "hems");
    descriptions.put(new Integer(IPPort.BFTP), "bftp");
    descriptions.put(new Integer(IPPort.SGMP), "sgmp");
    descriptions.put(new Integer(IPPort.NETSC_PROD), "netsc_prod");
    descriptions.put(new Integer(IPPort.NETSC_DEV), "netsc_dev");
    descriptions.put(new Integer(IPPort.SQLSRV), "sqlsrv");
    descriptions.put(new Integer(IPPort.KNET_CMP), "knet_cmp");
    descriptions.put(new Integer(IPPort.PCMAIL_SRV), "pcmail_srv");
    descriptions.put(new Integer(IPPort.NSS_ROUTING), "nss_routing");
    descriptions.put(new Integer(IPPort.SGMP_TRAPS), "sgmp_traps");
    descriptions.put(new Integer(IPPort.SNMP), "snmp");
    descriptions.put(new Integer(IPPort.SNMPTRAP), "snmptrap");
    descriptions.put(new Integer(IPPort.CMIP_MAN), "cmip_man");
    descriptions.put(new Integer(IPPort.CMIP_AGENT), "cmip_agent");
    descriptions.put(new Integer(IPPort.XNS_COURIER), "xns_courier");
    descriptions.put(new Integer(IPPort.S_NET), "s_net");
    descriptions.put(new Integer(IPPort.NAMP), "namp");
    descriptions.put(new Integer(IPPort.RSVD), "rsvd");
    descriptions.put(new Integer(IPPort.SEND), "send");
    descriptions.put(new Integer(IPPort.PRINT_SRV), "print_srv");
    descriptions.put(new Integer(IPPort.MULTIPLEX), "multiplex");
    descriptions.put(new Integer(IPPort.CL1), "cl1");
    descriptions.put(new Integer(IPPort.XYPLEX_MUX), "xyplex_mux");
    descriptions.put(new Integer(IPPort.MAILQ), "mailq");
    descriptions.put(new Integer(IPPort.VMNET), "vmnet");
    descriptions.put(new Integer(IPPort.GENRAD_MUX), "genrad_mux");
    descriptions.put(new Integer(IPPort.XDMCP), "xdmcp");
    descriptions.put(new Integer(IPPort.NEXTSTEP), "nextstep");
    descriptions.put(new Integer(IPPort.BGP), "bgp");
    descriptions.put(new Integer(IPPort.RIS), "ris");
    descriptions.put(new Integer(IPPort.UNIFY), "unify");
    descriptions.put(new Integer(IPPort.AUDIT), "audit");
    descriptions.put(new Integer(IPPort.OCBINDER), "ocbinder");
    descriptions.put(new Integer(IPPort.OCSERVER), "ocserver");
    descriptions.put(new Integer(IPPort.REMOTE_KIS), "remote_kis");
    descriptions.put(new Integer(IPPort.KIS), "kis");
    descriptions.put(new Integer(IPPort.ACI), "aci");
    descriptions.put(new Integer(IPPort.MUMPS), "mumps");
    descriptions.put(new Integer(IPPort.QFT), "qft");
    descriptions.put(new Integer(IPPort.GACP), "gacp");
    descriptions.put(new Integer(IPPort.PROSPERO), "prospero");
    descriptions.put(new Integer(IPPort.OSU_NMS), "osu_nms");
    descriptions.put(new Integer(IPPort.SRMP), "srmp");
    descriptions.put(new Integer(IPPort.IRC), "irc");
    descriptions.put(new Integer(IPPort.DN6_NLM_AUD), "dn6_nlm_aud");
    descriptions.put(new Integer(IPPort.DN6_SMM_RED), "dn6_smm_red");
    descriptions.put(new Integer(IPPort.DLS), "dls");
    descriptions.put(new Integer(IPPort.DLS_MON), "dls_mon");
    descriptions.put(new Integer(IPPort.SMUX), "smux");
    descriptions.put(new Integer(IPPort.SRC), "src");
    descriptions.put(new Integer(IPPort.AT_RTMP), "at_rtmp");
    descriptions.put(new Integer(IPPort.AT_NBP), "at_nbp");
    descriptions.put(new Integer(IPPort.AT_3), "at_3");
    descriptions.put(new Integer(IPPort.AT_ECHO), "at_echo");
    descriptions.put(new Integer(IPPort.AT_5), "at_5");
    descriptions.put(new Integer(IPPort.AT_ZIS), "at_zis");
    descriptions.put(new Integer(IPPort.AT_7), "at_7");
    descriptions.put(new Integer(IPPort.AT_8), "at_8");
    descriptions.put(new Integer(IPPort.QMTP), "qmtp");
    descriptions.put(new Integer(IPPort.Z39_50), "z39.50");
    descriptions.put(new Integer(IPPort.N914C), "914c_g");
    descriptions.put(new Integer(IPPort.ANET), "anet");
    descriptions.put(new Integer(IPPort.IPX), "ipx");
    descriptions.put(new Integer(IPPort.VMPWSCS), "vmpwscs");
    descriptions.put(new Integer(IPPort.SOFTPC), "softpc");
    descriptions.put(new Integer(IPPort.CAILIC), "CAIlic");
    descriptions.put(new Integer(IPPort.DBASE), "dbase");
    descriptions.put(new Integer(IPPort.MPP), "mpp");
    descriptions.put(new Integer(IPPort.UARPS), "uarps");
    descriptions.put(new Integer(IPPort.IMAP3), "imap3");
    descriptions.put(new Integer(IPPort.FLN_SPX), "fln_spx");
    descriptions.put(new Integer(IPPort.RSH_SPX), "rsh_spx");
    descriptions.put(new Integer(IPPort.CDC), "cdc");
    descriptions.put(new Integer(IPPort.MASQDIALER), "masqdialer");
    descriptions.put(new Integer(IPPort.DIRECT), "direct");
    descriptions.put(new Integer(IPPort.SUR_MEAS), "sur_meas");
    descriptions.put(new Integer(IPPort.INBUSINESS), "inbusiness");
    descriptions.put(new Integer(IPPort.LINK), "link");
    descriptions.put(new Integer(IPPort.DSP3270), "dsp3270");
    descriptions.put(new Integer(IPPort.SUBNTBCST_TFTP), "subntbcst_tftp");
    descriptions.put(new Integer(IPPort.BHFHS), "bhfhs");
    descriptions.put(new Integer(IPPort.RAP2), "rap2");
    descriptions.put(new Integer(IPPort.SET), "set");
    descriptions.put(new Integer(IPPort.YAK_CHAT), "yak_chat");
    descriptions.put(new Integer(IPPort.ESRO_GEN), "esro_gen");
    descriptions.put(new Integer(IPPort.OPENPORT), "openport");
    descriptions.put(new Integer(IPPort.NSIIOPS), "nsiiops");
    descriptions.put(new Integer(IPPort.ARCISDMS), "arcisdms");
    descriptions.put(new Integer(IPPort.HDAP), "hdap");
    descriptions.put(new Integer(IPPort.BGMP), "bgmp");
    descriptions.put(new Integer(IPPort.X_BONE_CTL), "x_bone_ctl");
    descriptions.put(new Integer(IPPort.SST), "sst");
    descriptions.put(new Integer(IPPort.TD_SERVICE), "td_service");
    descriptions.put(new Integer(IPPort.TD_REPLICA), "td_replica");
    descriptions.put(new Integer(IPPort.HTTP_MGMT), "http_mgmt");
    descriptions.put(new Integer(IPPort.PERSONAL_LINK), "personal_link");
    descriptions.put(new Integer(IPPort.CABLEPORT_AX), "cableport_ax");
    descriptions.put(new Integer(IPPort.RESCAP), "rescap");
    descriptions.put(new Integer(IPPort.CORERJD), "corerjd");
    descriptions.put(new Integer(IPPort.FXP_1), "fxp_1");
    descriptions.put(new Integer(IPPort.K_BLOCK), "k_block");
    descriptions.put(new Integer(IPPort.NOVASTORBAKCUP), "novastorbakcup");
    descriptions.put(new Integer(IPPort.ENTRUSTTIME), "entrusttime");
    descriptions.put(new Integer(IPPort.BHMDS), "bhmds");
    descriptions.put(new Integer(IPPort.ASIP_WEBADMIN), "asip_webadmin");
    descriptions.put(new Integer(IPPort.VSLMP), "vslmp");
    descriptions.put(new Integer(IPPort.MAGENTA_LOGIC), "magenta_logic");
    descriptions.put(new Integer(IPPort.OPALIS_ROBOT), "opalis_robot");
    descriptions.put(new Integer(IPPort.DPSI), "dpsi");
    descriptions.put(new Integer(IPPort.DECAUTH), "decauth");
    descriptions.put(new Integer(IPPort.ZANNET), "zannet");
    descriptions.put(new Integer(IPPort.PKIX_TIMESTAMP), "pkix_timestamp");
    descriptions.put(new Integer(IPPort.PTP_EVENT), "ptp_event");
    descriptions.put(new Integer(IPPort.PTP_GENERAL), "ptp_general");
    descriptions.put(new Integer(IPPort.PIP), "pip");
    descriptions.put(new Integer(IPPort.RTSPS), "rtsps");
    descriptions.put(new Integer(IPPort.TEXAR), "texar");
    descriptions.put(new Integer(IPPort.PDAP), "pdap");
    descriptions.put(new Integer(IPPort.PAWSERV), "pawserv");
    descriptions.put(new Integer(IPPort.ZSERV), "zserv");
    descriptions.put(new Integer(IPPort.FATSERV), "fatserv");
    descriptions.put(new Integer(IPPort.CSI_SGWP), "csi_sgwp");
    descriptions.put(new Integer(IPPort.MFTP), "mftp");
    descriptions.put(new Integer(IPPort.MATIP_TYPE_A), "matip_type_a");
    descriptions.put(new Integer(IPPort.MATIP_TYPE_B), "matip_type_b");
    descriptions.put(new Integer(IPPort.BHOETTY), "bhoetty");
    descriptions.put(new Integer(IPPort.DTAG_STE_SB), "dtag_ste_sb");
    descriptions.put(new Integer(IPPort.BHOEDAP4), "bhoedap4");
    descriptions.put(new Integer(IPPort.NDSAUTH), "ndsauth");
    descriptions.put(new Integer(IPPort.BH611), "bh611");
    descriptions.put(new Integer(IPPort.DATEX_ASN), "datex_asn");
    descriptions.put(new Integer(IPPort.CLOANTO_NET), "cloanto_net");
    descriptions.put(new Integer(IPPort.BHEVENT), "bhevent");
    descriptions.put(new Integer(IPPort.SHRINKWRAP), "shrinkwrap");
    descriptions.put(new Integer(IPPort.NSRMP), "nsrmp");
    descriptions.put(new Integer(IPPort.SCOI2ODIALOG), "scoi2odialog");
    descriptions.put(new Integer(IPPort.SEMANTIX), "semantix");
    descriptions.put(new Integer(IPPort.SRSSEND), "srssend");
    descriptions.put(new Integer(IPPort.RSVP_TUNNEL), "rsvp_tunnel");
    descriptions.put(new Integer(IPPort.AURORA_CMGR), "aurora_cmgr");
    descriptions.put(new Integer(IPPort.DTK), "dtk");
    descriptions.put(new Integer(IPPort.ODMR), "odmr");
    descriptions.put(new Integer(IPPort.MORTGAGEWARE), "mortgageware");
    descriptions.put(new Integer(IPPort.QBIKGDP), "qbikgdp");
    descriptions.put(new Integer(IPPort.RPC2PORTMAP), "rpc2portmap");
    descriptions.put(new Integer(IPPort.CODAAUTH), "codaauth");
    descriptions.put(new Integer(IPPort.CLEARCASE), "clearcase");
    descriptions.put(new Integer(IPPort.ULISTPROC), "ulistproc");
    descriptions.put(new Integer(IPPort.LEGENT_1), "legent_1");
    descriptions.put(new Integer(IPPort.LEGENT_2), "legent_2");
    descriptions.put(new Integer(IPPort.HASSLE), "hassle");
    descriptions.put(new Integer(IPPort.NIP), "nip");
    descriptions.put(new Integer(IPPort.TNETOS), "tnETOS");
    descriptions.put(new Integer(IPPort.DSETOS), "dsETOS");
    descriptions.put(new Integer(IPPort.IS99C), "is99c");
    descriptions.put(new Integer(IPPort.IS99S), "is99s");
    descriptions.put(new Integer(IPPort.HP_COLLECTOR), "hp_collector");
    descriptions.put(new Integer(IPPort.HP_MANAGED_NODE), "hp_managed_node");
    descriptions.put(new Integer(IPPort.HP_ALARM_MGR), "hp_alarm_mgr");
    descriptions.put(new Integer(IPPort.ARNS), "arns");
    descriptions.put(new Integer(IPPort.IBM_APP), "ibm_app");
    descriptions.put(new Integer(IPPort.ASA), "asa");
    descriptions.put(new Integer(IPPort.AURP), "aurp");
    descriptions.put(new Integer(IPPort.UNIDATA_LDM), "unidata_ldm");
    descriptions.put(new Integer(IPPort.UIS), "uis");
    descriptions.put(new Integer(IPPort.SYNOTICS_RELAY), "synotics_relay");
    descriptions.put(new Integer(IPPort.SYNOTICS_BROKER), "synotics_broker");
    descriptions.put(new Integer(IPPort.META5), "meta5");
    descriptions.put(new Integer(IPPort.EMBL_NDT), "embl_ndt");
    descriptions.put(new Integer(IPPort.NETCP), "netcp");
    descriptions.put(new Integer(IPPort.NETWARE_IP), "netware_ip");
    descriptions.put(new Integer(IPPort.MPTN), "mptn");
    descriptions.put(new Integer(IPPort.KRYPTOLAN), "kryptolan");
    descriptions.put(new Integer(IPPort.ISO_TSAP_C2), "iso_tsap_c2");
    descriptions.put(new Integer(IPPort.WORK_SOL), "work_sol");
    descriptions.put(new Integer(IPPort.UPS), "ups");
    descriptions.put(new Integer(IPPort.GENIE), "genie");
    descriptions.put(new Integer(IPPort.DECAP), "decap");
    descriptions.put(new Integer(IPPort.NCED), "nced");
    descriptions.put(new Integer(IPPort.NCLD), "ncld");
    descriptions.put(new Integer(IPPort.IMSP), "imsp");
    descriptions.put(new Integer(IPPort.TIMBUKTU), "timbuktu");
    descriptions.put(new Integer(IPPort.PRM_SM), "prm_sm");
    descriptions.put(new Integer(IPPort.PRM_NM), "prm_nm");
    descriptions.put(new Integer(IPPort.DECLADEBUG), "decladebug");
    descriptions.put(new Integer(IPPort.RMT), "rmt");
    descriptions.put(new Integer(IPPort.SYNOPTICS_TRAP), "synoptics_trap");
    descriptions.put(new Integer(IPPort.SMSP), "smsp");
    descriptions.put(new Integer(IPPort.INFOSEEK), "infoseek");
    descriptions.put(new Integer(IPPort.BNET), "bnet");
    descriptions.put(new Integer(IPPort.SILVERPLATTER), "silverplatter");
    descriptions.put(new Integer(IPPort.ONMUX), "onmux");
    descriptions.put(new Integer(IPPort.HYPER_G), "hyper_g");
    descriptions.put(new Integer(IPPort.ARIEL1), "ariel1");
    descriptions.put(new Integer(IPPort.SMPTE), "smpte");
    descriptions.put(new Integer(IPPort.ARIEL2), "ariel2");
    descriptions.put(new Integer(IPPort.ARIEL3), "ariel3");
    descriptions.put(new Integer(IPPort.OPC_JOB_START), "opc_job_start");
    descriptions.put(new Integer(IPPort.OPC_JOB_TRACK), "opc_job_track");
    descriptions.put(new Integer(IPPort.ICAD_EL), "icad_el");
    descriptions.put(new Integer(IPPort.SMARTSDP), "smartsdp");
    descriptions.put(new Integer(IPPort.SVRLOC), "svrloc");
    descriptions.put(new Integer(IPPort.OCS_CMU), "ocs_cmu");
    descriptions.put(new Integer(IPPort.OCS_AMU), "ocs_amu");
    descriptions.put(new Integer(IPPort.UTMPSD), "utmpsd");
    descriptions.put(new Integer(IPPort.UTMPCD), "utmpcd");
    descriptions.put(new Integer(IPPort.IASD), "iasd");
    descriptions.put(new Integer(IPPort.NNSP), "nnsp");
    descriptions.put(new Integer(IPPort.MOBILEIP_AGENT), "mobileip_agent");
    descriptions.put(new Integer(IPPort.MOBILIP_MN), "mobilip_mn");
    descriptions.put(new Integer(IPPort.DNA_CML), "dna_cml");
    descriptions.put(new Integer(IPPort.COMSCM), "comscm");
    descriptions.put(new Integer(IPPort.DSFGW), "dsfgw");
    descriptions.put(new Integer(IPPort.DASP), "dasp");
    descriptions.put(new Integer(IPPort.SGCP), "sgcp");
    descriptions.put(new Integer(IPPort.DECVMS_SYSMGT), "decvms_sysmgt");
    descriptions.put(new Integer(IPPort.CVC_HOSTD), "cvc_hostd");
    descriptions.put(new Integer(IPPort.HTTPS), "https");
    descriptions.put(new Integer(IPPort.SNPP), "snpp");
    descriptions.put(new Integer(IPPort.MICROSOFT_DS), "microsoft_ds");
    descriptions.put(new Integer(IPPort.DDM_RDB), "ddm_rdb");
    descriptions.put(new Integer(IPPort.DDM_DFM), "ddm_dfm");
    descriptions.put(new Integer(IPPort.DDM_SSL), "ddm_ssl");
    descriptions.put(new Integer(IPPort.AS_SERVERMAP), "as_servermap");
    descriptions.put(new Integer(IPPort.TSERVER), "tserver");
    descriptions.put(new Integer(IPPort.SFS_SMP_NET), "sfs_smp_net");
    descriptions.put(new Integer(IPPort.SFS_CONFIG), "sfs_config");
    descriptions.put(new Integer(IPPort.CREATIVESERVER), "creativeserver");
    descriptions.put(new Integer(IPPort.CONTENTSERVER), "contentserver");
    descriptions.put(new Integer(IPPort.CREATIVEPARTNR), "creativepartnr");
    descriptions.put(new Integer(IPPort.MACON_TCP), "macon_tcp");
    descriptions.put(new Integer(IPPort.SCOHELP), "scohelp");
    descriptions.put(new Integer(IPPort.APPLEQTC), "appleqtc");
    descriptions.put(new Integer(IPPort.AMPR_RCMD), "ampr_rcmd");
    descriptions.put(new Integer(IPPort.SKRONK), "skronk");
    descriptions.put(new Integer(IPPort.DATASURFSRV), "datasurfsrv");
    descriptions.put(new Integer(IPPort.DATASURFSRVSEC), "datasurfsrvsec");
    descriptions.put(new Integer(IPPort.ALPES), "alpes");
    descriptions.put(new Integer(IPPort.KPASSWD), "kpasswd");
    descriptions.put(new Integer(IPPort.DIGITAL_VRC), "digital_vrc");
    descriptions.put(new Integer(IPPort.MYLEX_MAPD), "mylex_mapd");
    descriptions.put(new Integer(IPPort.PHOTURIS), "photuris");
    descriptions.put(new Integer(IPPort.RCP), "rcp");
    descriptions.put(new Integer(IPPort.SCX_PROXY), "scx_proxy");
    descriptions.put(new Integer(IPPort.MONDEX), "mondex");
    descriptions.put(new Integer(IPPort.LJK_LOGIN), "ljk_login");
    descriptions.put(new Integer(IPPort.HYBRID_POP), "hybrid_pop");
    descriptions.put(new Integer(IPPort.TN_TL_W1), "tn_tl_w1");
    descriptions.put(new Integer(IPPort.TCPNETHASPSRV), "tcpnethaspsrv");
    descriptions.put(new Integer(IPPort.TN_TL_FD1), "tn_tl_fd1");
    descriptions.put(new Integer(IPPort.SS7NS), "ss7ns");
    descriptions.put(new Integer(IPPort.SPSC), "spsc");
    descriptions.put(new Integer(IPPort.IAFSERVER), "iafserver");
    descriptions.put(new Integer(IPPort.IAFDBASE), "iafdbase");
    descriptions.put(new Integer(IPPort.PH), "ph");
    descriptions.put(new Integer(IPPort.BGS_NSI), "bgs_nsi");
    descriptions.put(new Integer(IPPort.ULPNET), "ulpnet");
    descriptions.put(new Integer(IPPort.INTEGRA_SME), "integra_sme");
    descriptions.put(new Integer(IPPort.POWERBURST), "powerburst");
    descriptions.put(new Integer(IPPort.AVIAN), "avian");
    descriptions.put(new Integer(IPPort.SAFT), "saft");
    descriptions.put(new Integer(IPPort.GSS_HTTP), "gss_http");
    descriptions.put(new Integer(IPPort.NEST_PROTOCOL), "nest_protocol");
    descriptions.put(new Integer(IPPort.MICOM_PFS), "micom_pfs");
    descriptions.put(new Integer(IPPort.GO_LOGIN), "go_login");
    descriptions.put(new Integer(IPPort.TICF_1), "ticf_1");
    descriptions.put(new Integer(IPPort.TICF_2), "ticf_2");
    descriptions.put(new Integer(IPPort.POV_RAY), "pov_ray");
    descriptions.put(new Integer(IPPort.INTECOURIER), "intecourier");
    descriptions.put(new Integer(IPPort.PIM_RP_DISC), "pim_rp_disc");
    descriptions.put(new Integer(IPPort.DANTZ), "dantz");
    descriptions.put(new Integer(IPPort.SIAM), "siam");
    descriptions.put(new Integer(IPPort.ISO_ILL), "iso_ill");
    descriptions.put(new Integer(IPPort.ISAKMP), "isakmp");
    descriptions.put(new Integer(IPPort.STMF), "stmf");
    descriptions.put(new Integer(IPPort.ASA_APPL_PROTO), "asa_appl_proto");
    descriptions.put(new Integer(IPPort.INTRINSA), "intrinsa");
    descriptions.put(new Integer(IPPort.CITADEL), "citadel");
    descriptions.put(new Integer(IPPort.MAILBOX_LM), "mailbox_lm");
    descriptions.put(new Integer(IPPort.OHIMSRV), "ohimsrv");
    descriptions.put(new Integer(IPPort.CRS), "crs");
    descriptions.put(new Integer(IPPort.XVTTP), "xvttp");
    descriptions.put(new Integer(IPPort.SNARE), "snare");
    descriptions.put(new Integer(IPPort.FCP), "fcp");
    descriptions.put(new Integer(IPPort.PASSGO), "passgo");
    descriptions.put(new Integer(IPPort.EXEC), "exec");
    descriptions.put(new Integer(IPPort.LOGIN), "login");
    descriptions.put(new Integer(IPPort.SHELL), "shell");
    descriptions.put(new Integer(IPPort.PRINTER), "printer");
    descriptions.put(new Integer(IPPort.VIDEOTEX), "videotex");
    descriptions.put(new Integer(IPPort.TALK), "talk");
    descriptions.put(new Integer(IPPort.NTALK), "ntalk");
    descriptions.put(new Integer(IPPort.UTIME), "utime");
    descriptions.put(new Integer(IPPort.EFS), "efs");
    descriptions.put(new Integer(IPPort.RIPNG), "ripng");
    descriptions.put(new Integer(IPPort.ULP), "ulp");
    descriptions.put(new Integer(IPPort.IBM_DB2), "ibm_db2");
    descriptions.put(new Integer(IPPort.NCP), "ncp");
    descriptions.put(new Integer(IPPort.TIMED), "timed");
    descriptions.put(new Integer(IPPort.TEMPO	), "tempo");
    descriptions.put(new Integer(IPPort.STX), "stx");
    descriptions.put(new Integer(IPPort.CUSTIX), "custix");
    descriptions.put(new Integer(IPPort.IRC_SERV), "irc_serv");
    descriptions.put(new Integer(IPPort.COURIER), "courier");
    descriptions.put(new Integer(IPPort.CONFERENCE), "conference");
    descriptions.put(new Integer(IPPort.NETNEWS), "netnews");
    descriptions.put(new Integer(IPPort.NETWALL	), "netwall");
    descriptions.put(new Integer(IPPort.MM_ADMIN), "mm_admin");
    descriptions.put(new Integer(IPPort.IIOP), "iiop");
    descriptions.put(new Integer(IPPort.OPALIS_RDV), "opalis_rdv");
    descriptions.put(new Integer(IPPort.NMSP), "nmsp");
    descriptions.put(new Integer(IPPort.GDOMAP), "gdomap");
    descriptions.put(new Integer(IPPort.APERTUS_LDP), "apertus_ldp");
    descriptions.put(new Integer(IPPort.UUCP	), "uucp");
    descriptions.put(new Integer(IPPort.UUCP_RLOGIN), "uucp_rlogin");
    descriptions.put(new Integer(IPPort.COMMERCE), "commerce");
    descriptions.put(new Integer(IPPort.KLOGIN), "klogin");
    descriptions.put(new Integer(IPPort.KSHELL), "kshell");
    descriptions.put(new Integer(IPPort.APPLEQTCSRVR), "appleqtcsrvr");
    descriptions.put(new Integer(IPPort.DHCPV6_CLIENT), "dhcpv6_client");
    descriptions.put(new Integer(IPPort.DHCPV6_SERVER), "dhcpv6_server");
    descriptions.put(new Integer(IPPort.AFPOVERTCP), "afpovertcp");
    descriptions.put(new Integer(IPPort.IDFP), "idfp");
    descriptions.put(new Integer(IPPort.NEW_RWHO), "new_rwho");
    descriptions.put(new Integer(IPPort.CYBERCASH), "cybercash");
    descriptions.put(new Integer(IPPort.DEVICESHARE), "deviceshare");
    descriptions.put(new Integer(IPPort.PIRP), "pirp");
    descriptions.put(new Integer(IPPort.RTSP), "rtsp");
    descriptions.put(new Integer(IPPort.DSF), "dsf");
    descriptions.put(new Integer(IPPort.REMOTEFS), "remotefs");
    descriptions.put(new Integer(IPPort.OPENVMS_SYSIPC), "openvms_sysipc");
    descriptions.put(new Integer(IPPort.SDNSKMP), "sdnskmp");
    descriptions.put(new Integer(IPPort.TEEDTAP), "teedtap");
    descriptions.put(new Integer(IPPort.RMONITOR), "rmonitor");
    descriptions.put(new Integer(IPPort.MONITOR), "monitor");
    descriptions.put(new Integer(IPPort.CHSHELL), "chshell");
    descriptions.put(new Integer(IPPort.NNTPS), "nntps");
    descriptions.put(new Integer(IPPort.N9PFS), "9pfs");
    descriptions.put(new Integer(IPPort.WHOAMI), "whoami");
    descriptions.put(new Integer(IPPort.STREETTALK), "streettalk");
    descriptions.put(new Integer(IPPort.BANYAN_RPC), "banyan_rpc");
    descriptions.put(new Integer(IPPort.MS_SHUTTLE), "ms_shuttle");
    descriptions.put(new Integer(IPPort.MS_ROME), "ms_rome");
    descriptions.put(new Integer(IPPort.METER), "meter");
    descriptions.put(new Integer(IPPort.METER2), "meter2");
    descriptions.put(new Integer(IPPort.SONAR), "sonar");
    descriptions.put(new Integer(IPPort.BANYAN_VIP), "banyan_vip");
    descriptions.put(new Integer(IPPort.FTP_AGENT), "ftp_agent");
    descriptions.put(new Integer(IPPort.VEMMI), "vemmi");
    descriptions.put(new Integer(IPPort.IPCD), "ipcd");
    descriptions.put(new Integer(IPPort.VNAS), "vnas");
    descriptions.put(new Integer(IPPort.IPDD), "ipdd");
    descriptions.put(new Integer(IPPort.DECBSRV), "decbsrv");
    descriptions.put(new Integer(IPPort.SNTP_HEARTBEAT), "sntp_heartbeat");
    descriptions.put(new Integer(IPPort.BDP), "bdp");
    descriptions.put(new Integer(IPPort.SCC_SECURITY), "scc_security");
    descriptions.put(new Integer(IPPort.PHILIPS_VC), "philips_vc");
    descriptions.put(new Integer(IPPort.KEYSERVER), "keyserver");
    descriptions.put(new Integer(IPPort.IMAP4_SSL), "imap4_ssl");
    descriptions.put(new Integer(IPPort.PASSWORD_CHG), "password_chg");
    descriptions.put(new Integer(IPPort.SUBMISSION), "submission");
    descriptions.put(new Integer(IPPort.CAL), "cal");
    descriptions.put(new Integer(IPPort.EYELINK), "eyelink");
    descriptions.put(new Integer(IPPort.TNS_CML), "tns_cml");
    descriptions.put(new Integer(IPPort.HTTP_ALT), "http_alt");
    descriptions.put(new Integer(IPPort.EUDORA_SET), "eudora_set");
    descriptions.put(new Integer(IPPort.HTTP_RPC_EPMAP), "http_rpc_epmap");
    descriptions.put(new Integer(IPPort.TPIP), "tpip");
    descriptions.put(new Integer(IPPort.CAB_PROTOCOL), "cab_protocol");
    descriptions.put(new Integer(IPPort.SMSD), "smsd");
    descriptions.put(new Integer(IPPort.PTCNAMESERVICE), "ptcnameservice");
    descriptions.put(new Integer(IPPort.SCO_WEBSRVRMG3), "sco_websrvrmg3");
    descriptions.put(new Integer(IPPort.ACP), "acp");
    descriptions.put(new Integer(IPPort.IPCSERVER), "ipcserver");
    descriptions.put(new Integer(IPPort.URM), "urm");
    descriptions.put(new Integer(IPPort.NQS), "nqs");
    descriptions.put(new Integer(IPPort.SIFT_UFT), "sift_uft");
    descriptions.put(new Integer(IPPort.NPMP_TRAP), "npmp_trap");
    descriptions.put(new Integer(IPPort.NPMP_LOCAL), "npmp_local");
    descriptions.put(new Integer(IPPort.NPMP_GUI), "npmp_gui");
    descriptions.put(new Integer(IPPort.HMMP_IND), "hmmp_ind");
    descriptions.put(new Integer(IPPort.HMMP_OP), "hmmp_op");
    descriptions.put(new Integer(IPPort.SSHELL), "sshell");
    descriptions.put(new Integer(IPPort.SCO_INETMGR), "sco_inetmgr");
    descriptions.put(new Integer(IPPort.SCO_SYSMGR), "sco_sysmgr");
    descriptions.put(new Integer(IPPort.SCO_DTMGR), "sco_dtmgr");
    descriptions.put(new Integer(IPPort.DEI_ICDA), "dei_icda");
    descriptions.put(new Integer(IPPort.DIGITAL_EVM), "digital_evm");
    descriptions.put(new Integer(IPPort.SCO_WEBSRVRMGR), "sco_websrvrmgr");
    descriptions.put(new Integer(IPPort.ESCP_IP), "escp_ip");
    descriptions.put(new Integer(IPPort.COLLABORATOR), "collaborator");
    descriptions.put(new Integer(IPPort.AUX_BUS_SHUNT), "aux_bus_shunt");
    descriptions.put(new Integer(IPPort.CRYPTOADMIN), "cryptoadmin");
    descriptions.put(new Integer(IPPort.DEC_DLM), "dec_dlm");
    descriptions.put(new Integer(IPPort.ASIA), "asia");
    descriptions.put(new Integer(IPPort.PASSGO_TIVOLI), "passgo_tivoli");
    descriptions.put(new Integer(IPPort.QMQP), "qmqp");
    descriptions.put(new Integer(IPPort.AMP3_3COM), "3com_amp3");
    descriptions.put(new Integer(IPPort.RDA), "rda");
    descriptions.put(new Integer(IPPort.IPP), "ipp");
    descriptions.put(new Integer(IPPort.BMPP), "bmpp");
    descriptions.put(new Integer(IPPort.SERVSTAT), "servstat");
    descriptions.put(new Integer(IPPort.GINAD), "ginad");
    descriptions.put(new Integer(IPPort.RLZDBASE), "rlzdbase");
    descriptions.put(new Integer(IPPort.LDAPS), "ldaps");
    descriptions.put(new Integer(IPPort.LANSERVER), "lanserver");
    descriptions.put(new Integer(IPPort.MCNS_SEC), "mcns_sec");
    descriptions.put(new Integer(IPPort.MSDP), "msdp");
    descriptions.put(new Integer(IPPort.ENTRUST_SPS), "entrust_sps");
    descriptions.put(new Integer(IPPort.REPCMD), "repcmd");
    descriptions.put(new Integer(IPPort.ESRO_EMSDP), "esro_emsdp");
    descriptions.put(new Integer(IPPort.SANITY), "sanity");
    descriptions.put(new Integer(IPPort.DWR), "dwr");
    descriptions.put(new Integer(IPPort.PSSC), "pssc");
    descriptions.put(new Integer(IPPort.LDP), "ldp");
    descriptions.put(new Integer(IPPort.DHCP_FAILOVER), "dhcp_failover");
    descriptions.put(new Integer(IPPort.RRP), "rrp");
    descriptions.put(new Integer(IPPort.AMINET), "aminet");
    descriptions.put(new Integer(IPPort.OBEX), "obex");
    descriptions.put(new Integer(IPPort.IEEE_MMS), "ieee_mms");
    descriptions.put(new Integer(IPPort.HELLO_PORT), "hello_port");
    descriptions.put(new Integer(IPPort.REPSCMD	), "repscmd");
    descriptions.put(new Integer(IPPort.AODV), "aodv");
    descriptions.put(new Integer(IPPort.TINC), "tinc");
    descriptions.put(new Integer(IPPort.SPMP), "spmp");
    descriptions.put(new Integer(IPPort.RMC), "rmc");
    descriptions.put(new Integer(IPPort.TENFOLD), "tenfold");
    descriptions.put(new Integer(IPPort.URL_RENDEZVOUS), "url_rendezvous");
    descriptions.put(new Integer(IPPort.MAC_SRVR_ADMIN), "mac_srvr_admin");
    descriptions.put(new Integer(IPPort.HAP), "hap");
    descriptions.put(new Integer(IPPort.PFTP), "pftp");
    descriptions.put(new Integer(IPPort.PURENOISE), "purenoise");
    descriptions.put(new Integer(IPPort.SECURE_AUX_BUS), "secure_aux_bus");
    descriptions.put(new Integer(IPPort.SUN_DR), "sun_dr");
    descriptions.put(new Integer(IPPort.MDQS), "mdqs");
    descriptions.put(new Integer(IPPort.DOOM), "doom");
    descriptions.put(new Integer(IPPort.DISCLOSE), "disclose");
    descriptions.put(new Integer(IPPort.MECOMM), "mecomm");
    descriptions.put(new Integer(IPPort.MEREGISTER), "meregister");
    descriptions.put(new Integer(IPPort.VACDSM_SWS), "vacdsm_sws");
    descriptions.put(new Integer(IPPort.VACDSM_APP), "vacdsm_app");
    descriptions.put(new Integer(IPPort.VPPS_QUA), "vpps_qua");
    descriptions.put(new Integer(IPPort.CIMPLEX), "cimplex");
    descriptions.put(new Integer(IPPort.ACAP), "acap");
    descriptions.put(new Integer(IPPort.DCTP), "dctp");
    descriptions.put(new Integer(IPPort.VPPS_VIA), "vpps_via");
    descriptions.put(new Integer(IPPort.VPP), "vpp");
    descriptions.put(new Integer(IPPort.GGF_NCP), "ggf_ncp");
    descriptions.put(new Integer(IPPort.MRM), "mrm");
    descriptions.put(new Integer(IPPort.ENTRUST_AAAS), "entrust_aaas");
    descriptions.put(new Integer(IPPort.ENTRUST_AAMS), "entrust_aams");
    descriptions.put(new Integer(IPPort.XFR), "xfr");
    descriptions.put(new Integer(IPPort.CORBA_IIOP), "corba_iiop");
    descriptions.put(new Integer(IPPort.CORBA_IIOP_SSL), "corba_iiop_ssl");
    descriptions.put(new Integer(IPPort.MDC_PORTMAPPER), "mdc_portmapper");
    descriptions.put(new Integer(IPPort.HCP_WISMAR), "hcp_wismar");
    descriptions.put(new Integer(IPPort.ASIPREGISTRY), "asipregistry");
    descriptions.put(new Integer(IPPort.REALM_RUSD), "realm_rusd");
    descriptions.put(new Integer(IPPort.NMAP), "nmap");
    descriptions.put(new Integer(IPPort.VATP), "vatp");
    descriptions.put(new Integer(IPPort.MSEXCH_ROUTING), "msexch_routing");
    descriptions.put(new Integer(IPPort.HYPERWAVE_ISP), "hyperwave_isp");
    descriptions.put(new Integer(IPPort.CONNENDP), "connendp");
    descriptions.put(new Integer(IPPort.HA_CLUSTER), "ha_cluster");
    descriptions.put(new Integer(IPPort.IEEE_MMS_SSL), "ieee_mms_ssl");
    descriptions.put(new Integer(IPPort.RUSHD), "rushd");
    descriptions.put(new Integer(IPPort.UUIDGEN), "uuidgen");
    descriptions.put(new Integer(IPPort.OLSR), "olsr");
    descriptions.put(new Integer(IPPort.ACCESSNETWORK), "accessnetwork");
    descriptions.put(new Integer(IPPort.ELCSD), "elcsd");
    descriptions.put(new Integer(IPPort.AGENTX), "agentx");
    descriptions.put(new Integer(IPPort.SILC), "silc");
    descriptions.put(new Integer(IPPort.BORLAND_DSJ), "borland_dsj");
    descriptions.put(new Integer(IPPort.ENTRUST_KMSH), "entrust_kmsh");
    descriptions.put(new Integer(IPPort.ENTRUST_ASH), "entrust_ash");
    descriptions.put(new Integer(IPPort.CISCO_TDP), "cisco_tdp");
    descriptions.put(new Integer(IPPort.NETVIEWDM1), "netviewdm1");
    descriptions.put(new Integer(IPPort.NETVIEWDM2), "netviewdm2");
    descriptions.put(new Integer(IPPort.NETVIEWDM3), "netviewdm3");
    descriptions.put(new Integer(IPPort.NETGW), "netgw");
    descriptions.put(new Integer(IPPort.NETRCS), "netrcs");
    descriptions.put(new Integer(IPPort.FLEXLM), "flexlm");
    descriptions.put(new Integer(IPPort.FUJITSU_DEV), "fujitsu_dev");
    descriptions.put(new Integer(IPPort.RIS_CM), "ris_cm");
    descriptions.put(new Integer(IPPort.KERBEROS_ADM), "kerberos_adm");
    descriptions.put(new Integer(IPPort.RFILE), "rfile");
    descriptions.put(new Integer(IPPort.PUMP), "pump");
    descriptions.put(new Integer(IPPort.QRH), "qrh");
    descriptions.put(new Integer(IPPort.RRH), "rrh");
    descriptions.put(new Integer(IPPort.TELL), "tell");
    descriptions.put(new Integer(IPPort.NLOGIN), "nlogin");
    descriptions.put(new Integer(IPPort.CON), "con");
    descriptions.put(new Integer(IPPort.NS), "ns");
    descriptions.put(new Integer(IPPort.RXE), "rxe");
    descriptions.put(new Integer(IPPort.QUOTAD), "quotad");
    descriptions.put(new Integer(IPPort.CYCLESERV), "cycleserv");
    descriptions.put(new Integer(IPPort.OMSERV), "omserv");
    descriptions.put(new Integer(IPPort.WEBSTER), "webster");
    descriptions.put(new Integer(IPPort.PHONEBOOK), "phonebook");
    descriptions.put(new Integer(IPPort.VID), "vid");
    descriptions.put(new Integer(IPPort.CADLOCK), "cadlock");
    descriptions.put(new Integer(IPPort.RTIP), "rtip");
    descriptions.put(new Integer(IPPort.CYCLESERV2), "cycleserv2");
    descriptions.put(new Integer(IPPort.SUBMIT), "submit");
    descriptions.put(new Integer(IPPort.RPASSWD), "rpasswd");
    descriptions.put(new Integer(IPPort.ENTOMB), "entomb");
    descriptions.put(new Integer(IPPort.WPAGES), "wpages");
    descriptions.put(new Integer(IPPort.WPGS), "wpgs");
    descriptions.put(new Integer(IPPort.QSC), "qsc");
    descriptions.put(new Integer(IPPort.MDBS_DAEMON), "mdbs_daemon");
    descriptions.put(new Integer(IPPort.ITM_MCELL_S), "itm_mcell_s");
    descriptions.put(new Integer(IPPort.PKIX_3_CA_RA), "pkix_3_ca_ra");
    descriptions.put(new Integer(IPPort.DHCP_FAILOVER2), "dhcp_failover2");
    descriptions.put(new Integer(IPPort.RSYNC), "rsync");
    descriptions.put(new Integer(IPPort.ICLCNET_LOCATE), "iclcnet_locate");
    descriptions.put(new Integer(IPPort.ICLCNET_SVINFO), "iclcnet_svinfo");
    descriptions.put(new Integer(IPPort.ACCESSBUILDER), "accessbuilder");
    descriptions.put(new Integer(IPPort.CDDBP), "cddbp");
    descriptions.put(new Integer(IPPort.OMGINITIALREFS), "omginitialrefs");
    descriptions.put(new Integer(IPPort.SMPNAMERES), "smpnameres");
    descriptions.put(new Integer(IPPort.IDEAFARM_CHAT), "ideafarm_chat");
    descriptions.put(new Integer(IPPort.IDEAFARM_CATCH), "ideafarm_catch");
    descriptions.put(new Integer(IPPort.XACT_BACKUP), "xact_backup");
    descriptions.put(new Integer(IPPort.FTPS_DATA), "ftps_data");
    descriptions.put(new Integer(IPPort.FTPS), "ftps");
    descriptions.put(new Integer(IPPort.NAS), "nas");
    descriptions.put(new Integer(IPPort.TELNETS), "telnets");
    descriptions.put(new Integer(IPPort.IMAPS), "imaps");
    descriptions.put(new Integer(IPPort.IRCS), "ircs");
    descriptions.put(new Integer(IPPort.POP3S), "pop3s");
    descriptions.put(new Integer(IPPort.VSINET), "vsinet");
    descriptions.put(new Integer(IPPort.MAITRD), "maitrd");
    descriptions.put(new Integer(IPPort.BUSBOY), "busboy");
    descriptions.put(new Integer(IPPort.GARCON), "garcon");
    descriptions.put(new Integer(IPPort.PUPROUTER), "puprouter");
    descriptions.put(new Integer(IPPort.CADLOCK2), "cadlock2");
    descriptions.put(new Integer(IPPort.SURF), "surf");
    descriptions.put(new Integer(IPPort.RESERVED_1023), "1023_RESERVED");
    descriptions.put(new Integer(IPPort.RESERVED_1024), "1024_RESERVED");
    descriptions.put(new Integer(IPPort.SOCKS), "socks");
    descriptions.put(new Integer(IPPort.HSRP), "hot standby router");
    descriptions.put(new Integer(IPPort.AISES), "aises");
    descriptions.put(new Integer(IPPort.CVS), "concurrent version system");
    descriptions.put(new Integer(IPPort.X11), "X-Windows");

    // todo: table is incomplete
  }

  /**
   * 'Human-readable' TCP port names.
   */
  private static HashMap names = new HashMap();
  static {
    names.put(new Integer(IPPort.NONE), ".");
    names.put(new Integer(IPPort.RESERVED_0), "0r");
    names.put(new Integer(IPPort.TCPMUX), "tcpmux");
    names.put(new Integer(IPPort.COMPRESSNET2), "compressnet2");
    names.put(new Integer(IPPort.COMPRESSNET), "compressnet");
    names.put(new Integer(IPPort.RJE), "rje");
    names.put(new Integer(IPPort.ECHO), "echo");
    names.put(new Integer(IPPort.DISCARD), "discard");
    names.put(new Integer(IPPort.SYSTAT), "systat");
    names.put(new Integer(IPPort.DAYTIME), "daytime");
    names.put(new Integer(IPPort.QOTD), "qotd");
    names.put(new Integer(IPPort.MSP), "msp");
    names.put(new Integer(IPPort.CHARGEN), "chargen");
    names.put(new Integer(IPPort.FTP_DATA), "ftp_data");
    names.put(new Integer(IPPort.FTP), "ftp");
    names.put(new Integer(IPPort.SSH), "ssh");
    names.put(new Integer(IPPort.TELNET), "telnet");
    names.put(new Integer(IPPort.PRIV_MAIL), "priv_mail");
    names.put(new Integer(IPPort.SMTP), "smtp");
    names.put(new Integer(IPPort.NSW_FE), "nsw_fe");
    names.put(new Integer(IPPort.MSG_ICP), "msg_icp");
    names.put(new Integer(IPPort.MSG_AUTH), "msg_auth");
    names.put(new Integer(IPPort.DSP), "dsp");
    names.put(new Integer(IPPort.PRIV_PRINT), "priv_print");
    names.put(new Integer(IPPort.TIME), "time");
    names.put(new Integer(IPPort.RAP), "rap");
    names.put(new Integer(IPPort.RLP), "rlp");
    names.put(new Integer(IPPort.GRAPHICS), "graphics");
    names.put(new Integer(IPPort.NAME), "name");
    names.put(new Integer(IPPort.NAMESERVER), "nameserver");
    names.put(new Integer(IPPort.NICNAME), "nicname");
    names.put(new Integer(IPPort.MPM_FLAGS), "mpm_flags");
    names.put(new Integer(IPPort.MPM), "mpm");
    names.put(new Integer(IPPort.MPM_SND), "mpm_snd");
    names.put(new Integer(IPPort.NI_FTP), "ni_ftp");
    names.put(new Integer(IPPort.AUDITD), "auditd");
    names.put(new Integer(IPPort.TACACS), "tacacs");
    names.put(new Integer(IPPort.RE_MAIL_CK), "re_mail_ck");
    names.put(new Integer(IPPort.LA_MAINT), "la_maint");
    names.put(new Integer(IPPort.XNS_TIME), "xns_time");
    names.put(new Integer(IPPort.DOMAIN), "domain");
    names.put(new Integer(IPPort.XNS_CH), "xns_ch");
    names.put(new Integer(IPPort.ISI_GL), "isi_gl");
    names.put(new Integer(IPPort.XNS_AUTH), "xns_auth");
    names.put(new Integer(IPPort.PRIV_TERMINAL), "priv_terminal");
    names.put(new Integer(IPPort.XNS_MAIL), "xns_mail");
    names.put(new Integer(IPPort.PRIV_FILE), "priv_file");
    names.put(new Integer(IPPort.NI_MAIL), "ni_mail");
    names.put(new Integer(IPPort.ACAS), "acas");
    names.put(new Integer(IPPort.WHOIS), "whois++");
    names.put(new Integer(IPPort.COVIA), "covia");
    names.put(new Integer(IPPort.TACACS_DS), "tacacs_ds");
    names.put(new Integer(IPPort.SQLSNET), "sql*net");
    names.put(new Integer(IPPort.BOOTPS), "bootps");
    names.put(new Integer(IPPort.BOOTPC), "bootpc");
    names.put(new Integer(IPPort.TFTP), "tftp");
    names.put(new Integer(IPPort.GOPHER), "gopher");
    names.put(new Integer(IPPort.NETRJS_1), "netrjs_1");
    names.put(new Integer(IPPort.NETRJS_2), "netrjs_2");
    names.put(new Integer(IPPort.NETRJS_3), "netrjs_3");
    names.put(new Integer(IPPort.NETRJS_4), "netrjs_4");
    names.put(new Integer(IPPort.PRIV_DIALOUT), "priv_dialout");
    names.put(new Integer(IPPort.DEOS), "deos");
    names.put(new Integer(IPPort.PRIV_RJE), "priv_rje");
    names.put(new Integer(IPPort.VETTCP), "vettcp");
    names.put(new Integer(IPPort.FINGER), "finger");
    names.put(new Integer(IPPort.HTTP), "http");
    names.put(new Integer(IPPort.WWW), "www");
    names.put(new Integer(IPPort.HOSTS2_NS), "hosts2_ns");
    names.put(new Integer(IPPort.XFER), "xfer");
    names.put(new Integer(IPPort.MIT_ML_DEV), "mit_ml_dev");
    names.put(new Integer(IPPort.CTF), "ctf");
    names.put(new Integer(IPPort.MIT_ML_DEV2), "mit_ml_dev");
    names.put(new Integer(IPPort.MFCOBOL), "mfcobol");
    names.put(new Integer(IPPort.PRIV_TERMLINK), "priv_termlink");
    names.put(new Integer(IPPort.KERBEROS), "kerberos");
    names.put(new Integer(IPPort.SU_MIT_TG), "su_mit_tg");
    names.put(new Integer(IPPort.DNSIX), "dnsix");
    names.put(new Integer(IPPort.MIT_DOV), "mit_dov");
    names.put(new Integer(IPPort.NPP), "npp");
    names.put(new Integer(IPPort.DCP), "dcp");
    names.put(new Integer(IPPort.OBJCALL), "objcall");
    names.put(new Integer(IPPort.SUPDUP), "supdup");
    names.put(new Integer(IPPort.DIXIE), "dixie");
    names.put(new Integer(IPPort.SWIFT_RVF), "swift_rvf");
    names.put(new Integer(IPPort.TACNEWS), "tacnews");
    names.put(new Integer(IPPort.METAGRAM), "metagram");
    names.put(new Integer(IPPort.NEWACCT), "newacct");
    names.put(new Integer(IPPort.HOSTNAME), "hostname");
    names.put(new Integer(IPPort.ISO_TSAP), "iso_tsap");
    names.put(new Integer(IPPort.GPPITNP), "gppitnp");
    names.put(new Integer(IPPort.ACR_NEMA), "acr_nema");
    names.put(new Integer(IPPort.CSO), "cso");
    names.put(new Integer(IPPort.CSNET_NS), "csnet_ns");
    names.put(new Integer(IPPort.TSMUX_3COM), "3com_tsmux");
    names.put(new Integer(IPPort.RTELNET), "rtelnet");
    names.put(new Integer(IPPort.SNAGAS), "snagas");
    names.put(new Integer(IPPort.POP2), "pop2");
    names.put(new Integer(IPPort.POP3), "pop3");
    names.put(new Integer(IPPort.SUNRPC), "sunrpc");
    names.put(new Integer(IPPort.MCIDAS), "mcidas");
    names.put(new Integer(IPPort.IDENT), "ident");
    names.put(new Integer(IPPort.AUTH), "auth");
    names.put(new Integer(IPPort.AUDIONEWS), "audionews");
    names.put(new Integer(IPPort.SFTP), "sftp");
    names.put(new Integer(IPPort.ANSANOTIFY), "ansanotify");
    names.put(new Integer(IPPort.UUCP_PATH), "uucp_path");
    names.put(new Integer(IPPort.SQLSERV), "sqlserv");
    names.put(new Integer(IPPort.NNTP), "nntp");
    names.put(new Integer(IPPort.CFDPTKT), "cfdptkt");
    names.put(new Integer(IPPort.ERPC), "erpc");
    names.put(new Integer(IPPort.SMAKYNET), "smakynet");
    names.put(new Integer(IPPort.NTP), "ntp");
    names.put(new Integer(IPPort.ANSATRADER), "ansatrader");
    names.put(new Integer(IPPort.LOCUS_MAP), "locus_map");
    names.put(new Integer(IPPort.NXEDIT), "nxedit");
    names.put(new Integer(IPPort.LOCUS_CON), "locus_con");
    names.put(new Integer(IPPort.GSS_XLICEN), "gss_xlicen");
    names.put(new Integer(IPPort.PWDGEN), "pwdgen");
    names.put(new Integer(IPPort.CISCO_FNA), "cisco_fna");
    names.put(new Integer(IPPort.CISCO_TNA), "cisco_tna");
    names.put(new Integer(IPPort.CISCO_SYS), "cisco_sys");
    names.put(new Integer(IPPort.STATSRV), "statsrv");
    names.put(new Integer(IPPort.INGRES_NET), "ingres_net");
    names.put(new Integer(IPPort.EPMAP), "epmap");
    names.put(new Integer(IPPort.PROFILE), "profile");
    names.put(new Integer(IPPort.NETBIOS_NS), "netbios_ns");
    names.put(new Integer(IPPort.NETBIOS_DGM), "netbios_dgm");
    names.put(new Integer(IPPort.NETBIOS_SSN), "netbios_ssn");
    names.put(new Integer(IPPort.EMFIS_DATA), "emfis_data");
    names.put(new Integer(IPPort.EMFIS_CNTL), "emfis_cntl");
    names.put(new Integer(IPPort.BL_IDM), "bl_idm");
    names.put(new Integer(IPPort.IMAP), "imap");
    names.put(new Integer(IPPort.UMA), "uma");
    names.put(new Integer(IPPort.UAAC), "uaac");
    names.put(new Integer(IPPort.ISO_TP0), "iso_tp0");
    names.put(new Integer(IPPort.ISO_IP), "iso_ip");
    names.put(new Integer(IPPort.JARGON), "jargon");
    names.put(new Integer(IPPort.AED_512), "aed_512");
    names.put(new Integer(IPPort.SQL_NET), "sql_net");
    names.put(new Integer(IPPort.HEMS), "hems");
    names.put(new Integer(IPPort.BFTP), "bftp");
    names.put(new Integer(IPPort.SGMP), "sgmp");
    names.put(new Integer(IPPort.NETSC_PROD), "netsc_prod");
    names.put(new Integer(IPPort.NETSC_DEV), "netsc_dev");
    names.put(new Integer(IPPort.SQLSRV), "sqlsrv");
    names.put(new Integer(IPPort.KNET_CMP), "knet_cmp");
    names.put(new Integer(IPPort.PCMAIL_SRV), "pcmail_srv");
    names.put(new Integer(IPPort.NSS_ROUTING), "nss_routing");
    names.put(new Integer(IPPort.SGMP_TRAPS), "sgmp_traps");
    names.put(new Integer(IPPort.SNMP), "snmp");
    names.put(new Integer(IPPort.SNMPTRAP), "snmptrap");
    names.put(new Integer(IPPort.CMIP_MAN), "cmip_man");
    names.put(new Integer(IPPort.CMIP_AGENT), "cmip_agent");
    names.put(new Integer(IPPort.XNS_COURIER), "xns_courier");
    names.put(new Integer(IPPort.S_NET), "s_net");
    names.put(new Integer(IPPort.NAMP), "namp");
    names.put(new Integer(IPPort.RSVD), "rsvd");
    names.put(new Integer(IPPort.SEND), "send");
    names.put(new Integer(IPPort.PRINT_SRV), "print_srv");
    names.put(new Integer(IPPort.MULTIPLEX), "multiplex");
    names.put(new Integer(IPPort.CL1), "cl1");
    names.put(new Integer(IPPort.XYPLEX_MUX), "xyplex_mux");
    names.put(new Integer(IPPort.MAILQ), "mailq");
    names.put(new Integer(IPPort.VMNET), "vmnet");
    names.put(new Integer(IPPort.GENRAD_MUX), "genrad_mux");
    names.put(new Integer(IPPort.XDMCP), "xdmcp");
    names.put(new Integer(IPPort.NEXTSTEP), "nextstep");
    names.put(new Integer(IPPort.BGP), "bgp");
    names.put(new Integer(IPPort.RIS), "ris");
    names.put(new Integer(IPPort.UNIFY), "unify");
    names.put(new Integer(IPPort.AUDIT), "audit");
    names.put(new Integer(IPPort.OCBINDER), "ocbinder");
    names.put(new Integer(IPPort.OCSERVER), "ocserver");
    names.put(new Integer(IPPort.REMOTE_KIS), "remote_kis");
    names.put(new Integer(IPPort.KIS), "kis");
    names.put(new Integer(IPPort.ACI), "aci");
    names.put(new Integer(IPPort.MUMPS), "mumps");
    names.put(new Integer(IPPort.QFT), "qft");
    names.put(new Integer(IPPort.GACP), "gacp");
    names.put(new Integer(IPPort.PROSPERO), "prospero");
    names.put(new Integer(IPPort.OSU_NMS), "osu_nms");
    names.put(new Integer(IPPort.SRMP), "srmp");
    names.put(new Integer(IPPort.IRC), "irc");
    names.put(new Integer(IPPort.DN6_NLM_AUD), "dn6_nlm_aud");
    names.put(new Integer(IPPort.DN6_SMM_RED), "dn6_smm_red");
    names.put(new Integer(IPPort.DLS), "dls");
    names.put(new Integer(IPPort.DLS_MON), "dls_mon");
    names.put(new Integer(IPPort.SMUX), "smux");
    names.put(new Integer(IPPort.SRC), "src");
    names.put(new Integer(IPPort.AT_RTMP), "at_rtmp");
    names.put(new Integer(IPPort.AT_NBP), "at_nbp");
    names.put(new Integer(IPPort.AT_3), "at_3");
    names.put(new Integer(IPPort.AT_ECHO), "at_echo");
    names.put(new Integer(IPPort.AT_5), "at_5");
    names.put(new Integer(IPPort.AT_ZIS), "at_zis");
    names.put(new Integer(IPPort.AT_7), "at_7");
    names.put(new Integer(IPPort.AT_8), "at_8");
    names.put(new Integer(IPPort.QMTP), "qmtp");
    names.put(new Integer(IPPort.Z39_50), "z39.50");
    names.put(new Integer(IPPort.N914C), "914c_g");
    names.put(new Integer(IPPort.ANET), "anet");
    names.put(new Integer(IPPort.IPX), "ipx");
    names.put(new Integer(IPPort.VMPWSCS), "vmpwscs");
    names.put(new Integer(IPPort.SOFTPC), "softpc");
    names.put(new Integer(IPPort.CAILIC), "CAIlic");
    names.put(new Integer(IPPort.DBASE), "dbase");
    names.put(new Integer(IPPort.MPP), "mpp");
    names.put(new Integer(IPPort.UARPS), "uarps");
    names.put(new Integer(IPPort.IMAP3), "imap3");
    names.put(new Integer(IPPort.FLN_SPX), "fln_spx");
    names.put(new Integer(IPPort.RSH_SPX), "rsh_spx");
    names.put(new Integer(IPPort.CDC), "cdc");
    names.put(new Integer(IPPort.MASQDIALER), "masqdialer");
    names.put(new Integer(IPPort.DIRECT), "direct");
    names.put(new Integer(IPPort.SUR_MEAS), "sur_meas");
    names.put(new Integer(IPPort.INBUSINESS), "inbusiness");
    names.put(new Integer(IPPort.LINK), "link");
    names.put(new Integer(IPPort.DSP3270), "dsp3270");
    names.put(new Integer(IPPort.SUBNTBCST_TFTP), "subntbcst_tftp");
    names.put(new Integer(IPPort.BHFHS), "bhfhs");
    names.put(new Integer(IPPort.RAP2), "rap2");
    names.put(new Integer(IPPort.SET), "set");
    names.put(new Integer(IPPort.YAK_CHAT), "yak_chat");
    names.put(new Integer(IPPort.ESRO_GEN), "esro_gen");
    names.put(new Integer(IPPort.OPENPORT), "openport");
    names.put(new Integer(IPPort.NSIIOPS), "nsiiops");
    names.put(new Integer(IPPort.ARCISDMS), "arcisdms");
    names.put(new Integer(IPPort.HDAP), "hdap");
    names.put(new Integer(IPPort.BGMP), "bgmp");
    names.put(new Integer(IPPort.X_BONE_CTL), "x_bone_ctl");
    names.put(new Integer(IPPort.SST), "sst");
    names.put(new Integer(IPPort.TD_SERVICE), "td_service");
    names.put(new Integer(IPPort.TD_REPLICA), "td_replica");
    names.put(new Integer(IPPort.HTTP_MGMT), "http_mgmt");
    names.put(new Integer(IPPort.PERSONAL_LINK), "personal_link");
    names.put(new Integer(IPPort.CABLEPORT_AX), "cableport_ax");
    names.put(new Integer(IPPort.RESCAP), "rescap");
    names.put(new Integer(IPPort.CORERJD), "corerjd");
    names.put(new Integer(IPPort.FXP_1), "fxp_1");
    names.put(new Integer(IPPort.K_BLOCK), "k_block");
    names.put(new Integer(IPPort.NOVASTORBAKCUP), "novastorbakcup");
    names.put(new Integer(IPPort.ENTRUSTTIME), "entrusttime");
    names.put(new Integer(IPPort.BHMDS), "bhmds");
    names.put(new Integer(IPPort.ASIP_WEBADMIN), "asip_webadmin");
    names.put(new Integer(IPPort.VSLMP), "vslmp");
    names.put(new Integer(IPPort.MAGENTA_LOGIC), "magenta_logic");
    names.put(new Integer(IPPort.OPALIS_ROBOT), "opalis_robot");
    names.put(new Integer(IPPort.DPSI), "dpsi");
    names.put(new Integer(IPPort.DECAUTH), "decauth");
    names.put(new Integer(IPPort.ZANNET), "zannet");
    names.put(new Integer(IPPort.PKIX_TIMESTAMP), "pkix_timestamp");
    names.put(new Integer(IPPort.PTP_EVENT), "ptp_event");
    names.put(new Integer(IPPort.PTP_GENERAL), "ptp_general");
    names.put(new Integer(IPPort.PIP), "pip");
    names.put(new Integer(IPPort.RTSPS), "rtsps");
    names.put(new Integer(IPPort.TEXAR), "texar");
    names.put(new Integer(IPPort.PDAP), "pdap");
    names.put(new Integer(IPPort.PAWSERV), "pawserv");
    names.put(new Integer(IPPort.ZSERV), "zserv");
    names.put(new Integer(IPPort.FATSERV), "fatserv");
    names.put(new Integer(IPPort.CSI_SGWP), "csi_sgwp");
    names.put(new Integer(IPPort.MFTP), "mftp");
    names.put(new Integer(IPPort.MATIP_TYPE_A), "matip_type_a");
    names.put(new Integer(IPPort.MATIP_TYPE_B), "matip_type_b");
    names.put(new Integer(IPPort.BHOETTY), "bhoetty");
    names.put(new Integer(IPPort.DTAG_STE_SB), "dtag_ste_sb");
    names.put(new Integer(IPPort.BHOEDAP4), "bhoedap4");
    names.put(new Integer(IPPort.NDSAUTH), "ndsauth");
    names.put(new Integer(IPPort.BH611), "bh611");
    names.put(new Integer(IPPort.DATEX_ASN), "datex_asn");
    names.put(new Integer(IPPort.CLOANTO_NET), "cloanto_net");
    names.put(new Integer(IPPort.BHEVENT), "bhevent");
    names.put(new Integer(IPPort.SHRINKWRAP), "shrinkwrap");
    names.put(new Integer(IPPort.NSRMP), "nsrmp");
    names.put(new Integer(IPPort.SCOI2ODIALOG), "scoi2odialog");
    names.put(new Integer(IPPort.SEMANTIX), "semantix");
    names.put(new Integer(IPPort.SRSSEND), "srssend");
    names.put(new Integer(IPPort.RSVP_TUNNEL), "rsvp_tunnel");
    names.put(new Integer(IPPort.AURORA_CMGR), "aurora_cmgr");
    names.put(new Integer(IPPort.DTK), "dtk");
    names.put(new Integer(IPPort.ODMR), "odmr");
    names.put(new Integer(IPPort.MORTGAGEWARE), "mortgageware");
    names.put(new Integer(IPPort.QBIKGDP), "qbikgdp");
    names.put(new Integer(IPPort.RPC2PORTMAP), "rpc2portmap");
    names.put(new Integer(IPPort.CODAAUTH), "codaauth");
    names.put(new Integer(IPPort.CLEARCASE), "clearcase");
    names.put(new Integer(IPPort.ULISTPROC), "ulistproc");
    names.put(new Integer(IPPort.LEGENT_1), "legent_1");
    names.put(new Integer(IPPort.LEGENT_2), "legent_2");
    names.put(new Integer(IPPort.HASSLE), "hassle");
    names.put(new Integer(IPPort.NIP), "nip");
    names.put(new Integer(IPPort.TNETOS), "tnETOS");
    names.put(new Integer(IPPort.DSETOS), "dsETOS");
    names.put(new Integer(IPPort.IS99C), "is99c");
    names.put(new Integer(IPPort.IS99S), "is99s");
    names.put(new Integer(IPPort.HP_COLLECTOR), "hp_collector");
    names.put(new Integer(IPPort.HP_MANAGED_NODE), "hp_managed_node");
    names.put(new Integer(IPPort.HP_ALARM_MGR), "hp_alarm_mgr");
    names.put(new Integer(IPPort.ARNS), "arns");
    names.put(new Integer(IPPort.IBM_APP), "ibm_app");
    names.put(new Integer(IPPort.ASA), "asa");
    names.put(new Integer(IPPort.AURP), "aurp");
    names.put(new Integer(IPPort.UNIDATA_LDM), "unidata_ldm");
    names.put(new Integer(IPPort.UIS), "uis");
    names.put(new Integer(IPPort.SYNOTICS_RELAY), "synotics_relay");
    names.put(new Integer(IPPort.SYNOTICS_BROKER), "synotics_broker");
    names.put(new Integer(IPPort.META5), "meta5");
    names.put(new Integer(IPPort.EMBL_NDT), "embl_ndt");
    names.put(new Integer(IPPort.NETCP), "netcp");
    names.put(new Integer(IPPort.NETWARE_IP), "netware_ip");
    names.put(new Integer(IPPort.MPTN), "mptn");
    names.put(new Integer(IPPort.KRYPTOLAN), "kryptolan");
    names.put(new Integer(IPPort.ISO_TSAP_C2), "iso_tsap_c2");
    names.put(new Integer(IPPort.WORK_SOL), "work_sol");
    names.put(new Integer(IPPort.UPS), "ups");
    names.put(new Integer(IPPort.GENIE), "genie");
    names.put(new Integer(IPPort.DECAP), "decap");
    names.put(new Integer(IPPort.NCED), "nced");
    names.put(new Integer(IPPort.NCLD), "ncld");
    names.put(new Integer(IPPort.IMSP), "imsp");
    names.put(new Integer(IPPort.TIMBUKTU), "timbuktu");
    names.put(new Integer(IPPort.PRM_SM), "prm_sm");
    names.put(new Integer(IPPort.PRM_NM), "prm_nm");
    names.put(new Integer(IPPort.DECLADEBUG), "decladebug");
    names.put(new Integer(IPPort.RMT), "rmt");
    names.put(new Integer(IPPort.SYNOPTICS_TRAP), "synoptics_trap");
    names.put(new Integer(IPPort.SMSP), "smsp");
    names.put(new Integer(IPPort.INFOSEEK), "infoseek");
    names.put(new Integer(IPPort.BNET), "bnet");
    names.put(new Integer(IPPort.SILVERPLATTER), "silverplatter");
    names.put(new Integer(IPPort.ONMUX), "onmux");
    names.put(new Integer(IPPort.HYPER_G), "hyper_g");
    names.put(new Integer(IPPort.ARIEL1), "ariel1");
    names.put(new Integer(IPPort.SMPTE), "smpte");
    names.put(new Integer(IPPort.ARIEL2), "ariel2");
    names.put(new Integer(IPPort.ARIEL3), "ariel3");
    names.put(new Integer(IPPort.OPC_JOB_START), "opc_job_start");
    names.put(new Integer(IPPort.OPC_JOB_TRACK), "opc_job_track");
    names.put(new Integer(IPPort.ICAD_EL), "icad_el");
    names.put(new Integer(IPPort.SMARTSDP), "smartsdp");
    names.put(new Integer(IPPort.SVRLOC), "svrloc");
    names.put(new Integer(IPPort.OCS_CMU), "ocs_cmu");
    names.put(new Integer(IPPort.OCS_AMU), "ocs_amu");
    names.put(new Integer(IPPort.UTMPSD), "utmpsd");
    names.put(new Integer(IPPort.UTMPCD), "utmpcd");
    names.put(new Integer(IPPort.IASD), "iasd");
    names.put(new Integer(IPPort.NNSP), "nnsp");
    names.put(new Integer(IPPort.MOBILEIP_AGENT), "mobileip_agent");
    names.put(new Integer(IPPort.MOBILIP_MN), "mobilip_mn");
    names.put(new Integer(IPPort.DNA_CML), "dna_cml");
    names.put(new Integer(IPPort.COMSCM), "comscm");
    names.put(new Integer(IPPort.DSFGW), "dsfgw");
    names.put(new Integer(IPPort.DASP), "dasp");
    names.put(new Integer(IPPort.SGCP), "sgcp");
    names.put(new Integer(IPPort.DECVMS_SYSMGT), "decvms_sysmgt");
    names.put(new Integer(IPPort.CVC_HOSTD), "cvc_hostd");
    names.put(new Integer(IPPort.HTTPS), "https");
    names.put(new Integer(IPPort.SNPP), "snpp");
    names.put(new Integer(IPPort.MICROSOFT_DS), "microsoft_ds");
    names.put(new Integer(IPPort.DDM_RDB), "ddm_rdb");
    names.put(new Integer(IPPort.DDM_DFM), "ddm_dfm");
    names.put(new Integer(IPPort.DDM_SSL), "ddm_ssl");
    names.put(new Integer(IPPort.AS_SERVERMAP), "as_servermap");
    names.put(new Integer(IPPort.TSERVER), "tserver");
    names.put(new Integer(IPPort.SFS_SMP_NET), "sfs_smp_net");
    names.put(new Integer(IPPort.SFS_CONFIG), "sfs_config");
    names.put(new Integer(IPPort.CREATIVESERVER), "creativeserver");
    names.put(new Integer(IPPort.CONTENTSERVER), "contentserver");
    names.put(new Integer(IPPort.CREATIVEPARTNR), "creativepartnr");
    names.put(new Integer(IPPort.MACON_TCP), "macon_tcp");
    names.put(new Integer(IPPort.SCOHELP), "scohelp");
    names.put(new Integer(IPPort.APPLEQTC), "appleqtc");
    names.put(new Integer(IPPort.AMPR_RCMD), "ampr_rcmd");
    names.put(new Integer(IPPort.SKRONK), "skronk");
    names.put(new Integer(IPPort.DATASURFSRV), "datasurfsrv");
    names.put(new Integer(IPPort.DATASURFSRVSEC), "datasurfsrvsec");
    names.put(new Integer(IPPort.ALPES), "alpes");
    names.put(new Integer(IPPort.KPASSWD), "kpasswd");
    names.put(new Integer(IPPort.DIGITAL_VRC), "digital_vrc");
    names.put(new Integer(IPPort.MYLEX_MAPD), "mylex_mapd");
    names.put(new Integer(IPPort.PHOTURIS), "photuris");
    names.put(new Integer(IPPort.RCP), "rcp");
    names.put(new Integer(IPPort.SCX_PROXY), "scx_proxy");
    names.put(new Integer(IPPort.MONDEX), "mondex");
    names.put(new Integer(IPPort.LJK_LOGIN), "ljk_login");
    names.put(new Integer(IPPort.HYBRID_POP), "hybrid_pop");
    names.put(new Integer(IPPort.TN_TL_W1), "tn_tl_w1");
    names.put(new Integer(IPPort.TCPNETHASPSRV), "tcpnethaspsrv");
    names.put(new Integer(IPPort.TN_TL_FD1), "tn_tl_fd1");
    names.put(new Integer(IPPort.SS7NS), "ss7ns");
    names.put(new Integer(IPPort.SPSC), "spsc");
    names.put(new Integer(IPPort.IAFSERVER), "iafserver");
    names.put(new Integer(IPPort.IAFDBASE), "iafdbase");
    names.put(new Integer(IPPort.PH), "ph");
    names.put(new Integer(IPPort.BGS_NSI), "bgs_nsi");
    names.put(new Integer(IPPort.ULPNET), "ulpnet");
    names.put(new Integer(IPPort.INTEGRA_SME), "integra_sme");
    names.put(new Integer(IPPort.POWERBURST), "powerburst");
    names.put(new Integer(IPPort.AVIAN), "avian");
    names.put(new Integer(IPPort.SAFT), "saft");
    names.put(new Integer(IPPort.GSS_HTTP), "gss_http");
    names.put(new Integer(IPPort.NEST_PROTOCOL), "nest_protocol");
    names.put(new Integer(IPPort.MICOM_PFS), "micom_pfs");
    names.put(new Integer(IPPort.GO_LOGIN), "go_login");
    names.put(new Integer(IPPort.TICF_1), "ticf_1");
    names.put(new Integer(IPPort.TICF_2), "ticf_2");
    names.put(new Integer(IPPort.POV_RAY), "pov_ray");
    names.put(new Integer(IPPort.INTECOURIER), "intecourier");
    names.put(new Integer(IPPort.PIM_RP_DISC), "pim_rp_disc");
    names.put(new Integer(IPPort.DANTZ), "dantz");
    names.put(new Integer(IPPort.SIAM), "siam");
    names.put(new Integer(IPPort.ISO_ILL), "iso_ill");
    names.put(new Integer(IPPort.ISAKMP), "isakmp");
    names.put(new Integer(IPPort.STMF), "stmf");
    names.put(new Integer(IPPort.ASA_APPL_PROTO), "asa_appl_proto");
    names.put(new Integer(IPPort.INTRINSA), "intrinsa");
    names.put(new Integer(IPPort.CITADEL), "citadel");
    names.put(new Integer(IPPort.MAILBOX_LM), "mailbox_lm");
    names.put(new Integer(IPPort.OHIMSRV), "ohimsrv");
    names.put(new Integer(IPPort.CRS), "crs");
    names.put(new Integer(IPPort.XVTTP), "xvttp");
    names.put(new Integer(IPPort.SNARE), "snare");
    names.put(new Integer(IPPort.FCP), "fcp");
    names.put(new Integer(IPPort.PASSGO), "passgo");
    names.put(new Integer(IPPort.EXEC), "exec");
    names.put(new Integer(IPPort.LOGIN), "login");
    names.put(new Integer(IPPort.SHELL), "shell");
    names.put(new Integer(IPPort.PRINTER), "printer");
    names.put(new Integer(IPPort.VIDEOTEX), "videotex");
    names.put(new Integer(IPPort.TALK), "talk");
    names.put(new Integer(IPPort.NTALK), "ntalk");
    names.put(new Integer(IPPort.UTIME), "utime");
    names.put(new Integer(IPPort.EFS), "efs");
    names.put(new Integer(IPPort.RIPNG), "ripng");
    names.put(new Integer(IPPort.ULP), "ulp");
    names.put(new Integer(IPPort.IBM_DB2), "ibm_db2");
    names.put(new Integer(IPPort.NCP), "ncp");
    names.put(new Integer(IPPort.TIMED), "timed");
    names.put(new Integer(IPPort.TEMPO	), "tempo");
    names.put(new Integer(IPPort.STX), "stx");
    names.put(new Integer(IPPort.CUSTIX), "custix");
    names.put(new Integer(IPPort.IRC_SERV), "irc_serv");
    names.put(new Integer(IPPort.COURIER), "courier");
    names.put(new Integer(IPPort.CONFERENCE), "conference");
    names.put(new Integer(IPPort.NETNEWS), "netnews");
    names.put(new Integer(IPPort.NETWALL	), "netwall");
    names.put(new Integer(IPPort.MM_ADMIN), "mm_admin");
    names.put(new Integer(IPPort.IIOP), "iiop");
    names.put(new Integer(IPPort.OPALIS_RDV), "opalis_rdv");
    names.put(new Integer(IPPort.NMSP), "nmsp");
    names.put(new Integer(IPPort.GDOMAP), "gdomap");
    names.put(new Integer(IPPort.APERTUS_LDP), "apertus_ldp");
    names.put(new Integer(IPPort.UUCP	), "uucp");
    names.put(new Integer(IPPort.UUCP_RLOGIN), "uucp_rlogin");
    names.put(new Integer(IPPort.COMMERCE), "commerce");
    names.put(new Integer(IPPort.KLOGIN), "klogin");
    names.put(new Integer(IPPort.KSHELL), "kshell");
    names.put(new Integer(IPPort.APPLEQTCSRVR), "appleqtcsrvr");
    names.put(new Integer(IPPort.DHCPV6_CLIENT), "dhcpv6_client");
    names.put(new Integer(IPPort.DHCPV6_SERVER), "dhcpv6_server");
    names.put(new Integer(IPPort.AFPOVERTCP), "afpovertcp");
    names.put(new Integer(IPPort.IDFP), "idfp");
    names.put(new Integer(IPPort.NEW_RWHO), "new_rwho");
    names.put(new Integer(IPPort.CYBERCASH), "cybercash");
    names.put(new Integer(IPPort.DEVICESHARE), "deviceshare");
    names.put(new Integer(IPPort.PIRP), "pirp");
    names.put(new Integer(IPPort.RTSP), "rtsp");
    names.put(new Integer(IPPort.DSF), "dsf");
    names.put(new Integer(IPPort.REMOTEFS), "remotefs");
    names.put(new Integer(IPPort.OPENVMS_SYSIPC), "openvms_sysipc");
    names.put(new Integer(IPPort.SDNSKMP), "sdnskmp");
    names.put(new Integer(IPPort.TEEDTAP), "teedtap");
    names.put(new Integer(IPPort.RMONITOR), "rmonitor");
    names.put(new Integer(IPPort.MONITOR), "monitor");
    names.put(new Integer(IPPort.CHSHELL), "chshell");
    names.put(new Integer(IPPort.NNTPS), "nntps");
    names.put(new Integer(IPPort.N9PFS), "9pfs");
    names.put(new Integer(IPPort.WHOAMI), "whoami");
    names.put(new Integer(IPPort.STREETTALK), "streettalk");
    names.put(new Integer(IPPort.BANYAN_RPC), "banyan_rpc");
    names.put(new Integer(IPPort.MS_SHUTTLE), "ms_shuttle");
    names.put(new Integer(IPPort.MS_ROME), "ms_rome");
    names.put(new Integer(IPPort.METER), "meter");
    names.put(new Integer(IPPort.METER2), "meter2");
    names.put(new Integer(IPPort.SONAR), "sonar");
    names.put(new Integer(IPPort.BANYAN_VIP), "banyan_vip");
    names.put(new Integer(IPPort.FTP_AGENT), "ftp_agent");
    names.put(new Integer(IPPort.VEMMI), "vemmi");
    names.put(new Integer(IPPort.IPCD), "ipcd");
    names.put(new Integer(IPPort.VNAS), "vnas");
    names.put(new Integer(IPPort.IPDD), "ipdd");
    names.put(new Integer(IPPort.DECBSRV), "decbsrv");
    names.put(new Integer(IPPort.SNTP_HEARTBEAT), "sntp_heartbeat");
    names.put(new Integer(IPPort.BDP), "bdp");
    names.put(new Integer(IPPort.SCC_SECURITY), "scc_security");
    names.put(new Integer(IPPort.PHILIPS_VC), "philips_vc");
    names.put(new Integer(IPPort.KEYSERVER), "keyserver");
    names.put(new Integer(IPPort.IMAP4_SSL), "imap4_ssl");
    names.put(new Integer(IPPort.PASSWORD_CHG), "password_chg");
    names.put(new Integer(IPPort.SUBMISSION), "submission");
    names.put(new Integer(IPPort.CAL), "cal");
    names.put(new Integer(IPPort.EYELINK), "eyelink");
    names.put(new Integer(IPPort.TNS_CML), "tns_cml");
    names.put(new Integer(IPPort.HTTP_ALT), "http_alt");
    names.put(new Integer(IPPort.EUDORA_SET), "eudora_set");
    names.put(new Integer(IPPort.HTTP_RPC_EPMAP), "http_rpc_epmap");
    names.put(new Integer(IPPort.TPIP), "tpip");
    names.put(new Integer(IPPort.CAB_PROTOCOL), "cab_protocol");
    names.put(new Integer(IPPort.SMSD), "smsd");
    names.put(new Integer(IPPort.PTCNAMESERVICE), "ptcnameservice");
    names.put(new Integer(IPPort.SCO_WEBSRVRMG3), "sco_websrvrmg3");
    names.put(new Integer(IPPort.ACP), "acp");
    names.put(new Integer(IPPort.IPCSERVER), "ipcserver");
    names.put(new Integer(IPPort.URM), "urm");
    names.put(new Integer(IPPort.NQS), "nqs");
    names.put(new Integer(IPPort.SIFT_UFT), "sift_uft");
    names.put(new Integer(IPPort.NPMP_TRAP), "npmp_trap");
    names.put(new Integer(IPPort.NPMP_LOCAL), "npmp_local");
    names.put(new Integer(IPPort.NPMP_GUI), "npmp_gui");
    names.put(new Integer(IPPort.HMMP_IND), "hmmp_ind");
    names.put(new Integer(IPPort.HMMP_OP), "hmmp_op");
    names.put(new Integer(IPPort.SSHELL), "sshell");
    names.put(new Integer(IPPort.SCO_INETMGR), "sco_inetmgr");
    names.put(new Integer(IPPort.SCO_SYSMGR), "sco_sysmgr");
    names.put(new Integer(IPPort.SCO_DTMGR), "sco_dtmgr");
    names.put(new Integer(IPPort.DEI_ICDA), "dei_icda");
    names.put(new Integer(IPPort.DIGITAL_EVM), "digital_evm");
    names.put(new Integer(IPPort.SCO_WEBSRVRMGR), "sco_websrvrmgr");
    names.put(new Integer(IPPort.ESCP_IP), "escp_ip");
    names.put(new Integer(IPPort.COLLABORATOR), "collaborator");
    names.put(new Integer(IPPort.AUX_BUS_SHUNT), "aux_bus_shunt");
    names.put(new Integer(IPPort.CRYPTOADMIN), "cryptoadmin");
    names.put(new Integer(IPPort.DEC_DLM), "dec_dlm");
    names.put(new Integer(IPPort.ASIA), "asia");
    names.put(new Integer(IPPort.PASSGO_TIVOLI), "passgo_tivoli");
    names.put(new Integer(IPPort.QMQP), "qmqp");
    names.put(new Integer(IPPort.AMP3_3COM), "3com_amp3");
    names.put(new Integer(IPPort.RDA), "rda");
    names.put(new Integer(IPPort.IPP), "ipp");
    names.put(new Integer(IPPort.BMPP), "bmpp");
    names.put(new Integer(IPPort.SERVSTAT), "servstat");
    names.put(new Integer(IPPort.GINAD), "ginad");
    names.put(new Integer(IPPort.RLZDBASE), "rlzdbase");
    names.put(new Integer(IPPort.LDAPS), "ldaps");
    names.put(new Integer(IPPort.LANSERVER), "lanserver");
    names.put(new Integer(IPPort.MCNS_SEC), "mcns_sec");
    names.put(new Integer(IPPort.MSDP), "msdp");
    names.put(new Integer(IPPort.ENTRUST_SPS), "entrust_sps");
    names.put(new Integer(IPPort.REPCMD), "repcmd");
    names.put(new Integer(IPPort.ESRO_EMSDP), "esro_emsdp");
    names.put(new Integer(IPPort.SANITY), "sanity");
    names.put(new Integer(IPPort.DWR), "dwr");
    names.put(new Integer(IPPort.PSSC), "pssc");
    names.put(new Integer(IPPort.LDP), "ldp");
    names.put(new Integer(IPPort.DHCP_FAILOVER), "dhcp_failover");
    names.put(new Integer(IPPort.RRP), "rrp");
    names.put(new Integer(IPPort.AMINET), "aminet");
    names.put(new Integer(IPPort.OBEX), "obex");
    names.put(new Integer(IPPort.IEEE_MMS), "ieee_mms");
    names.put(new Integer(IPPort.HELLO_PORT), "hello_port");
    names.put(new Integer(IPPort.REPSCMD	), "repscmd");
    names.put(new Integer(IPPort.AODV), "aodv");
    names.put(new Integer(IPPort.TINC), "tinc");
    names.put(new Integer(IPPort.SPMP), "spmp");
    names.put(new Integer(IPPort.RMC), "rmc");
    names.put(new Integer(IPPort.TENFOLD), "tenfold");
    names.put(new Integer(IPPort.URL_RENDEZVOUS), "url_rendezvous");
    names.put(new Integer(IPPort.MAC_SRVR_ADMIN), "mac_srvr_admin");
    names.put(new Integer(IPPort.HAP), "hap");
    names.put(new Integer(IPPort.PFTP), "pftp");
    names.put(new Integer(IPPort.PURENOISE), "purenoise");
    names.put(new Integer(IPPort.SECURE_AUX_BUS), "secure_aux_bus");
    names.put(new Integer(IPPort.SUN_DR), "sun_dr");
    names.put(new Integer(IPPort.MDQS), "mdqs");
    names.put(new Integer(IPPort.DOOM), "doom");
    names.put(new Integer(IPPort.DISCLOSE), "disclose");
    names.put(new Integer(IPPort.MECOMM), "mecomm");
    names.put(new Integer(IPPort.MEREGISTER), "meregister");
    names.put(new Integer(IPPort.VACDSM_SWS), "vacdsm_sws");
    names.put(new Integer(IPPort.VACDSM_APP), "vacdsm_app");
    names.put(new Integer(IPPort.VPPS_QUA), "vpps_qua");
    names.put(new Integer(IPPort.CIMPLEX), "cimplex");
    names.put(new Integer(IPPort.ACAP), "acap");
    names.put(new Integer(IPPort.DCTP), "dctp");
    names.put(new Integer(IPPort.VPPS_VIA), "vpps_via");
    names.put(new Integer(IPPort.VPP), "vpp");
    names.put(new Integer(IPPort.GGF_NCP), "ggf_ncp");
    names.put(new Integer(IPPort.MRM), "mrm");
    names.put(new Integer(IPPort.ENTRUST_AAAS), "entrust_aaas");
    names.put(new Integer(IPPort.ENTRUST_AAMS), "entrust_aams");
    names.put(new Integer(IPPort.XFR), "xfr");
    names.put(new Integer(IPPort.CORBA_IIOP), "corba_iiop");
    names.put(new Integer(IPPort.CORBA_IIOP_SSL), "corba_iiop_ssl");
    names.put(new Integer(IPPort.MDC_PORTMAPPER), "mdc_portmapper");
    names.put(new Integer(IPPort.HCP_WISMAR), "hcp_wismar");
    names.put(new Integer(IPPort.ASIPREGISTRY), "asipregistry");
    names.put(new Integer(IPPort.REALM_RUSD), "realm_rusd");
    names.put(new Integer(IPPort.NMAP), "nmap");
    names.put(new Integer(IPPort.VATP), "vatp");
    names.put(new Integer(IPPort.MSEXCH_ROUTING), "msexch_routing");
    names.put(new Integer(IPPort.HYPERWAVE_ISP), "hyperwave_isp");
    names.put(new Integer(IPPort.CONNENDP), "connendp");
    names.put(new Integer(IPPort.HA_CLUSTER), "ha_cluster");
    names.put(new Integer(IPPort.IEEE_MMS_SSL), "ieee_mms_ssl");
    names.put(new Integer(IPPort.RUSHD), "rushd");
    names.put(new Integer(IPPort.UUIDGEN), "uuidgen");
    names.put(new Integer(IPPort.OLSR), "olsr");
    names.put(new Integer(IPPort.ACCESSNETWORK), "accessnetwork");
    names.put(new Integer(IPPort.ELCSD), "elcsd");
    names.put(new Integer(IPPort.AGENTX), "agentx");
    names.put(new Integer(IPPort.SILC), "silc");
    names.put(new Integer(IPPort.BORLAND_DSJ), "borland_dsj");
    names.put(new Integer(IPPort.ENTRUST_KMSH), "entrust_kmsh");
    names.put(new Integer(IPPort.ENTRUST_ASH), "entrust_ash");
    names.put(new Integer(IPPort.CISCO_TDP), "cisco_tdp");
    names.put(new Integer(IPPort.NETVIEWDM1), "netviewdm1");
    names.put(new Integer(IPPort.NETVIEWDM2), "netviewdm2");
    names.put(new Integer(IPPort.NETVIEWDM3), "netviewdm3");
    names.put(new Integer(IPPort.NETGW), "netgw");
    names.put(new Integer(IPPort.NETRCS), "netrcs");
    names.put(new Integer(IPPort.FLEXLM), "flexlm");
    names.put(new Integer(IPPort.FUJITSU_DEV), "fujitsu_dev");
    names.put(new Integer(IPPort.RIS_CM), "ris_cm");
    names.put(new Integer(IPPort.KERBEROS_ADM), "kerberos_adm");
    names.put(new Integer(IPPort.RFILE), "rfile");
    names.put(new Integer(IPPort.PUMP), "pump");
    names.put(new Integer(IPPort.QRH), "qrh");
    names.put(new Integer(IPPort.RRH), "rrh");
    names.put(new Integer(IPPort.TELL), "tell");
    names.put(new Integer(IPPort.NLOGIN), "nlogin");
    names.put(new Integer(IPPort.CON), "con");
    names.put(new Integer(IPPort.NS), "ns");
    names.put(new Integer(IPPort.RXE), "rxe");
    names.put(new Integer(IPPort.QUOTAD), "quotad");
    names.put(new Integer(IPPort.CYCLESERV), "cycleserv");
    names.put(new Integer(IPPort.OMSERV), "omserv");
    names.put(new Integer(IPPort.WEBSTER), "webster");
    names.put(new Integer(IPPort.PHONEBOOK), "phonebook");
    names.put(new Integer(IPPort.VID), "vid");
    names.put(new Integer(IPPort.CADLOCK), "cadlock");
    names.put(new Integer(IPPort.RTIP), "rtip");
    names.put(new Integer(IPPort.CYCLESERV2), "cycleserv2");
    names.put(new Integer(IPPort.SUBMIT), "submit");
    names.put(new Integer(IPPort.RPASSWD), "rpasswd");
    names.put(new Integer(IPPort.ENTOMB), "entomb");
    names.put(new Integer(IPPort.WPAGES), "wpages");
    names.put(new Integer(IPPort.WPGS), "wpgs");
    names.put(new Integer(IPPort.QSC), "qsc");
    names.put(new Integer(IPPort.MDBS_DAEMON), "mdbs_daemon");
    names.put(new Integer(IPPort.ITM_MCELL_S), "itm_mcell_s");
    names.put(new Integer(IPPort.PKIX_3_CA_RA), "pkix_3_ca_ra");
    names.put(new Integer(IPPort.DHCP_FAILOVER2), "dhcp_failover2");
    names.put(new Integer(IPPort.RSYNC), "rsync");
    names.put(new Integer(IPPort.ICLCNET_LOCATE), "iclcnet_locate");
    names.put(new Integer(IPPort.ICLCNET_SVINFO), "iclcnet_svinfo");
    names.put(new Integer(IPPort.ACCESSBUILDER), "accessbuilder");
    names.put(new Integer(IPPort.CDDBP), "cddbp");
    names.put(new Integer(IPPort.OMGINITIALREFS), "omginitialrefs");
    names.put(new Integer(IPPort.SMPNAMERES), "smpnameres");
    names.put(new Integer(IPPort.IDEAFARM_CHAT), "ideafarm_chat");
    names.put(new Integer(IPPort.IDEAFARM_CATCH), "ideafarm_catch");
    names.put(new Integer(IPPort.XACT_BACKUP), "xact_backup");
    names.put(new Integer(IPPort.FTPS_DATA), "ftps_data");
    names.put(new Integer(IPPort.FTPS), "ftps");
    names.put(new Integer(IPPort.NAS), "nas");
    names.put(new Integer(IPPort.TELNETS), "telnets");
    names.put(new Integer(IPPort.IMAPS), "imaps");
    names.put(new Integer(IPPort.IRCS), "ircs");
    names.put(new Integer(IPPort.POP3S), "pop3s");
    names.put(new Integer(IPPort.VSINET), "vsinet");
    names.put(new Integer(IPPort.MAITRD), "maitrd");
    names.put(new Integer(IPPort.BUSBOY), "busboy");
    names.put(new Integer(IPPort.GARCON), "garcon");
    names.put(new Integer(IPPort.PUPROUTER), "puprouter");
    names.put(new Integer(IPPort.CADLOCK2), "cadlock2");
    names.put(new Integer(IPPort.SURF), "surf");
    names.put(new Integer(IPPort.RESERVED_1023), "1023r");
    names.put(new Integer(IPPort.RESERVED_1024), "1024r");
    names.put(new Integer(IPPort.SOCKS), "socks");
    names.put(new Integer(IPPort.HSRP), "hsrp");
    names.put(new Integer(IPPort.CVS), "cvs");
    names.put(new Integer(IPPort.AISES), "aises");
    names.put(new Integer(IPPort.X11), "X11");
  }


 public static String UNKNOWN = "unknown";

 private String _rcsid = 
 "$Id: IPPort.java,v 1.3 2001/06/07 21:50:56 pcharles Exp $";
}
