/* 
 *
 * prismstumbler miniclient 
 * (c) 2003 Florian Boor <florian.boor@kernelconcepts.de>
 *
 */
 
 
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include "../include/prismstumbler.h"

psconfig_t cfg = { 1, "eth0", DT_ORINOCO, 40000, 0 ,0, 1,"\0"};
static int sock = 0;

void stop_signal()
{
	// do something intelligent
	exit(0);
}

void
send_command (command_t cmd)
{
	psmessage_t msg;
	msg.type = msg_command;
	msg.content.command.command = cmd;

	if (write (sock, (void *) &msg, sizeof (psmessage_t)) < 0)
	{
		perror ("err sending command");
	}
}

void
send_config ()
{
	psmessage_t msg;
	msg.type = msg_config;
	msg.content.cfg = cfg;
	
	if (write (sock, (void *) &msg, sizeof (psmessage_t)) < 0)
	{
		perror ("err sending config data");
	}
}


int main()
{
   int length;
   struct sockaddr_un name;
   psmessage_t buf;

	signal (SIGINT, stop_signal);
	signal (SIGTERM, stop_signal);
	signal (SIGCHLD, stop_signal);
   
   /* Create socket from which to read. */
   sock = socket(AF_UNIX, SOCK_STREAM, 0);
   if (sock < 0) {
      perror("opening datagram socket");
      exit(1);
   }
  

   /* Create name. */
   name.sun_family = AF_UNIX;
   strcpy(name.sun_path, PS_SOCKET);
   if (connect(sock, (struct sockaddr *)&name, SUN_LEN(&name))) {
      perror("connecting to socket");
      exit(1);
   }
   

   printf("socket -->%s\n", PS_SOCKET);
   
   send_config();
   send_command(C_DETECT_CARD);
   
   
   /* Read from the socket. */
   for (;;)
   {
   		if (read(sock, (void*)&buf, sizeof(psmessage_t)) < 0)
		{
      		perror("err receiving datagram packet");
   			close(sock);
			exit(1);
		}
			switch (buf.type)
			{
				case (msg_network):
   					printf("-->%s\n", buf.content.net.bssid);
				break;	
				default:
				break;				
			}
		
	}
   close(sock);
   
   exit(0);
}
