package com.mwr.example.sieve;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
public class PasswordEntry implements Parcelable {
    public static final Parcelable.Creator<PasswordEntry> CREATOR = new Parcelable.Creator<PasswordEntry>() { // from class: com.mwr.example.sieve.PasswordEntry.1
        @Override // android.os.Parcelable.Creator
        public PasswordEntry createFromParcel(Parcel in) {
            return new PasswordEntry(in);
        }

        @Override // android.os.Parcelable.Creator
        public PasswordEntry[] newArray(int size) {
            return new PasswordEntry[size];
        }
    };
    public String email;
    public String password;
    public String service;
    public String username;

    public PasswordEntry(String s, String u, String e, String p) {
        this.service = s;
        this.username = u;
        this.password = p;
        this.email = e;
    }

    public PasswordEntry(Parcel in) {
        String[] input = new String[4];
        in.readStringArray(input);
        this.service = input[0];
        this.username = input[1];
        this.email = input[2];
        this.password = input[3];
    }

    @Override // java.lang.Object
    public String toString() {
        return String.valueOf(this.service) + "\n" + this.username;
    }

    @Override // android.os.Parcelable
    public int describeContents() {
        return 0;
    }

    @Override // android.os.Parcelable
    public void writeToParcel(Parcel out, int arg1) {
        out.writeStringArray(new String[]{this.service, this.username, this.email, this.password});
    }

    public static Map<String, String> MapList(List<PasswordEntry> in) {
        Map<String, String> m = new HashMap<>();
        for (int i = 0; i < in.size(); i++) {
            m.put(in.get(i).service, in.get(i).username);
        }
        return m;
    }
}
