package com.apphacking.smalitwodesign;

import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity {

    TextView txtViewLives;
    TextView txtViewShieldState;

    Button btnGetShield;
    Button btnGetHit;

    ImageView imageView;

    Player player;

    public static ImageView shield;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        btnGetHit = findViewById(R.id.btnGetHit);
        btnGetShield = findViewById(R.id.btnGetShield);


        txtViewLives = (TextView) findViewById(R.id.txtViewLives);
        txtViewShieldState = (TextView) findViewById(R.id.txtViewShieldState);

        imageView = (ImageView) findViewById(R.id.imageView);

        // init player attributes
        player = new Player();
        txtViewLives.setText("Lives: " + String.valueOf(player.lives));
        txtViewShieldState.setText("Shield - " + String.valueOf(player.shield));

        if(player.shield) {
            imageView.setBackgroundResource(R.drawable.space_shield);
        }
        else {
            imageView.setBackgroundResource(R.drawable.space);
        }

    }

    public void playerGetHit(View view) {

        player.getHit();

        if(player.lives < 1) {
            txtViewLives.setText("Lost");
            imageView.setBackgroundResource(R.drawable.space);
        } else {
            // player got hit but has shield
            if(player.shield) {
                imageView.setBackgroundResource(R.drawable.space_shield);
                txtViewLives.setText("Lives: " + String.valueOf(player.lives));
                txtViewShieldState.setText("Shield - " + String.valueOf(player.shield));
            } else {
                //player does not have a shield
                imageView.setBackgroundResource(R.drawable.space);
                txtViewLives.setText("Lives: " + String.valueOf(player.lives));
                txtViewShieldState.setText("Shield - " + String.valueOf(player.shield));
            }
        }

    }

    public void getShield(View view) {

        if(player.lives < 1) {
            imageView.setBackgroundResource(R.drawable.space);
        } else {
            player.shield = true;
            imageView.setBackgroundResource(R.drawable.space_shield);
            txtViewShieldState.setText("Shield - " + String.valueOf(player.shield));
        }
    }
}