;Number guessing game
;------------------------------------------------------------------------------
;Hardcode a number between 0-9 that a user must guess
;Ask the user for input of a number between 0-9
;If the user is correct say "Good job, you got right!" then exit
;If the user wrong but within 1 say "Close but not quite" then exit
;If the user is wrong and off by more than one say "Sorry, that's wrong" then exit
;-----------------------------------------------------------------------------

;Setting up strings required
message1: db "Good job, you got it right!"
message2: db "Close but not quite"
message3: db "Sorry, that's wrong"
intro_message: db "Welcome to the number guess game, please input a number from 0-9"
null: db 0x00
correct_number: db 7
start:
;Print out the start message
mov AH, 0x13
mov CX, offset null
sub CX, offset intro_message
mov BP, offset intro_message
int 0x10
;Get the user input
mov AH, 1
int 0x21
;Convert from ascii to raw number
sub AL, 0x30
;Check if user got the correct number
cmp AL, byte correct_number
jne not_equal
mov CX, offset message2
sub CX, offset message1
mov BP, offset message1
jmp print_end_message
not_equal:
;Check if user is within +1
mov BL, byte correct_number
add BL, 1
cmp AL, BL
jne check_one_under
mov CX, offset message3
sub CX, offset message2
mov BP, offset message2
jmp print_end_message
check_one_under:
;Check if user is within -1
mov BL, byte correct_number
sub BL, 1
cmp AL, BL
jne incorrect_guess
mov CX, offset message3
sub CX, offset message2
mov BP, offset message2
jmp print_end_message
incorrect_guess:
mov CX, offset intro_message
sub CX, offset message3
mov BP, offset message3
print_end_message:
mov AH, 0x13
int 0x10