; The Cyber Mentor Coding Challenge
;  ------------------------------------------------------
; Write a program that serves as the interface for a carnival ride
; In order to enter the ride you must be at least two feet tall and have 100 tickets
; Ask the user to enter their height in feet between 0-9
; Ask the user to enter the amount of tickets they have between 0-999
; Verify the users input for each of the values to make sure they have entered
; a valid number
; If the user is tall and enough and has enough tickets print out that they can
; ride the carnival ride
; If the user doesn't meet those criteria tell them specifically why they can't
; Not enough tickets and not tall enough
; Enough tickets but not tall enough
; Not enough tickets but tall enough
; For strings you can use a null terminator to indicate the end of the string
; or calculate it from the succeeding offset (second option will make your 
; program run much faster)
; ------------------------------------------------------
; Data section
; ------------------------------------------------------
string1: db "Please Enter Your Height In Feet (between 0-9): " db 0x00
string2: db "Please Enter How Many Tickets You Have (Between 0-999): " db 0x00
string3: db "Invalid input, please only input characters from 0-9" db 0x00
string4: db "You may ride the carnival ride" db 0x00
string5: db "Sorry you don't have enough tickets and you're not tall enough" db 0x00
string6: db "Sorry you're not tall enough but you do have enough tickets" db 0x00
string7: db "Sorry you don't have enough tickets, but you are tall enough" db 0x00
height_ascii: db 0x01 db [0x00, 0x02]
tickets_ascii: db 0x03 db [0x00, 0x04]
height_raw: db 0x00
tickets_raw: dw 0x0000
invalid_chars: db 0x00
; Functions section
; -------------------------------------------------------
; Function to print a string, requires BP and CX set
def print_message {
    dec CX
    mov AH, 0x13
    mov DX, 0x00
    int 0x10
    ret
}

; Function to convert ascii numbers to raw;  requires SI set to raw chars offset
; and BX set to point to location to store result
def convert_ascii_raw {
    push BX
    mov BX, SI
    mov CL, byte [BX,1]                             ; Put length of value 1 array into CX for looping
    add SI, 0x02
    convert_to_decimal_1:
    lods byte                                       ; Load byte of ascii into AL
    sub AL, 0x30                                    ; Convert from ascii to raw number
    push CX                                         ; Preserve CX for outerloop
    dec CX                                          ; Counter needs to decrement to account for first number being in 0 position
    mov AH, 0x00                                    ; Zero out AH so it's empty for math
    mov DX, AX                                      ; Put AX into BX so we can use AL to hold the smaller mul number of 10
    cmp CX, 0x00                                    ; Check if CX is 0, if it we don't need to do exponent bc it's last digit
    je after_exp_1                                  ; If it is 0 jump over exponent
    exp_loop_1:
    mov AX, 10                                      ; Mov 10 into AL so we can multiply
    mul DX                                          ; Multiply the contents of BX by 10
    mov DX, AX                                      ; The results of mul will be in AX, mov back to BX to mul again if needed
    loop exp_loop_1                                 ; Loop back and do exponent again if needed
    after_exp_1:
    pop CX                                          ; Pop the initial CX back for the outer loop to count through remaining digits
    pop BX
    add word [BX], DX                               ; Add the result to the total sum
    push BX
    loop convert_to_decimal_1                       ; Loop back for next digit if required
    ret
}

; Function to verify valid ascii numbers, requires SI set and pointer to address
; of where to store invalid char counter
def validate_ascii_nums {
    push BX
    mov BX, SI
    mov CL, byte [BX,1]                             ; Put length of value 1 array into CX for looping
    add SI, 0x02
    validate_chars:
    lods byte                                       ; Load byte of ascii into AL
    cmp AL, 0x30                                    ;  Compare to lower end of range (0x30 - 0x39)
    jb invalid_char
    cmp AL, 0x39                                    ; Compare to the higher end of range
    ja invalid_char
    loop validate_chars
    jmp no_invalid_chars
    invalid_char:
    pop BX                                          ; Pop off the pointer to the invalid char memory location
    inc word [BX]                                   ; If there is an invalid char, increment counter
    ret                                             ; If there is even one invalid char we can ret and print error
    no_invalid_chars:
    pop BX
    mov word [BX], 0x00                             ; Zero out invalid char counter incase something is in it
    ret
}
; Start of main function
; -------------------------------------------------------------
start:
; Ask the user for their height in feet
mov CX, offset string2
sub CX, offset string1
mov BP, offset string1
call print_message

; Take user input for feet
mov AH, 0xa
mov DX, offset height_ascii
int 0x21

; Verify ascii numbers
mov SI, offset height_ascii
mov BX, offset invalid_chars
call validate_ascii_nums
cmp byte invalid_chars, 0x00
jne print_invalid_char_message

; Convert ascii to decimal
mov SI, offset height_ascii
mov BX, offset height_raw
call convert_ascii_raw

; Ask the user for the amount of tickets they have
mov CX, offset string3
sub CX, offset string2
mov BP, offset string2
call print_message

; Take user input for feet
mov AH, 0xa
mov DX, offset tickets_ascii
int 0x21

; Verify ascii numbers
mov SI, offset tickets_ascii
mov BX, offset invalid_chars
call validate_ascii_nums
cmp byte invalid_chars, 0x00
jne print_invalid_char_message

; Convert ascii to decimal
mov SI, offset tickets_ascii
mov BX, offset tickets_raw
call convert_ascii_raw

; Check if tall enough
cmp byte height_raw, 0x03
jb not_tall_enough

; Check if enough tickets so we know to print a success message or not
cmp word tickets_raw, 100
jb height_no_tickets

; Print success message (have enough tickets and tall enough)
mov CX, offset string5
sub CX, offset string4
mov BP, offset string4
call print_message
jmp end

; Check if they have enough tickets so we know which message to print
not_tall_enough:
cmp word tickets_raw, 100
jb no_tickets_height
jmp tickets_no_height

; Print message for not enough of both tickets and height
no_tickets_height:
mov CX, offset string6
sub CX, offset string5
mov BP, offset string5
call print_message
jmp end

; Print message for enough tickets but not tall enough
tickets_no_height:
mov CX, offset string7
sub CX, offset string6
mov BP, offset string6
call print_message
jmp end

; Print message for tall enough but not enough tickets
height_no_tickets:
mov CX, offset height_ascii
sub CX, offset string7
mov BP, offset string7
call print_message
jmp end

; Print message for invalid characters entered
print_invalid_char_message:
mov CX, offset string4
sub CX, offset string3
mov BP, offset string3
call print_message
end:

