# Program to demonstrate read syscall by echoing back a string from the user that they input	
	.file	"helloworld.c"
	.intel_syntax noprefix
	.equ max_input_length, 100
	.text
	.section	.rodata
message:
	.string	"Please input a message to echo back: "
	.equ length, .-message -1
message2:
	.string	"Please input a message2 to echo back: "
	.equ length2, .-message2 -1
	.section .data
input:
	.zero max_input_length
	.text
	.globl	main
	.type	main, @function
main:
	# Start of function prologue
	push	rbp
	mov	rbp, rsp
	# Start of function code to call write syscall
	mov rax, 0x01			    # 0x01 is write syscall
	mov rdi, 1				    # setting fd to STDOUT (1)
	lea rsi, message[rip]	    # pointer to start of message to print
	mov rdx, length			    # length fo string to print
	syscall
	cmp rax, 1				    # checking if syscall wrote bytes
	jl return				    # if it didn't and sent an error return that

	# Start of function code to perform read syscall
	mov rax, 0					# setting rax for read syscall
	mov rdi, 0					# fd for STDIN (0)
	lea rsi, input[rip]			# pointer to input buffer
	mov rdx, max_input_length	# max size for input
	syscall
	
	# Start of function code to call write syscall for echo
	mov rdx, rax			    # moving returned number of chars into rdx
	mov rax, 0x01			    # 0x01 is write syscall
	mov rdi, 1				    # setting fd to STDOUT (1)
	lea rsi, input[rip]		    # pointer to start of message to print
	syscall
	cmp rax, 1				    # checking if syscall wrote bytes
	jl return				    # if it didn't and sent an error return that
	mov rax, 0				    # else return 0 for success
	return:
	# Start of function epilogue
	mov rsp, rbp
	pop	rbp
	ret

print:
	push rbp
	mov rbp, rsp
	mov rax, 0x01			    # 0x01 is write syscall
	mov rdi, 1				    # setting fd to STDOUT (1)
	lea rsi, message2[rip]	    # pointer to start of message to print
	mov rdx, length2			# length fo string to print
	syscall
	mov rsp, rbp
	pop rbp
	ret

.size	main, .-main
.ident	"GCC: (Ubuntu 13.2.0-23ubuntu4) 13.2.0"
.section	.note.GNU-stack,"",@progbits

