;Number guessing game, the user gets 5 guesses to guess a number a between 0-9
;------------------------------------------------------------------------------
;Hardcode a number between 0-9 that a user must guess
;Print a welcome message that only displays once at the start of the game
;Ask the user for input of a number between 0-9
;If the user is correct say "Good job, you got right!" then exit
;Else if the user wrong but within 1 say "Close but not quite"
;Else if the user is wrong and off by more than one say "Sorry, that's wrong"
;If the user got the guess wrong but they have guesses remaining print
;"Please, try again, you have the following guesses left: " and add the number
;guess left to the end of the string
;Allow the user to guess again as long as they have guesses remaining
;If the user is out of guesses then print 
;"Sorry you have 0 guesses left, game over, goodbye" then exit
;-----------------------------------------------------------------------------
;Setting up data required
message1: db "Good job, you got it right!"
message2: db "Close but not quite"
message3: db "Sorry, that's wrong"
message4: db "Sorry you have 0 guesses left, game over, goodbye"
message5: db "Please input a number from 0-9"
message6: db "Please try again, you have the following guesses left: "
number_of_guesses: db 0x00
message7: db "Welcome to the number guess game!"
null: db 0x00
correct_number: db 7
;Start of code
start:
;Print intro message:
mov AH, 0x13
mov CX, offset null
sub CX, offset message7
mov BP, offset message7
int 0x10
;Setup for loop
mov CX, 0x05

start_loop:
;Ask user for input
push CX
mov AH, 0x13
mov CX, offset message6
sub CX, offset message5
mov BP, offset message5
int 0x10
;Get the user input
mov AH, 1
int 0x21
;Convert from ascii to raw number
sub AL, 0x30
;Check if user got the correct number
cmp AL, byte correct_number
je end_game_win
;Check if user is within +1
mov BL, byte correct_number
add BL, 1
cmp AL, BL
je close_but_wrong
;Check if user is within -1
mov BL, byte correct_number
sub BL, 1
cmp AL, BL
jne wrong

close_but_wrong:
;Setup regeisters to print close but wrong message
mov CX, offset message3
sub CX, offset message2
mov BP, offset message2
mov AH, 0x13
int 0x10
jmp check_guesses_left

wrong:
;Print incorrect guess message
mov CX, offset message4
sub CX, offset message3
mov BP, offset message3
mov AH, 0x13
int 0x10

check_guesses_left:
;Check if user has any guesses left, if they don't jump to end of game
pop BX
cmp BX, 0x01; compare to one because we won't have decremented the loop counter here yet
push BX
je end_game_lose

;Print remaining guesses left
mov CX, offset number_of_guesses
sub CX, offset message6
inc CX
mov BP, offset message6
pop BX
add BX, 0x2f;converting to ascii and also subtracting 1 at the same time because loop counter hasn't been decremented yet
mov byte number_of_guesses, BL
int 0x10
sub BX, 0x2f;converting back to ascii to preserver loop counter
mov CX, BX
loop start_loop

end_game_win:
;Setup to print message that they won
mov CX, offset message2
sub CX, offset message1
mov BP, offset message1
jmp print_end_message

end_game_lose:
;Setup to print message that they lost
mov CX, offset message5
sub CX, offset message4
mov BP, offset message4
print_end_message:
mov AH, 0x13
int 0x10
