; Program to demonstrate the LODS instruction by counting the length of a null terminated string

db [0x01, 0xf]                                  ; Adding some data to the start of the function so pointers aren't at zero
string: db "Hello World!" db 0x00               ; Null terminated string
start:
mov CX, 0x00                                    ; Zero out CX to use as increment counter
mov SI, offset string                           ; Set SI to point at start of string so LODS can loop over
read_string:                                    ; Loop for reading string byte by byte
lods byte                                       ; Load byte that's pointed to by SI into AL and then inc SI
cmp AL, 0x00                                    ; Check if byte is 0x00 which is a null terminator
je end                                          ; If it is, then break the loop and go to print message
inc cx                                          ; If the char isn't a null terminator, increment count and loop back up
jmp read_string                                 ; Loop back to start of reading string, LODS will take care of incrementing SI

; Print out the string using the count from the above loop
end:
mov AH, 0x13
mov BP, offset string
int 0x10