; Program to demonstrate the STOS instruction

db [0x01, 0xf]                                  ; Adding some data to the start of the function so pointers aren't at zero
string: db "Hello World!" db 0x00               ; Null terminated string
db [0x01, 0xf]                                  ; Extra data to help show pointers
string2: db [0x00, 0xe]                         ; Allocating memory to store the second string
start:
mov CX, 0x00                                    ; Zero out CX to use as increment counter
mov SI, offset string                           ; Set SI to point at start of string so LODS can loop over
mov DI, offset string2                          ; Setting DI to point at start of buffer for STOS to store byte into
read_string:                                    ; loop for reading string byte by byte
lods byte                                       ; Load byte that's pointed to by SI into AL and then inc SI
cmp AL, 0x20                                    ; Check if byte is 0x20 which is a space in ascii
je after_store                                  ; If it is, then don't store the space
stos byte                                       ; Storing a byte that's pointed to by DI into AL and inc DI
inc CX                                          ; If we store a byte then count it so we can print later
after_store:
cmp AL, 0x00                                    ; Check for null terminator indicating the end of the string
je end                                          ; If it is, then break the loop and go to print message
jmp read_string                                 ; Loop back to start of reading string, LODS will take care of incrementing SI

; Print out the string using the count from the above loop
end:
mov AH, 0x13
mov BP, offset string
int 0x10
