# Program to demonstrate a basic stack overflow
    .intel_syntax noprefix
    .text
    .section .rodata
intro_message:
    .string "Please input your fave hacker: "
    .equ intro_length, .-intro_message -1

hacker_message:
    .string "Your favourite hacker is: "
    .equ hacker_length, .-hacker_message -1

secret_message:
    .string "Hey you shouldn't be here! What the hack?"
    .equ secret_length, .-secret_message -1

stack_smashing_message:
    .string "*** Stack Smooshing Detected *** : terminated\n"
    .equ stack_smashing_length, .-stack_smashing_message -1

    .text
    .globl  format_print
    .type   format_print, @function

format_print:
    # Function takes in pointer to two strings and their max lengths, formats it as string1+string2 then prints the format string
    push rbp
    mov rbp, rsp
    sub rsp, 128                                # allocate space onto the stack for the temp formatted string
    mov rax, fs:40                              # getting stack canary from OS
    mov QWORD PTR -8[rbp], rax                  # placing stack canary onto stack before callers rbp
    mov r9, rsp                                 # use r9 for base pointer of string
    
    # Code to copy string 1 into buffer for formatting
    copy_string_1:
    mov r8b, [rdi]                              # move byte of string over into r8
    test r8b, r8b                               # check if char is null terminator
    jz copy_string_2                            # break loop if at end of string
    mov [r9], r8b                               # move byte of string over from r8 into stack
    inc rdi                                     # inc both pointers             
    inc r9
    jmp copy_string_1

    # Code to copy string 2 into buffer for formatting
    copy_string_2:
    mov r8b, [rsi]                              # move byte of string over into r8
    test r8b, r8b                               # check if char is null terminator
    jz end_copy                                 # break loop if at end of string
    mov [r9], r8b                               # move byte of string over from r8 into stack
    inc rsi                                     # inc both pointers             
    inc r9
    jmp copy_string_2
    end_copy:                                        

    # Start of function code to print
    mov rax, 0x01			                    # 0x01 is write syscall
	mov rdi, 1				                    # setting fd to STDOUT (1)
	lea rsi, QWORD PTR -128[rbp]	            # pointer to start of message to print
	mov rdx, r9   			                    # length fo string to print
    sub rdx, rsp                                # distance from rsp to r9 is the length of string to print
	syscall

    # checking stack canary
    mov rcx, QWORD PTR -8[rbp]                  # taking stack canary stored onto stack off
    xor rcx, QWORD PTR fs:40                    # checking stack canary from OS against the one on the stack
    test rcx, rcx                               # checking to make sure they are equal
    jz end

    # Start of function code to print stack smashing message
    mov rax, 0x01			                    # 0x01 is write syscall
	mov rdi, 1				                    # setting fd to STDOUT (1)
	lea rsi, stack_smashing_message[rip]	    # pointer to start of message to print
	mov rdx, stack_smashing_length  			# length fo string to print
	syscall

    # Syscall to exit
    mov rax, 60                                 # syscall sub function to exit
    mov rdi, 1                                  # return 1 for standard error
    syscall

    end:
    # Function epilogue
    mov rsp, rbp
    pop rbp
    ret
    .size    format_print, .-format_print

    .text
    .globl  secret_print
    .type   secret_print, @function
secret_print:
    push rbp
    mov rbp, rsp
   
   # Start of function code to print
    mov rax, 0x01			                            # 0x01 is write syscall
	mov rdi, 1				                            # setting fd to STDOUT (1)
	lea rsi, secret_message[rip]	                    # pointer to start of message to print
	mov rdx, secret_length			                    # length fo string to print
	syscall
    mov rsp, rbp
    pop rbp
    ret
    .size    secret_print, .-secret_print

    .globl  main
    .type   main, @function
main:
    push rbp
    mov rbp, rsp                                
    sub rsp, 256                                # allocate space on the stack for the string input
    
    # Start of code to print greeting message
    mov rax, 0x01			                    # 0x01 is write syscall
	mov rdi, 1				                    # setting fd to STDOUT (1)
	lea rsi, intro_message[rip]	                # pointer to start of message to print
	mov rdx, intro_length			            # length fo string to print
	syscall

    # Start of code to perform read syscall
	mov rax, 0					                # setting rax for read syscall
	mov rdi, 0					                # fd for STDIN (0)
	lea rsi, QWORD PTR -256[rbp]                # pointer to allocated space on the stack
	mov rdx, 255          	                    # set this to 255 so they can't overflow the stack
    syscall

    # add null terminator after input from read syscall
    lea rsi, QWORD PTR -256[rbp]                # load pointer to start of string
    add rsi, rax                                # move it up amount of chars input
    mov BYTE PTR [rsi], 0x00                    # move null terminator in

    # setup and call formatting print function
    lea rdi, hacker_message[rip]                # format string one passed into function
    lea rsi, QWORD PTR -256[rbp]                # format string two passed into function
    call format_print
    
    # function epilogue
    return_from_call:
    mov rax, 0
    mov rsp, rbp
    pop rbp
    ret
    .size    main, .-main
    .section    .note.GNU-stack,"",@progbits
