# The Cyber Mentor Coding Challenge
#  ------------------------------------------------------
# Write a program that serves as the interface for a carnival ride
# In order to enter the ride you must be at least two feet tall and have 100 tickets
# Ask the user to enter their height in feet between 0-9
# Ask the user to enter the amount of tickets they have between 0-999
# Verify the users input for each of the values to make sure they have entered
# a valid number (proper ascii and valid length)
# If the user is tall and enough and has enough tickets print out that they can
# ride the carnival ride
# If the user doesn't meet those criteria tell them specifically why they can't
# Not enough tickets and not tall enough
# Enough tickets but not tall enough
# Not enough tickets but tall enough
# Make sure your code is compliant with AMD64 System V ABI and not too repetitive
# ------------------------------------------------------

    .intel_syntax noprefix
    .equ min_height, 3
    .equ min_tickets, 100

# Read-only data Section for strings
# ------------------------------------------------------
    .text
    .section .rodata

message1:
    .string "Please Enter Your Height In Feet (between 0-9): "
    .equ msg1_len, .-message1

message2:
    .string "Please Enter How Many Tickets You Have (Between 0-999: "
    .equ msg2_len, .-message2

message3:
    .string "Invalid input, please only input the correct number of characters between 0-9\n"
    .equ msg3_len, .-message3-1

message4:
    .string "You may ride the carnival ride\n"
    .equ msg4_len, .-message4-1

message5:
    .string "Sorry you don't have enough tickets and you're not tall enough\n"
    .equ msg5_len, .-message5-1

message6:
    .string "Sorry you're not tall enough but you do have enough tickets\n"
    .equ msg6_len, .-message6-1

message7:
    .string "Sorry you don't have enough tickets, but you are tall enough\n"
    .equ msg7_len, .-message7-1


# Functions
# ------------------------------------------------------

    .text
    .globl  print
    .type   print, @function
print:
    # Function to print a string 
    # arg1=char * string arg2=int length
    
    push rbp
    mov rbp, rsp
    sub rsp, 16                                             # Setup call stack
    mov QWORD PTR -8[rbp], rdi                              # Receive char* pointer from rdi
    mov QWORD PTR -16[rbp], rsi                             # Recieve int from rsi
    
    # Setup for print
    mov rax, 1                                              # syscall 1 to print
    mov rdi, 1                                              # file descriptor to STDOUT
    mov rsi, QWORD PTR -8[rbp]                              # rsi to point to string to print
    mov rdx, QWORD PTR -16[rbp]                             # rdx contains length of string to print
    syscall
    cmp rax, 1                                              # check if we wrote any bytes
    jl return_from_print                                    # if we didn't return error
    mov rax, 0                                              # if we returned bytes, return 0 for no error
    
    return_from_print:
    mov rsp, rbp
    pop rbp
    ret
    .size    print, .-print

    .text
    .globl  atoi
    .type   atoi, @function

atoi:
    # Function to convert a string of ascii to a raw number which is returned in rax
    # arg1 = char * string
    
    push rbp
    mov rbp, rsp
    sub rsp, 16                                             # Setup call stack
    mov QWORD PTR -8[rbp], rdi                              # Receive char* pointer from rdi
    mov rcx, 0                                              # zero rcx for use
    mov rax, 0                                              
    mov rsi, QWORD PTR -8[rbp]                              # pointer from call stack to rsi
    
    read_byte:                                              # outer loop loops through bytes
    mov cl, BYTE PTR [rsi]                                  # mov first byte of string into cl
    cmp cl, 10                                              # check if cl is \n meaning end of string
    je return_from_atoi
    sub cl, '0'
    imul rax, rax, 10                                       # multiply current result by 10
    add rax, rcx                                            # add the remaining integer
    inc rsi                                                 # mov rsi to point at next byte to check
    jmp read_byte
    
    return_from_atoi:
    mov rsp, rbp
    pop rbp
    ret
    .size    atoi, .-atoi


valid_number_check:
    # Function to check if string contains invalid chars, returns 0 if no invalid chars, 1 if invalid chars
    # arg1 = char * string
    push rbp
    mov rbp, rsp
    sub rsp, 16                                             # Setup call stack
    mov QWORD PTR -8[rbp], rdi                              # Receive char* pointer from rdi
    mov rax, 0                                              # zero rax for return
    mov rcx, 0                                              # zero rcx for use
    mov rsi, QWORD PTR -8[rbp]                              # pointer from call stack to rsi
    read_byte_valid_check:                                  # outer loop loops through bytes
    mov cl, BYTE PTR [rsi]                                  # mov first byte of string into cl
    test cl, cl                                             # check if cl is 0x00, \n should be the last line, if it's not they entered too many chars
    jz invalid_input                                                                        
    cmp cl, 10                                              # check if cl is \n (which is newline or 10 in ascii) meaning end of null terminated string
    je return_valid_check
    cmp cl, '9'                                             # compare to upper bound
    jg invalid_input                                        # if greater than 9 it's an invalid char
    cmp cl, '0'                                             # compare to the lower bound
    jl invalid_input                                        # if less than 0 it's an invalid char
    inc rsi
    jmp read_byte_valid_check                               # loop back                                           
    invalid_input:
    mov rax, 1                                              # return 1 if invalid chars                                             # return 2 if too many chars
    return_valid_check:
    mov rsp, rbp
    pop rbp
    ret
    .size    valid_number_check, .-valid_number_check

# Main
# ------------------------------------------------------
    .text
    .globl  main
    .type   main, @function
main:
    push rbp
    mov rbp, rsp
    sub rsp, 32                                             # Allocate memory for 4 local vars of height and tickets (ascii and raw)

    # Taking user input, verifying and converting to raw
    # ---------------------------------------------------------------------------------------------------------------------
    
    # Print message asking for height
    lea rdi, message1[rip]
    mov rsi, msg1_len
    call print
    test rax, rax                                           # check if rax is 0
    jnz end                                                 # jmp to end if it's not and return error 

    # Take input for height
    mov rax, 0                                              # Syscall 0 is read
    mov rdi, 0                                              # set fd = STDIN
    lea rsi, QWORD PTR -8[rbp]                              # buffer to hold string on the stack
    mov rdx, 2                                              # height is between 0-9, only need 1 char plus room for newline
    syscall
    cmp rax, 2                                              # check if we got a char back, minimum should be 2, one for char input and one for newline
    jl invalid_char_error                                   # if we didn't receive a char print error and quit, using jl because negative rax is also error
    lea rdi, QWORD PTR -8[rbp]                              # load pointer to height to pass into function                           
    call valid_number_check
    test rax, rax                                           # check to make sure we have all valid numbers
    jnz invalid_char_error                                  # If rax isn't zero jump to print error
    lea rdi, QWORD PTR -8[rbp]
    call atoi
    mov QWORD PTR -24[rbp], rax                             # use local variable on stack to hold value returned

    # Print message asking for tickets
    lea rdi, message2[rip]
    mov rsi, msg2_len
    call print
    test rax, rax                                           # check if rax is 0
    jnz end                                                 # jmp to end if it's not and return error

    # Take input for tickets
    mov rax, 0                                              # Syscall 0 is read
    mov rdi, 0                                              # set fd = STDIN
    lea rsi, QWORD PTR -16[rbp]                             # buffer to hold string
    mov rdx, 4                                              # height is between 0-999, only need 3 plus 1 for newline
    syscall
    cmp rax, 2                                              # # check if we got a char back, minimum should be 2, one for char input and one for newline
    jl invalid_char_error                                   # if we didn't receive at least 1 char we should print error and quit
    lea rdi, QWORD PTR -16[rbp]                             # need to reload bc rdi is not callee preserved
    call valid_number_check
    test rax, rax                                           # check to make sure we have all valid numbers
    jnz invalid_char_error                                  # If rax isn't zero we have an error
    lea rdi, QWORD PTR -16[rbp]  
    call atoi
    mov QWORD PTR -32[rbp], rax                             # use local variable on stack to hold value returned

    # Start of Logic to check if they meet requirements
    # ------------------------------------------------------------------------------------------------------------------------
    mov rax, QWORD PTR -24[rbp]                             # move height into rax
    mov rcx, QWORD PTR -32[rbp]                             # move tickets into rcx
    cmp rax, min_height                                     # compare height with min required height
    jl not_tall_enough
    cmp rcx, min_tickets                                    # compare tickets with min required tickets
    jl tall_enough_low_tickets                              # if lower here it means they're tall enough but don't have enough tickets
    
    # Print success message as if we got here they are tall enough and have enough tickets
    lea rdi, message4[rip]
    mov rsi, msg4_len
    call print
    jmp end                                                 # jump to end and return whatever rax is
    not_tall_enough:
    cmp rcx, min_tickets                                    # compare tickets with min required
    jae enough_tickets_too_short                            # if above or equal they aren't tall enough but have enough tickets
    
    # print message they don't have enough tickets and aren't tall enough
    lea rdi, message5[rip]
    mov rsi, msg5_len
    call print
    jmp end
    
    enough_tickets_too_short:
    lea rdi, message6[rip]
    mov rsi, msg6_len
    call print
    jmp end
    
    tall_enough_low_tickets:
    lea rdi, message7[rip]
    mov rsi, msg7_len
    call print
    jmp end
    
    invalid_char_error:
    lea rdi, message3[rip]
    mov rsi, msg3_len
    call print
    mov rax, 1                                              # return an error
    
    end:
    mov rsp, rbp
    pop rbp
    ret
    .size    main, .-main
    .section    .note.GNU-stack,"",@progbits
