# Function to demonstrate implementing and calling functions
    .intel_syntax noprefix
    .text
    .section .rodata

    .align 4
    .type length,   @object
    .size length,   4
length:
    .long 13

message:
    .string "Hello World!\n"

    .text
    .globl  print
    .type   print, @function
    # Call order sequence: rdi, rsi, rdx, rcx, r8, r9, stack
print:
    # Print(char * stringToPrint, int lengthOfString)
    # Setting up call stack
    push rbp
    mov rbp, rsp
	sub rsp, 16
    mov rax, QWORD PTR 16[rbp]
    mov QWORD PTR -8[rbp], rax
    mov rax, QWORD PTR 24[rbp]
    mov QWORD PTR -16[rbp], rax
    # Start of function code to call write syscall
	mov rax, 0x01			            # 0x01 is write syscall
	mov rdi, 1				            # setting fd to STDOUT (1)
    mov rsi, QWORD PTR -8[rbp]        	# pointer to start of message to print passed into function as first arg
	mov rdx, QWORD PTR -16[rbp]        	# length of string to print passed into function as second arg
	syscall
	cmp rax, 1				            # checking if syscall wrote bytes
	jl return				            # if it didn't and sent an error return that
    mov rax, 0
    return:
    mov rsp, rbp
    pop rbp
    ret
    .size    print, .-print

    .text
    .globl  main
    .type   main, @function
# Call order sequence: rdi, rsi, rdx, rcx, r8, r9, stack
# print(char * stringToPrint, int lengthOfString)
main:
    push rbp
    mov rbp, rsp
    sub rsp, 16
    mov QWORD PTR -8[rsp], 2890
    mov esi, DWORD PTR length[rip]      # setting up to pass second arg into function
    push rsi
    lea rdi, message[rip]               # setting up to pass first arg into function
    push rdi
    call print
    add rsp, 16
    # Doing other stuff before we exit
    mov rsp, rbp
    pop rbp
    ret
    .size    main, .-main
    .section    .note.GNU-stack,"",@progbits
