# Program to demonstrate working with memory
    .intel_syntax noprefix
    .section    .data

string:
    .string "This is a string"

    .align 8                        # Aligning quad word to 8 byte bound
    .type quadword,     @object     # Defining type and size for linker
    .size quadword,     8
quadword:
    .quad 11

    
    .align 4                        # Aligning double word to 4 byte bound
    .type doubleword,   @object     # Defining type and size for linker
    .size doubleword,     4
doubleword:
    .long 12

singleword:
    .short 13

singlebyte:
    .byte 14

junk:
    .string "This is junk data"

    .text
    .globl  main
    .type   main, @function
main:
    push rbp
    mov rbp, rsp
    mov rax, quadword[rip]          # Syntax for moving memory at a label with rip relative adddressing, size is determined by the register (eg rax = 8 bytes, eax = 4 bytes, ax = 2 bytes, al = 1 byte)
    mov ebx, doubleword[rip]
    mov cx, singleword[rip]
    mov rdx, singlebyte[rip]
    mov QWORD PTR quadword[rip], 14 # Syntax for moving an immediate into memory, note that size must be specified when not using a register
    mov doubleword[rip], ebx
    mov doubleword[rip], rbx
    mov rax, 0
    mov rsp, rbp
    pop rbp
    ret
    .size    main, .-main
    .section    .note.GNU-stack,"",@progbits
