/*
 * Decompiled with CFR 0.152.
 */
package ghidradev;

import ghidradev.EclipseMessageUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private Set<Closeable> closeSet = new HashSet<Closeable>();
    public static final String PLUGIN_ID = "GhidraDev";
    private static final String GHIDRA_INSTALL_DIR_PROPERTY = "ghidra.install.dir";
    private static Activator plugin;

    public static Activator getDefault() {
        return plugin;
    }

    public synchronized void registerCloseable(Closeable c) {
        this.closeSet.add(c);
    }

    public synchronized void unregisterCloseable(Closeable c) {
        this.closeSet.remove(c);
    }

    public File getGhidraInstallDir() {
        String ghidraInstallDirProperty = System.getProperty(GHIDRA_INSTALL_DIR_PROPERTY);
        if (ghidraInstallDirProperty != null && !ghidraInstallDirProperty.isEmpty()) {
            return new File(ghidraInstallDirProperty);
        }
        return null;
    }

    public boolean isLaunchedByGhidra() {
        return System.getProperty(GHIDRA_INSTALL_DIR_PROPERTY) != null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        EclipseMessageUtils.info("Starting GhidraDev plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        EclipseMessageUtils.info("Stopping GhidraDev plugin");
        Activator activator = this;
        synchronized (activator) {
            for (Closeable c : this.closeSet) {
                if (c == null) continue;
                EclipseMessageUtils.info("Closing " + String.valueOf(c));
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    EclipseMessageUtils.info("Failed to close " + String.valueOf(c));
                }
            }
            this.closeSet.clear();
        }
    }
}

