/*
 * Decompiled with CFR 0.152.
 */
package ghidradev;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class EclipseMessageUtils {
    private static IWorkbenchPage workbenchPage = EclipseMessageUtils.getWorkbenchPage();
    private static Shell shell = workbenchPage.getWorkbenchWindow().getShell();

    private EclipseMessageUtils() {
    }

    public static void showInfoDialog(String title, String message) {
        Display.getDefault().syncExec(() -> {
            shell.forceActive();
            MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
        });
    }

    public static boolean showConfirmDialog(String title, String message) {
        AtomicBoolean okPressed = new AtomicBoolean();
        Display.getDefault().syncExec(() -> {
            shell.forceActive();
            okPressed.set(MessageDialog.openConfirm((Shell)shell, (String)title, (String)message));
        });
        return okPressed.get();
    }

    public static boolean showQuestionDialog(String title, String message) {
        AtomicBoolean yesPressed = new AtomicBoolean();
        Display.getDefault().syncExec(() -> {
            shell.forceActive();
            yesPressed.set(MessageDialog.openQuestion((Shell)shell, (String)title, (String)message));
        });
        return yesPressed.get();
    }

    public static void showErrorDialog(String title, String message) {
        Display.getDefault().syncExec(() -> {
            shell.forceActive();
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        });
    }

    public static void showErrorDialog(String message) {
        EclipseMessageUtils.showErrorDialog("GhidraDev error", message);
    }

    public static void showWarnDialog(String title, String message) {
        Display.getDefault().syncExec(() -> {
            shell.forceActive();
            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
        });
    }

    public static String showWizardErrorDialog(Shell wizardShell, InvocationTargetException e) {
        Object message = null;
        Throwable cause = e.getCause();
        if (cause != null) {
            message = cause.getClass().getSimpleName();
            if (cause.getMessage() != null && !cause.getMessage().isEmpty()) {
                message = (String)message + ": " + cause.getMessage();
            }
        } else {
            message = e.getClass().getSimpleName();
        }
        MessageDialog.openError((Shell)wizardShell, (String)"Error", (String)message);
        return message;
    }

    public static void info(String message) {
        StatusManager.getManager().handle((IStatus)new Status(1, "GhidraDev", message));
    }

    public static void error(String message) {
        StatusManager.getManager().handle((IStatus)new Status(4, "GhidraDev", message));
    }

    public static void error(String message, Throwable t) {
        StatusManager.getManager().handle((IStatus)new Status(4, "GhidraDev", message, t));
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = EclipseMessageUtils.getWorkbenchWindow(workbench);
        if (workbenchWindow == null) {
            EclipseMessageUtils.error("Couldn't get workbench window");
            return null;
        }
        IWorkbenchPage wbp = EclipseMessageUtils.getPage(workbenchWindow);
        if (wbp == null) {
            EclipseMessageUtils.error("Couldn't get workbench page");
            return null;
        }
        return wbp;
    }

    private static IWorkbenchWindow getWorkbenchWindow(IWorkbench workbench) {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window != null) {
                return window;
            }
            ++n2;
        }
        return null;
    }

    private static IWorkbenchPage getPage(IWorkbenchWindow workbenchWindow) {
        IWorkbenchPage[] pages;
        IWorkbenchPage wbp = workbenchWindow.getActivePage();
        if (wbp != null) {
            return wbp;
        }
        IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            if (page != null) {
                return page;
            }
            ++n2;
        }
        return null;
    }

    public static void displayInEditor(final IFile file, final IWorkbench workbench) {
        new UIJob("Display in editor"){

            public IStatus runInUIThread(IProgressMonitor m) {
                try {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file);
                    workbench.showPerspective("org.eclipse.jdt.ui.JavaPerspective", window);
                    return Status.OK_STATUS;
                }
                catch (NullPointerException | WorkbenchException throwable) {
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
    }
}

