/*
 * Decompiled with CFR 0.152.
 */
package ghidradev;

import ghidradev.Activator;
import ghidradev.EclipseMessageUtils;
import ghidradev.GhidraRootPreferences;
import ghidradev.ghidrascripteditor.ScriptEditorInitializer;
import ghidradev.ghidrasymbollookup.SymbolLookupInitializer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

public class GhidraDevStartup
implements IStartup {
    public void earlyStartup() {
        Job job = new Job("GhidraDev startup"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Initializing GhidraDev", 2);
                if (Activator.getDefault().isLaunchedByGhidra()) {
                    IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
                    IIntroPart intro = introManager.getIntro();
                    if (intro != null) {
                        Display.getDefault().syncExec(() -> {
                            boolean bl = introManager.closeIntro(intro);
                        });
                    }
                    PlatformUI.getPreferenceStore().setValue("showIntro", false);
                }
                boolean firstTimeConsent = false;
                if (!GhidraRootPreferences.requestedConsentToOpenPorts()) {
                    firstTimeConsent = EclipseMessageUtils.showQuestionDialog("GhidraDevUser Consent", "GhidraDev opens ports to enable communication with Ghidra for various features such as initiating script editing and symbol lookup from Ghidra.\n\nDo you consent to the ports being opened?\n\nIf you do not consent now, you can enable these features at any time in the GhidraDev preferences.");
                    GhidraRootPreferences.setOpenPortConsentRequest(true);
                }
                ScriptEditorInitializer.init(firstTimeConsent);
                monitor.worked(1);
                SymbolLookupInitializer.init(firstTimeConsent);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

