/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.launchers;

import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraLaunchUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractGhidraLaunchShortcut
implements ILaunchShortcut {
    private String launchConfigTypeId;
    private String launchConfigNameSuffix;

    protected AbstractGhidraLaunchShortcut(String launchConfigTypeId, String launchConfigNameSuffix) {
        this.launchConfigTypeId = launchConfigTypeId;
        this.launchConfigNameSuffix = launchConfigNameSuffix;
    }

    public void launch(ISelection selection, String mode) {
        IProject project = GhidraProjectUtils.getSelectedProject(selection);
        if (project != null) {
            this.launch(JavaCore.create((IProject)project), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource != null) {
            this.launch(JavaCore.create((IProject)resource.getProject()), mode);
        }
    }

    private void launch(IJavaProject javaProject, String mode) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
        String launchConfigName = javaProject.getProject().getName() + this.launchConfigNameSuffix;
        try {
            ILaunchConfiguration lc = GhidraLaunchUtils.getLaunchConfig(launchConfigName);
            ILaunchConfigurationWorkingCopy wc = null;
            if (lc == null) {
                wc = GhidraLaunchUtils.createLaunchConfig(javaProject, this.launchConfigTypeId, launchConfigName, null);
            } else if (lc.getType().equals(launchType)) {
                wc = lc.getWorkingCopy();
            } else {
                throw new CoreException((IStatus)new Status(4, "GhidraDev", 4, "Failed to launch. Run configuration with name \"" + launchConfigName + "\" already exists.", null));
            }
            wc.doSave().launch(mode, null);
        }
        catch (CoreException e) {
            EclipseMessageUtils.showErrorDialog(e.getMessage());
        }
    }
}

