/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.launchers;

import ghidra.launch.JavaConfig;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import ghidradev.ghidraprojectcreator.utils.PyDevUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.naming.OperationNotSupportedException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;

public class GhidraLaunchDelegate
extends JavaLaunchDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        JavaConfig javaConfig;
        boolean isHeadless = configuration.getType().getIdentifier().equals("GhidraHeadlessLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        String projectName = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        IJavaProject javaProject = GhidraProjectUtils.getGhidraProject(projectName);
        if (javaProject == null) {
            EclipseMessageUtils.showErrorDialog("Failed to launch project \"" + projectName + "\".\nDoes not appear to be a Ghidra project.");
            return;
        }
        IFolder ghidraFolder = javaProject.getProject().getFolder("Ghidra");
        String ghidraInstallPath = ghidraFolder.getLocation().toOSString();
        try {
            javaConfig = new JavaConfig(new File(ghidraInstallPath));
        }
        catch (IOException | ParseException e) {
            EclipseMessageUtils.showErrorDialog("Failed to launch project \"" + projectName + "\".\n" + e.getMessage());
            return;
        }
        String customProgramArgs = configuration.getAttribute("ghidradev.ghidraProgramArguments", "").trim();
        Object programArgs = isHeadless ? "ghidra.app.util.headless.AnalyzeHeadless" : "ghidra.GhidraRun";
        programArgs = (String)programArgs + " " + customProgramArgs;
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, (String)programArgs);
        if (isHeadless && customProgramArgs.isEmpty()) {
            EclipseMessageUtils.showInfoDialog("Ghidra Run Configuration", "Headless launch is being performed without any command line arguments!\n\nEdit the \"" + configuration.getName() + "\" run configuration's program arguments to customize headless behavior. See support/analyzeHeadlessREADME.html for more information.");
        }
        Object vmArgs = javaConfig.getLaunchProperties().getVmArgs();
        vmArgs = (String)vmArgs + " " + configuration.getAttribute("ghidradev.ghidraVmArguments", "").trim();
        vmArgs = (String)vmArgs + " -Declipse.install.dir=\"" + Platform.getInstallLocation().getURL().getFile() + "\"";
        vmArgs = (String)vmArgs + " -Declipse.workspace.dir=\"" + String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation()) + "\"";
        vmArgs = (String)vmArgs + " -Declipse.project.dir=\"" + String.valueOf(javaProject.getProject().getLocation()) + "\"";
        vmArgs = (String)vmArgs + " -Declipse.project.dependencies=\"" + GhidraLaunchDelegate.getProjectDependencyDirs(javaProject) + "\"";
        File pyDevSrcDir = PyDevUtils.getPyDevSrcDir();
        if (pyDevSrcDir != null) {
            vmArgs = (String)vmArgs + " -Declipse.pysrc.dir=\"" + String.valueOf(pyDevSrcDir) + "\"";
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)vmArgs);
        if (mode.equals("debug")) {
            GhidraLaunchDelegate.handleDebugMode();
        }
        super.launch(wc.doSave(), mode, launch, monitor);
    }

    private static String getProjectDependencyDirs(IJavaProject javaProject) throws CoreException {
        Object paths = "";
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 2) {
                IResource resource;
                if (!((String)paths).isEmpty()) {
                    paths = (String)paths + File.pathSeparator;
                }
                if ((resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath())) != null) {
                    paths = (String)paths + String.valueOf(resource.getLocation());
                }
            }
            ++n2;
        }
        return paths;
    }

    private static void handleDebugMode() {
        Display.getDefault().asyncExec(() -> {
            if (PlatformUI.getWorkbench() != null) {
                IPerspectiveDescriptor descriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.debug.ui.DebugPerspective");
                EclipseMessageUtils.getWorkbenchPage().setPerspective(descriptor);
            }
            if (PyDevUtils.isSupportedPyDevInstalled()) {
                try {
                    PyDevUtils.startPyDevRemoteDebugger();
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    EclipseMessageUtils.error("Failed to start the PyDev remote debugger.  PyDev version is not supported.");
                }
            }
        });
    }
}

