/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.launchers;

import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraLaunchUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GhidraLaunchTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ArrayList<Object> tabs = new ArrayList<Object>();
        tabs.add(this.getJavaMainTab());
        tabs.add(this.getUserDefinedArgumentsTab());
        tabs.add(new JavaClasspathTab());
        tabs.add(new EnvironmentTab());
        tabs.add(this.getCommonTab());
        this.setTabs(tabs.toArray(new ILaunchConfigurationTab[tabs.size()]));
    }

    private JavaMainTab getJavaMainTab() {
        return new JavaMainTab(){

            public void initializeFrom(ILaunchConfiguration config) {
                try {
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    GhidraLaunchUtils.setMainTypeName(wc);
                    super.initializeFrom(wc.doSave());
                }
                catch (CoreException e) {
                    EclipseMessageUtils.error("Failed to initialize the java main tab.", e);
                }
            }
        };
    }

    private AbstractLaunchConfigurationTab getUserDefinedArgumentsTab() {
        return new AbstractLaunchConfigurationTab(){
            private Text programArgsText;
            private Text vmArgsText;

            public void createControl(Composite parent) {
                Composite container = new Composite(parent, 0);
                container.setLayout((Layout)new GridLayout(1, true));
                GridData gd = new GridData(1808);
                container.setLayoutData((Object)gd);
                Group group = new Group(container, 0);
                group.setLayout((Layout)new GridLayout());
                group.setLayoutData((Object)new GridData(1808));
                group.setText("Program arguments:");
                this.programArgsText = new Text((Composite)group, 2626);
                gd = new GridData(1808);
                gd.heightHint = 40;
                gd.widthHint = 100;
                this.programArgsText.setLayoutData((Object)gd);
                this.programArgsText.addModifyListener(evt -> this.scheduleUpdateJob());
                group = new Group(container, 0);
                group.setLayout((Layout)new GridLayout());
                group.setLayoutData((Object)new GridData(1808));
                group.setText("VM arguments (appended to arguments defined in launch.properties):");
                this.vmArgsText = new Text((Composite)group, 2626);
                gd = new GridData(1808);
                gd.heightHint = 40;
                gd.widthHint = 100;
                this.vmArgsText.setLayoutData((Object)gd);
                this.vmArgsText.addModifyListener(evt -> this.scheduleUpdateJob());
                this.setControl((Control)container);
            }

            public void setDefaults(ILaunchConfigurationWorkingCopy config) {
                try {
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute("ghidradev.ghidraProgramArguments", "");
                    wc.setAttribute("ghidradev.ghidraVmArguments", "");
                    wc.doSave();
                }
                catch (CoreException e) {
                    EclipseMessageUtils.error("Failed to set argument defaults.", e);
                }
            }

            public void initializeFrom(ILaunchConfiguration config) {
                try {
                    this.programArgsText.setText(config.getAttribute("ghidradev.ghidraProgramArguments", ""));
                    this.vmArgsText.setText(config.getAttribute("ghidradev.ghidraVmArguments", ""));
                }
                catch (CoreException e) {
                    EclipseMessageUtils.error("Failed to initialize the arguments.", e);
                }
            }

            public void performApply(ILaunchConfigurationWorkingCopy config) {
                try {
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute("ghidradev.ghidraProgramArguments", this.programArgsText.getText());
                    wc.setAttribute("ghidradev.ghidraVmArguments", this.vmArgsText.getText());
                    wc.doSave();
                }
                catch (CoreException e) {
                    EclipseMessageUtils.error("Failed to apply the arguments.", e);
                }
            }

            public String getName() {
                return "Arguments";
            }
        };
    }

    private CommonTab getCommonTab() {
        return new CommonTab(){

            public void initializeFrom(ILaunchConfiguration config) {
                try {
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    GhidraLaunchUtils.setFavorites(wc);
                    super.initializeFrom(wc.doSave());
                }
                catch (CoreException e) {
                    EclipseMessageUtils.error("Failed to initialize the common tab.", e);
                }
            }
        };
    }
}

