/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.preferences;

import ghidra.GhidraApplicationLayout;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.ApplicationVersion;
import ghidradev.Activator;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.preferences.GhidraProjectCreatorPreferences;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GhidraProjectCreatorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static ApplicationVersion MIN_GHIDRA_VERSION = new ApplicationVersion("9.1");
    private Table table;
    private Button addButton;
    private Button removeButton;

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        this.noDefaultButton();
        FontData fontData = parent.getFont().getFontData()[0];
        Font bold = new Font((Device)parent.getDisplay(), fontData.getName(), fontData.getHeight(), 1);
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        Label descriptionLabel = new Label(container, 0);
        descriptionLabel.setText("Add or remove Ghidra installation directories.\nThe checked Ghidra installation is the default used when creating new projects.\nRed entries correspond to invalid Ghidra installation directories.");
        new Label(container, 0).setText("");
        this.table = new Table(container, 67616);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addListener(13, evt -> {
            if (evt.detail == 32) {
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(item.equals(evt.item));
                    item.setFont(item.equals(evt.item) ? bold : parent.getFont());
                    ++n2;
                }
            }
        });
        TableColumn col = new TableColumn(this.table, 4);
        col.setText("Ghidra installation directories");
        col.setWidth(400);
        for (File dir : GhidraProjectCreatorPreferences.getGhidraInstallDirs()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(dir.getAbsolutePath());
            try {
                GhidraProjectCreatorPreferencePage.validateGhidraInstallation(dir);
                item.setForeground(parent.getDisplay().getSystemColor(2));
            }
            catch (IOException iOException) {
                item.setForeground(parent.getDisplay().getSystemColor(3));
            }
            if (!dir.equals(GhidraProjectCreatorPreferences.getGhidraDefaultInstallDir())) continue;
            item.setFont(bold);
            item.setChecked(true);
        }
        if (this.table.getItemCount() > 0) {
            col.pack();
        }
        Composite buttons = new Composite(container, 0);
        buttons.setLayoutData((Object)new GridData(2));
        buttons.setLayout((Layout)new FillLayout(512));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("Add...");
        this.addButton.addListener(13, evt -> {
            DirectoryDialog dialog = new DirectoryDialog(container.getShell());
            String path = dialog.open();
            if (path == null) {
                return;
            }
            if (Arrays.stream(this.table.getItems()).anyMatch(item -> item.getText().equals(path))) {
                EclipseMessageUtils.showErrorDialog("Ghidra installation already specified.");
                return;
            }
            try {
                GhidraProjectCreatorPreferencePage.validateGhidraInstallation(new File(path));
                TableItem item2 = new TableItem(this.table, 0);
                item2.setText(path);
                item2.setChecked(this.table.getItemCount() == 1);
                item2.setFont(item2.getChecked() ? bold : parent.getFont());
            }
            catch (IOException e) {
                EclipseMessageUtils.showErrorDialog(e.getMessage());
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText("Remove");
        this.removeButton.addListener(13, evt -> {
            int selectionIndex = this.table.getSelectionIndex();
            if (selectionIndex == -1) {
                return;
            }
            boolean wasDefault = this.table.getItem(selectionIndex).getChecked();
            this.table.remove(selectionIndex);
            if (this.table.getItemCount() > 0) {
                if (selectionIndex < this.table.getItemCount()) {
                    this.table.select(selectionIndex);
                } else {
                    this.table.select(selectionIndex - 1);
                }
                if (wasDefault) {
                    TableItem item = this.table.getItem(this.table.getSelectionIndex());
                    item.setChecked(true);
                    item.setFont(bold);
                }
            }
        });
        return parent;
    }

    public boolean performOk() {
        super.performOk();
        GhidraProjectCreatorPreferences.setGhidraInstallDirs(Arrays.stream(this.table.getItems()).map(item -> new File(item.getText())).collect(Collectors.toSet()));
        GhidraProjectCreatorPreferences.setDefaultGhidraInstallDir(Arrays.stream(this.table.getItems()).filter(TableItem::getChecked).findFirst().map(item -> new File(item.getText())).orElse(null));
        return true;
    }

    public static void validateGhidraInstallation(File ghidraInstallDir) throws IOException {
        ApplicationVersion version;
        GhidraApplicationLayout layout;
        try {
            layout = new GhidraApplicationLayout(ghidraInstallDir);
        }
        catch (IOException iOException) {
            throw new IOException("Not a valid Ghidra installation.");
        }
        if (new File(ghidraInstallDir, "certification.local.manifest").isFile()) {
            throw new IOException("Ghidra source repositories are not supported.");
        }
        ApplicationProperties applicationProperties = layout.getApplicationProperties();
        try {
            version = new ApplicationVersion(applicationProperties.getApplicationVersion());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error parsing application version. " + e.getMessage() + ".");
        }
        if (version.compareTo(MIN_GHIDRA_VERSION) < 0) {
            throw new IOException("Ghidra installation must be version " + String.valueOf(MIN_GHIDRA_VERSION) + " or later.");
        }
        String layoutVersion = applicationProperties.getProperty("application.layout.version");
        if (layoutVersion == null || !layoutVersion.equals("1")) {
            throw new IOException("Ghidra application layout is not supported.  Please upgrade GhidraDev to use this version of Ghidra.");
        }
    }
}

