/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.preferences;

import ghidradev.Activator;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.jface.preference.IPreferenceStore;

public class GhidraProjectCreatorPreferences {
    static final String GHIDRA_INSTALL_PATHS = "ghidradev.ghidraInstallPaths";
    static final String GHIDRA_DEFAULT_INSTALL_PATH = "ghidradev.ghidraDefaultInstallPath";
    static final String GHIDRA_LAST_PROJECT_ROOT_PATH = "ghidradev.ghidraLastProjectRootPath";
    static final String GHIDRA_LAST_GRADLE_DISTRIBUTION = "ghidradev.ghidraLastGradleDistribution";

    public static Set<File> getGhidraInstallDirs() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String ghidraInstallDirPaths = prefs.getString(GHIDRA_INSTALL_PATHS);
        if (ghidraInstallDirPaths.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(ghidraInstallDirPaths.split(File.pathSeparator)).map(p -> new File((String)p)).collect(Collectors.toSet());
    }

    public static void setGhidraInstallDirs(Set<File> dirs) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String paths = dirs.stream().map(dir -> dir.getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        prefs.setValue(GHIDRA_INSTALL_PATHS, paths);
    }

    public static File getGhidraDefaultInstallDir() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String ghidraDefaultInstallDirPath = prefs.getString(GHIDRA_DEFAULT_INSTALL_PATH);
        if (ghidraDefaultInstallDirPath.isEmpty()) {
            return null;
        }
        return new File(ghidraDefaultInstallDirPath);
    }

    public static void setDefaultGhidraInstallDir(File dir) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        prefs.setValue(GHIDRA_DEFAULT_INSTALL_PATH, dir != null ? dir.getAbsolutePath() : "");
    }

    public static String getGhidraLastProjectRootPath() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        return prefs.getString(GHIDRA_LAST_PROJECT_ROOT_PATH);
    }

    public static void setGhidraLastProjectRootPath(String path) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        prefs.setValue(GHIDRA_LAST_PROJECT_ROOT_PATH, path);
    }

    public static GradleDistribution getGhidraLastGradleDistribution() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String pref = prefs.getString(GHIDRA_LAST_GRADLE_DISTRIBUTION);
        if (pref != null && !pref.isEmpty()) {
            try {
                return GradleDistribution.fromString((String)pref);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static void setGhidraLastGradleDistribution(GradleDistribution gradleDistribution) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        if (gradleDistribution != null) {
            prefs.setValue(GHIDRA_LAST_GRADLE_DISTRIBUTION, gradleDistribution.toString());
        } else {
            prefs.setToDefault(GHIDRA_LAST_GRADLE_DISTRIBUTION);
        }
    }
}

