/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import ghidra.GhidraLauncher;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class GhidraLaunchUtils {
    public static final String GUI_LAUNCH = "GhidraGuiLaunchConfigurationType";
    public static final String HEADLESS_LAUNCH = "GhidraHeadlessLaunchConfigurationType";
    public static final String ATTR_PROGAM_ARGUMENTS = "ghidradev.ghidraProgramArguments";
    public static final String ATTR_VM_ARGUMENTS = "ghidradev.ghidraVmArguments";

    public static ILaunchConfigurationWorkingCopy createLaunchConfig(IJavaProject javaProject, String launchConfigTypeId, String launchConfigName, String runConfigMemory) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType(launchConfigTypeId);
        ILaunchConfigurationWorkingCopy wc = launchType.newInstance(null, launchConfigName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getProject().getName());
        GhidraLaunchUtils.setMainTypeName(wc);
        GhidraLaunchUtils.setMemory(wc, runConfigMemory);
        GhidraLaunchUtils.setFavorites(wc);
        return wc;
    }

    public static ILaunchConfiguration getLaunchConfig(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration lc = iLaunchConfigurationArray[n2];
            if (lc.getName().equals(name)) {
                return lc;
            }
            ++n2;
        }
        return null;
    }

    public static ILaunchConfiguration getLaunchConfig(String name, String id) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(id);
        if (type != null) {
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration lc = iLaunchConfigurationArray[n2];
                if (lc.getName().equals(name)) {
                    return lc;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ILaunchConfigurationWorkingCopy setMainTypeName(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, GhidraLauncher.class.getName());
        return wc;
    }

    public static ILaunchConfigurationWorkingCopy setMemory(ILaunchConfigurationWorkingCopy wc, String memory) throws CoreException {
        if (memory != null) {
            Object vmArgs = wc.getAttribute(ATTR_VM_ARGUMENTS, "");
            if (!((String)vmArgs).isEmpty()) {
                vmArgs = (String)vmArgs + " ";
            }
            wc.setAttribute(ATTR_VM_ARGUMENTS, (String)vmArgs + "-Xmx" + memory);
        }
        return wc;
    }

    public static ILaunchConfigurationWorkingCopy setFavorites(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        List list = wc.getAttribute("org.eclipse.debug.ui.favoriteGroups", new ArrayList());
        list.add("org.eclipse.debug.ui.launchGroup.debug");
        list.add("org.eclipse.debug.ui.launchGroup.run");
        wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        return wc;
    }

    public static void addToFavorites(ILaunchConfiguration launchConfig) {
        LaunchConfigurationManager mgr = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchHistory runHistory = mgr.getLaunchHistory("org.eclipse.debug.ui.launchGroup.run");
        LaunchHistory debugHistory = mgr.getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
        runHistory.addFavorite(launchConfig);
        debugHistory.addFavorite(launchConfig);
    }
}

