/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import ghidra.GhidraApplicationLayout;
import ghidra.util.exception.CancelledException;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import utilities.util.FileUtilities;

public class GhidraModuleUtils {
    public static IJavaProject createGhidraModuleProject(String projectName, File projectDir, boolean createRunConfig, String runConfigMemory, GhidraApplicationLayout ghidraLayout, String jythonInterpreterName, IProgressMonitor monitor) throws IOException, ParseException, CoreException {
        IJavaProject javaProject = GhidraProjectUtils.createEmptyGhidraProject(projectName, projectDir, createRunConfig, runConfigMemory, ghidraLayout, jythonInterpreterName, monitor);
        IProject project = javaProject.getProject();
        ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
        sourceFolders.add(project.getFolder("src/main/java"));
        sourceFolders.add(project.getFolder("src/main/help"));
        sourceFolders.add(project.getFolder("src/main/resources"));
        sourceFolders.add(project.getFolder("ghidra_scripts"));
        for (IFolder sourceFolder : sourceFolders) {
            GhidraProjectUtils.createFolder(sourceFolder, monitor);
        }
        LinkedList<IClasspathEntry> classpathEntries = new LinkedList<IClasspathEntry>();
        for (IFolder sourceFolder : sourceFolders) {
            classpathEntries.add(JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath()));
        }
        GhidraProjectUtils.addToClasspath(javaProject, classpathEntries, monitor);
        return javaProject;
    }

    public static IFile configureModuleSource(IJavaProject javaProject, File projectDir, GhidraApplicationLayout ghidraLayout, Set<ModuleTemplateType> moduleTemplateTypes, IProgressMonitor monitor) throws CoreException, IOException {
        IFolder packageFolder;
        IJavaElement helpTopic;
        IProject project = javaProject.getProject();
        ArrayList<Object> excludeRegexes = new ArrayList<Object>();
        ModuleTemplateType[] moduleTemplateTypeArray = ModuleTemplateType.values();
        int n = moduleTemplateTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleTemplateType moduleTemplateType = moduleTemplateTypeArray[n2];
            if (!moduleTemplateTypes.contains((Object)moduleTemplateType)) {
                if (moduleTemplateType.equals((Object)ModuleTemplateType.PROCESSOR)) {
                    excludeRegexes.add("languages");
                    excludeRegexes.add("buildLanguage\\.xml");
                    excludeRegexes.add("sleighArgs\\.txt");
                } else {
                    excludeRegexes.add("Skeleton" + moduleTemplateType.getName() + "\\.java");
                }
            }
            ++n2;
        }
        File ghidraInstallDir = ghidraLayout.getApplicationInstallationDir().getFile(false);
        File skeletonDir = Files.find(ghidraInstallDir.toPath(), 4, (path, attrs) -> attrs.isDirectory() && path.getFileName().toString().equals("Skeleton"), new FileVisitOption[0]).map(p -> p.toFile()).findFirst().orElse(null);
        if (skeletonDir == null) {
            throw new IOException("Failed to find skeleton directory.");
        }
        try {
            FileUtilities.copyDir((File)skeletonDir, (File)projectDir, f -> excludeRegexes.stream().map(r -> Pattern.compile(r)).noneMatch(p -> p.matcher(f.getName()).matches()), null);
        }
        catch (CancelledException | IOException throwable) {
            throw new IOException("Failed to copy skeleton directory: " + String.valueOf(projectDir));
        }
        project.refreshLocal(2, monitor);
        GhidraModuleUtils.writeAntProperties(project, ghidraLayout);
        String packageName = project.getName().toLowerCase();
        for (ModuleTemplateType moduleTemplateType : moduleTemplateTypes) {
            IType skeletonClass = javaProject.findType("skeleton.Skeleton" + moduleTemplateType.getName(), monitor);
            if (skeletonClass == null) continue;
            GhidraModuleUtils.renameJavaElement((IJavaElement)skeletonClass.getCompilationUnit(), project.getName() + moduleTemplateType.getName(), monitor);
        }
        IJavaElement skeletonPackage = javaProject.findElement((IPath)new Path("skeleton"));
        if (skeletonPackage != null) {
            GhidraModuleUtils.renameJavaElement(skeletonPackage, packageName, monitor);
        }
        if ((helpTopic = javaProject.findElement((IPath)new Path("help/topics/skeleton"))) != null) {
            GhidraModuleUtils.renameJavaElement(helpTopic, "help.topics." + packageName, monitor);
        }
        if ((packageFolder = project.getFolder("/src/main/java").getFolder(packageName)).exists()) {
            IResource[] iResourceArray = packageFolder.members();
            int n3 = iResourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                if (resource instanceof IFile && resource.getName().endsWith(".java")) {
                    return (IFile)resource;
                }
                ++n4;
            }
        }
        return null;
    }

    public static void writeAntProperties(IProject project, GhidraApplicationLayout ghidraLayout) throws IOException {
        if (!GhidraProjectUtils.isGhidraModuleProject(project)) {
            return;
        }
        IFolder dataFolder = project.getFolder("data");
        if (!dataFolder.exists()) {
            return;
        }
        IFile buildXmlFile = dataFolder.getFile("buildLanguage.xml");
        if (!buildXmlFile.exists()) {
            return;
        }
        File ghidraInstallDir = ghidraLayout.getApplicationInstallationDir().getFile(false);
        File antFile = new File(project.getLocation().toFile(), ".antProperties.xml");
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintWriter writer = new PrintWriter(new FileWriter(antFile));){
            writer.println("<!-- This file is generated on each \"Link Ghidra\" command.  Do not modify. -->");
            writer.println();
            writer.println("<project>");
            writer.println("  <property name=\"ghidra.install.dir\" value=\"" + ghidraInstallDir.getAbsolutePath() + "\" />");
            writer.println("</project>");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void renameJavaElement(IJavaElement element, String newName, IProgressMonitor monitor) throws CoreException, IllegalArgumentException {
        String id;
        if (element.getElementType() == 4) {
            id = "org.eclipse.jdt.ui.rename.package";
        } else if (element.getElementType() == 5) {
            id = "org.eclipse.jdt.ui.rename.compilationunit";
        } else {
            throw new IllegalArgumentException("Can only rename packages and compilation units!");
        }
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)id);
        RenameJavaElementDescriptor descriptor = (RenameJavaElementDescriptor)contribution.createDescriptor();
        descriptor.setProject(element.getResource().getProject().getName());
        descriptor.setNewName(newName);
        descriptor.setJavaElement(element);
        RefactoringStatus status = new RefactoringStatus();
        Refactoring refactoring = descriptor.createRefactoring(status);
        refactoring.checkInitialConditions(monitor);
        refactoring.checkFinalConditions(monitor);
        Change change = refactoring.createChange(monitor);
        change.perform(monitor);
    }

    public static enum ModuleTemplateType {
        ANALYZER("Analyzer", "Extends Ghidra analysis"),
        PLUGIN("Plugin", "Extends the Ghidra user interface"),
        LOADER("Loader", "Loads/imports a binary file format into Ghidra"),
        FILESYSTEM("FileSystem", "Opens a file system format for browsing or batch import"),
        EXPORTER("Exporter", "Exports/saves a Ghidra program to a specific file format"),
        PROCESSOR("Processor", "Enables disassembly/decompilation of a processor/architecture");

        private String name;
        private String description;

        private ModuleTemplateType(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

