/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.framework.GModule;
import ghidra.launch.JavaConfig;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraLaunchUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraModuleUtils;
import ghidradev.ghidraprojectcreator.utils.PyDevUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.part.FileEditorInput;

public class GhidraProjectUtils {
    public static final String GHIDRA_FOLDER_NAME = "Ghidra";
    public static final String ILLEGAL_FILENAME_CHARS = " `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?";
    public static final String ILLEGAL_FILENAME_START_CHARS = "0123456789";

    public static Collection<IJavaProject> getJavaProjects() {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && GhidraProjectUtils.isJavaProject(project)) {
                javaProjects.add(JavaCore.create((IProject)project));
            }
            ++n2;
        }
        return javaProjects;
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project != null && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            EclipseMessageUtils.error("Java project check failed", e);
            return false;
        }
    }

    public static boolean isGhidraProject(IProject project) {
        return GhidraProjectUtils.isJavaProject(project) && project.getFolder(GHIDRA_FOLDER_NAME).exists();
    }

    public static boolean isGhidraModuleProject(IProject project) {
        return GhidraProjectUtils.isGhidraProject(project) && project.getFile("Module.manifest").exists();
    }

    public static Collection<IJavaProject> getGhidraProjects() {
        ArrayList<IJavaProject> ghidraProjects = new ArrayList<IJavaProject>();
        for (IJavaProject javaProject : GhidraProjectUtils.getJavaProjects()) {
            if (!GhidraProjectUtils.isGhidraProject(javaProject.getProject())) continue;
            ghidraProjects.add(javaProject);
        }
        return ghidraProjects;
    }

    public static IJavaProject getGhidraProject(String name) {
        for (IJavaProject javaProject : GhidraProjectUtils.getGhidraProjects()) {
            if (!javaProject.getProject().getName().equals(name)) continue;
            return javaProject;
        }
        return null;
    }

    public static IProject getSelectedProject(ISelection selection) {
        IProject project = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IResource) {
                project = ((IResource)firstElement).getProject();
            } else if (firstElement instanceof IJavaElement) {
                project = ((IJavaElement)firstElement).getResource().getProject();
            }
        }
        return project;
    }

    public static IProject getEnclosingProject(Object projectObj) {
        IJavaElement javaElement;
        IResource resource;
        List list;
        IProject project = null;
        if (projectObj instanceof List && (list = (List)projectObj).size() == 1) {
            projectObj = list.iterator().next();
        }
        if (projectObj instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)projectObj;
            project = fileEditorInput.getFile().getProject();
        } else if (projectObj instanceof IResource) {
            IResource resource2 = (IResource)projectObj;
            project = resource2.getProject();
        } else if (projectObj instanceof IJavaElement && (resource = (javaElement = (IJavaElement)projectObj).getResource()) != null) {
            project = resource.getProject();
        }
        return project;
    }

    public static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            GhidraProjectUtils.createFolder((IFolder)parent, monitor);
        }
        if (!folder.exists()) {
            folder.create(false, true, monitor);
        }
    }

    public static void addToClasspath(IJavaProject javaProject, List<IClasspathEntry> classpathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            classpathEntries.add(entry);
            ++n2;
        }
        javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), monitor);
    }

    public static void addToClasspath(IJavaProject javaProject, IClasspathEntry classpathEntry, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
        entryList.add(classpathEntry);
        GhidraProjectUtils.addToClasspath(javaProject, entryList, monitor);
    }

    public static IJavaProject createEmptyGhidraProject(String projectName, File projectDir, boolean createRunConfig, String runConfigMemory, GhidraApplicationLayout ghidraLayout, String jythonInterpreterName, IProgressMonitor monitor) throws IOException, ParseException, CoreException {
        JavaConfig javaConfig = new JavaConfig(ghidraLayout.getApplicationInstallationDir().getFile(false));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        projectDescription.setLocation((IPath)new Path(projectDir.getAbsolutePath()));
        projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        ICommand command = projectDescription.newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        projectDescription.setBuildSpec(new ICommand[]{command});
        project.create(projectDescription, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        project.open(monitor);
        javaProject.setRawClasspath(new IClasspathEntry[0], monitor);
        GhidraProjectUtils.configureJavaCompiler(javaProject, javaConfig);
        IFolder binFolder = project.getFolder("bin");
        javaProject.setOutputLocation(binFolder.getFullPath(), monitor);
        GhidraProjectUtils.addToClasspath(javaProject, JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT4_CONTAINER_PATH), monitor);
        GhidraProjectUtils.linkGhidraToProject(javaProject, ghidraLayout, javaConfig, jythonInterpreterName, monitor);
        if (createRunConfig) {
            try {
                ILaunchConfiguration launchConfig = GhidraLaunchUtils.createLaunchConfig(javaProject, "GhidraGuiLaunchConfigurationType", project.getName(), runConfigMemory).doSave();
                GhidraLaunchUtils.addToFavorites(launchConfig);
            }
            catch (CoreException coreException) {
                EclipseMessageUtils.showErrorDialog("Failed to create a Ghidra run configuration for the new project.  Please do it manually.");
            }
        }
        return javaProject;
    }

    public static void linkGhidraToProject(IJavaProject javaProject, GhidraApplicationLayout ghidraLayout, JavaConfig javaConfig, String jythonInterpreterName, IProgressMonitor monitor) throws CoreException, IOException {
        File oldGhidraDir;
        File ghidraInstallDir = ghidraLayout.getApplicationInstallationDir().getFile(false);
        IVMInstall vm = GhidraProjectUtils.getGhidraVm(javaConfig);
        IPath vmPath = new Path(JavaRuntime.JRE_CONTAINER).append(vm.getVMInstallType().getId()).append(vm.getName());
        IFolder ghidraFolder = javaProject.getProject().getFolder(GHIDRA_FOLDER_NAME);
        IPath oldGhidraPath = null;
        GhidraApplicationLayout oldGhidraLayout = null;
        if (ghidraFolder.exists() && (oldGhidraPath = ghidraFolder.getLocation()) != null && (oldGhidraDir = oldGhidraPath.toFile()).exists()) {
            oldGhidraLayout = new GhidraApplicationLayout(oldGhidraDir);
        }
        IClasspathEntry vmEntryCandidate = null;
        ArrayList<IClasspathEntry> classpathEntriesToKeep = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5 && entry.getPath().toString().startsWith(JavaRuntime.JRE_CONTAINER)) {
                if (oldGhidraPath == null) {
                    vmEntryCandidate = entry;
                }
            } else if (entry.getEntryKind() == 5 && entry.getPath().toString().startsWith("org.eclipse.jdt.junit.JUNIT_CONTAINER")) {
                classpathEntriesToKeep.add(entry);
            } else if (entry.getEntryKind() == 2) {
                classpathEntriesToKeep.add(entry);
            } else {
                IFolder entryFolder = null;
                if (entry.getEntryKind() == 3) {
                    entryFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(entry.getPath());
                }
                if (entryFolder != null && entryFolder.isLinked() && GhidraProjectUtils.inGhidraInstallation(oldGhidraPath, entryFolder.getLocation())) {
                    String origPath = entryFolder.getLocation().toString();
                    String newPath = ghidraInstallDir.getAbsolutePath() + origPath.substring(oldGhidraPath.toString().length());
                    entryFolder.createLink((IPath)new Path(newPath), 256, monitor);
                    classpathEntriesToKeep.add(JavaCore.newSourceEntry((IPath)entryFolder.getFullPath()));
                } else if (!GhidraProjectUtils.inGhidraInstallation(oldGhidraPath, entry.getPath()) && !GhidraProjectUtils.isGhidraExtension(oldGhidraLayout, entry.getPath())) {
                    classpathEntriesToKeep.add(entry);
                    ghidraLayout.getExtensionInstallationDirs();
                }
            }
            ++n2;
        }
        if (vmEntryCandidate == null || !vmEntryCandidate.getPath().equals((Object)vmPath) && EclipseMessageUtils.showConfirmDialog("Java Conflict", "Current Java: " + JavaRuntime.getVMInstall((IJavaProject)javaProject).getName() + "\nGhidra Java: " + vm.getName() + "\n\nPress OK to use Ghidra's Java, or cancel to keep current Java.")) {
            classpathEntriesToKeep.add(JavaCore.newContainerEntry((IPath)vmPath));
        } else {
            classpathEntriesToKeep.add(vmEntryCandidate);
        }
        List<IClasspathEntry> libraryClasspathEntries = GhidraProjectUtils.getGhidraLibraryClasspathEntries(ghidraLayout);
        classpathEntriesToKeep.addAll(libraryClasspathEntries);
        javaProject.setRawClasspath(classpathEntriesToKeep.toArray(new IClasspathEntry[classpathEntriesToKeep.size()]), null);
        ghidraFolder.createLink((IPath)new Path(ghidraInstallDir.getAbsolutePath()), 256, monitor);
        GhidraModuleUtils.writeAntProperties(javaProject.getProject(), ghidraLayout);
        if (PyDevUtils.isSupportedPyDevInstalled()) {
            try {
                PyDevUtils.setupPythonForProject(javaProject, libraryClasspathEntries, jythonInterpreterName, monitor);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                EclipseMessageUtils.showErrorDialog("PyDev error", "Failed to setup Python for the project.  PyDev version is not supported.");
            }
        }
    }

    private static boolean inGhidraInstallation(IPath ghidraInstallPath, IPath path) {
        return ghidraInstallPath != null && ghidraInstallPath.isPrefixOf(path);
    }

    private static boolean isGhidraExtension(GhidraApplicationLayout ghidraLayout, IPath path) {
        if (ghidraLayout != null) {
            for (ResourceFile extensionDir : ghidraLayout.getExtensionInstallationDirs()) {
                if (!new Path(extensionDir.getAbsolutePath()).isPrefixOf(path)) continue;
                return true;
            }
        }
        return false;
    }

    private static IClasspathAttribute getGhidraJavadoc(GhidraApplicationLayout ghidraLayout) throws FileNotFoundException {
        File ghidraInstallDir = ghidraLayout.getApplicationInstallationDir().getFile(false);
        File ghidraJavadocFile = new File(ghidraInstallDir, "docs/GhidraAPI_javadoc.zip");
        if (!ghidraJavadocFile.isFile()) {
            throw new FileNotFoundException("Ghidra javadoc file does not exist!");
        }
        String ghidraJavadocPath = String.format("jar:file:%s%s!/api/", ghidraJavadocFile.getAbsolutePath().startsWith("/") ? "" : "/", ghidraJavadocFile.getAbsolutePath());
        return JavaCore.newClasspathAttribute((String)"javadoc_location", (String)ghidraJavadocPath);
    }

    private static List<IClasspathEntry> getGhidraLibraryClasspathEntries(GhidraApplicationLayout ghidraLayout) throws FileNotFoundException {
        IClasspathAttribute ghidraJavadocAttr = GhidraProjectUtils.getGhidraJavadoc(ghidraLayout);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        for (GModule module : ghidraLayout.getModules().values()) {
            File moduleDir = module.getModuleRoot().getFile(false);
            File libDir = new File(moduleDir, "lib");
            if (!libDir.isDirectory()) continue;
            File[] fileArray = libDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String name = f.getName();
                if (name.endsWith(".jar")) {
                    Path jarPath = new Path(f.getAbsolutePath());
                    String baseJarName = name.substring(0, name.length() - 4);
                    File srcZipFile = new File(libDir, baseJarName + "-src.zip");
                    Path srcPath = srcZipFile.exists() ? new Path(srcZipFile.getAbsolutePath()) : null;
                    classpathEntries.add(JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ghidraJavadocAttr}, (boolean)false));
                }
                ++n2;
            }
        }
        return classpathEntries;
    }

    private static IVMInstall getGhidraVm(JavaConfig javaConfig) throws IOException, CoreException {
        IVMInstall existingVm;
        File requiredJavaHomeDir = javaConfig.getSavedJavaHome();
        IVMInstall vm = null;
        IVMInstallType standardType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        IVMInstallType macType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.launching.macosx.MacOSXType");
        if (standardType == null) {
            throw new CoreException((IStatus)new Status(4, "GhidraDev", 4, "Failed to find the standard Java VM type.", null));
        }
        IVMInstall[] iVMInstallArray = standardType.getVMInstalls();
        int n = iVMInstallArray.length;
        int n2 = 0;
        while (n2 < n) {
            existingVm = iVMInstallArray[n2];
            if (requiredJavaHomeDir.equals(existingVm.getInstallLocation())) {
                vm = existingVm;
                break;
            }
            ++n2;
        }
        if (macType != null && vm == null) {
            iVMInstallArray = macType.getVMInstalls();
            n = iVMInstallArray.length;
            n2 = 0;
            while (n2 < n) {
                existingVm = iVMInstallArray[n2];
                if (requiredJavaHomeDir.equals(existingVm.getInstallLocation())) {
                    vm = existingVm;
                    break;
                }
                ++n2;
            }
        }
        if (vm == null) {
            long unique = System.currentTimeMillis();
            while (standardType.findVMInstall(String.valueOf(unique)) != null) {
                ++unique;
            }
            VMStandin vmStandin = new VMStandin(standardType, String.valueOf(unique));
            String dirName = requiredJavaHomeDir.getName();
            if (requiredJavaHomeDir.getAbsolutePath().contains("Contents/Home")) {
                dirName = requiredJavaHomeDir.getParentFile().getParentFile().getName();
            }
            vmStandin.setName("GhidraDev_" + dirName);
            vmStandin.setInstallLocation(requiredJavaHomeDir);
            vm = vmStandin.convertToRealVM();
        }
        return vm;
    }

    private static void configureJavaCompiler(IJavaProject jp, JavaConfig javaConfig) {
        jp.setOption("org.eclipse.jdt.core.compiler.source", javaConfig.getCompilerComplianceLevel());
        jp.setOption("org.eclipse.jdt.core.compiler.compliance", javaConfig.getCompilerComplianceLevel());
        jp.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaConfig.getCompilerComplianceLevel());
        jp.setOption("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.emptyStatement", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "error");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.autoboxing", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.nullReference", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "error");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unusedLabel", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.finalParameterBound", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", "ignore");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", "error");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", "warning");
        jp.setOption("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
    }
}

