/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import ghidra.GhidraApplicationLayout;
import ghidra.framework.GModule;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GhidraScriptUtils {
    public static File userScriptsDir = new File(System.getProperty("user.home") + "/ghidra_scripts");

    public static IJavaProject createGhidraScriptProject(String projectName, File projectDir, boolean createRunConfig, String runConfigMemory, boolean linkUserScripts, boolean linkSystemScripts, GhidraApplicationLayout ghidraLayout, String jythonInterpreterName, IProgressMonitor monitor) throws IOException, ParseException, CoreException {
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = GhidraProjectUtils.createEmptyGhidraProject(projectName, projectDir, createRunConfig, runConfigMemory, ghidraLayout, jythonInterpreterName, monitor);
        if (linkSystemScripts) {
            for (GModule module : ghidraLayout.getModules().values()) {
                File moduleDir = module.getModuleRoot().getFile(false);
                File moduleScriptsDir = new File(moduleDir, "ghidra_scripts");
                if (!moduleScriptsDir.exists()) continue;
                Path moduleScriptsDirPath = new Path(moduleScriptsDir.getAbsolutePath());
                String moduleName = moduleDir.getName();
                String scriptsDirName = "Ghidra " + moduleName + " scripts";
                IFolder link = javaProject.getProject().getFolder(scriptsDirName);
                link.createLink((IPath)moduleScriptsDirPath, 0, monitor);
                classpathEntries.add(JavaCore.newSourceEntry((IPath)link.getFullPath()));
            }
        }
        if (linkUserScripts) {
            if (!userScriptsDir.isDirectory() && !userScriptsDir.mkdirs()) {
                throw new CoreException((IStatus)new Status(4, "GhidraDev", 4, "Failed to create " + String.valueOf(userScriptsDir), null));
            }
            IFolder link = javaProject.getProject().getFolder("Home scripts");
            link.createLink((IPath)new Path(userScriptsDir.getAbsolutePath()), 0, monitor);
            classpathEntries.add(JavaCore.newSourceEntry((IPath)link.getFullPath()));
        }
        GhidraProjectUtils.addToClasspath(javaProject, classpathEntries, monitor);
        return javaProject;
    }

    public static IFile createGhidraScript(IFolder scriptFolder, String scriptName, String scriptAuthor, String scriptCategory, String[] scriptDescription, IProgressMonitor monitor) throws CoreException, IOException {
        IFile scriptFile;
        if (!scriptFolder.exists()) {
            GhidraProjectUtils.createFolder(scriptFolder, monitor);
        }
        if ((scriptFile = scriptFolder.getFile(scriptName)).exists()) {
            throw new IOException("File already exists: " + String.valueOf(scriptFile));
        }
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (PrintWriter writer = new PrintWriter(new FileWriter(scriptFile.getLocation().toFile()));){
                if (scriptName.endsWith(".java")) {
                    Arrays.stream(scriptDescription).forEach(line -> writer.println("//" + line));
                    writer.println("//@author " + scriptAuthor);
                    writer.println("//@category " + scriptCategory);
                    writer.println("//@keybinding");
                    writer.println("//@menupath");
                    writer.println("//@toolbar");
                    writer.println();
                    writer.println("import ghidra.app.script.GhidraScript;");
                    writer.println();
                    writer.println("public class " + scriptName.substring(0, scriptName.length() - 5) + " extends GhidraScript {");
                    writer.println();
                    writer.println("\t@Override");
                    writer.println("\tprotected void run() throws Exception {");
                    writer.println("\t\t//TODO: Add script code here");
                    writer.println("\t}");
                    writer.println("}");
                } else if (scriptName.endsWith(".py")) {
                    Arrays.stream(scriptDescription).forEach(line -> writer.println("#" + line));
                    writer.println("#@author " + scriptAuthor);
                    writer.println("#@category " + scriptCategory);
                    writer.println("#@keybinding");
                    writer.println("#@menupath");
                    writer.println("#@toolbar");
                    writer.println();
                    writer.println("#TODO: Add script code here");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to create: " + String.valueOf(scriptFile));
        }
        scriptFile.getProject().refreshLocal(2, monitor);
        return scriptFile;
    }
}

