/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class PackageFragmentRootSelectionDialog
extends ElementTreeSelectionDialog {
    public PackageFragmentRootSelectionDialog(Shell shell, String title, String message, final String errorMessage) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(18), (ITreeContentProvider)new StandardJavaElementContentProvider());
        this.setTitle(title);
        this.setMessage(message);
        this.setAllowMultiple(false);
        this.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] sel) {
                if (sel.length == 1 && sel[0] instanceof IPackageFragmentRoot) {
                    return new Status(0, "GhidraDev", 0, "", null);
                }
                return new Status(4, "GhidraDev", 4, errorMessage, null);
            }
        });
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentObject, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                    return !packageFragmentRoot.isArchive() && !packageFragmentRoot.isExternal();
                }
                return element instanceof IJavaModel || element instanceof IJavaProject;
            }
        });
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        Object[] result = this.getResult();
        if (result.length == 1 && result[0] instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)result[0];
        }
        return null;
    }
}

