/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import ghidradev.ghidraprojectcreator.utils.PyDevUtilsInternal;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import javax.naming.OperationNotSupportedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class PyDevUtils {
    public static final String MIN_SUPPORTED_VERSION = "6.3.1";
    public static final String MAX_SUPPORTED_VERSION = "9.3.0";

    public static boolean isSupportedPyDevInstalled() {
        Version min = Version.valueOf((String)MIN_SUPPORTED_VERSION);
        Version max = Version.valueOf((String)MAX_SUPPORTED_VERSION);
        try {
            Version version = PyDevUtilsInternal.getPyDevVersion();
            if (version != null) {
                PyDevUtils.getJython27InterpreterNames();
                return version.compareTo(min) >= 0 && version.compareTo(max) <= 0;
            }
        }
        catch (NoClassDefFoundError | OperationNotSupportedException throwable) {}
        return false;
    }

    public static List<String> getJython27InterpreterNames() throws OperationNotSupportedException {
        try {
            return PyDevUtilsInternal.getJython27InterpreterNames();
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new OperationNotSupportedException(e.getMessage());
        }
    }

    public static void addJythonInterpreter(String interpreterName, File interpreterFile, File interpreterLibDir) throws OperationNotSupportedException {
        try {
            PyDevUtilsInternal.addJythonInterpreter(interpreterName, interpreterFile, interpreterLibDir);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new OperationNotSupportedException(e.getMessage());
        }
    }

    public static void setupPythonForProject(IJavaProject javaProject, List<IClasspathEntry> classpathEntries, String jythonInterpreterName, IProgressMonitor monitor) throws CoreException, OperationNotSupportedException {
        try {
            PyDevUtilsInternal.setupPythonForProject(javaProject, classpathEntries, jythonInterpreterName, monitor);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new OperationNotSupportedException(e.getMessage());
        }
    }

    public static void startPyDevRemoteDebugger() throws OperationNotSupportedException {
        try {
            PyDevUtilsInternal.startPyDevRemoteDebugger();
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new OperationNotSupportedException(e.getMessage());
        }
    }

    public static String getJythonPreferencePageId() {
        return "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageJython";
    }

    public static File getPyDevSrcDir() throws CoreException {
        Bundle[] bundles = FrameworkUtil.getBundle(PyDevUtilsInternal.class).getBundleContext().getBundles();
        Bundle pydevCoreBundle = Stream.of(bundles).filter(bundle -> bundle.getSymbolicName().contains("org.python.pydev.core")).findFirst().orElse(null);
        if (pydevCoreBundle != null) {
            try {
                URL pydevDirUrl = FileLocator.toFileURL((URL)pydevCoreBundle.getEntry("/"));
                URI pydevDirUri = new URI(pydevDirUrl.getProtocol(), pydevDirUrl.getPath(), null).normalize();
                Path pysrcDir = Paths.get(pydevDirUri).resolve("pysrc");
                if (Files.exists(pysrcDir, new LinkOption[0])) {
                    return pysrcDir.toFile();
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "GhidraDev", 4, "Problem searching for PyDev source directory", (Throwable)e));
            }
        }
        return null;
    }
}

