/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.utils;

import com.python.pydev.debug.remote.client_api.PydevRemoteDebuggerServer;
import ghidradev.EclipseMessageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.plugin.nature.PythonNature;

class PyDevUtilsInternal {
    public static Version getPyDevVersion() throws NoClassDefFoundError {
        Bundle[] bundleArray = FrameworkUtil.getBundle(PyDevUtilsInternal.class).getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().contains("pydev")) {
                Version version = bundle.getVersion();
                return new Version(version.getMajor(), version.getMinor(), version.getMicro());
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getJython27InterpreterNames() throws NoClassDefFoundError, NoSuchMethodError {
        ArrayList<String> interpreters = new ArrayList<String>();
        IInterpreterManager iMan = InterpreterManagersAPI.getJythonInterpreterManager((boolean)true);
        IInterpreterInfo[] iInterpreterInfoArray = iMan.getInterpreterInfos();
        int n = iInterpreterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo info = iInterpreterInfoArray[n2];
            if (info.getInterpreterType() == 1 && info.getVersion().equals("2.7")) {
                interpreters.add(info.getName());
            }
            ++n2;
        }
        return interpreters;
    }

    public static void addJythonInterpreter(String interpreterName, File interpreterFile, File interpreterLibDir) throws NoClassDefFoundError, NoSuchMethodError {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IInterpreterManager iMan = InterpreterManagersAPI.getJythonInterpreterManager((boolean)true);
        IInterpreterInfo iInfo = iMan.createInterpreterInfo(interpreterFile.getAbsolutePath(), (IProgressMonitor)monitor, false);
        iInfo.setName(interpreterName);
        if (iInfo instanceof InterpreterInfo) {
            InterpreterInfo info = (InterpreterInfo)iInfo;
            info.libs.add(interpreterLibDir.getAbsolutePath());
            info.libs.add(new File(interpreterLibDir, "site-packages").getAbsolutePath());
        } else {
            EclipseMessageUtils.error("Failed to add Jython Lib directory to python path");
        }
        IInterpreterInfo[] interpreterInfos = iMan.getInterpreterInfos();
        IInterpreterInfo[] newInterpreterInfos = Arrays.copyOf(interpreterInfos, interpreterInfos.length + 1);
        newInterpreterInfos[interpreterInfos.length] = iInfo;
        iMan.setInfos(newInterpreterInfos, null, (IProgressMonitor)monitor);
    }

    public static void setupPythonForProject(IJavaProject javaProject, List<IClasspathEntry> classpathEntries, String jythonInterpreterName, IProgressMonitor monitor) throws CoreException, NoClassDefFoundError, NoSuchMethodError {
        PythonNature.removeNature((IProject)javaProject.getProject(), (IProgressMonitor)monitor);
        if (jythonInterpreterName != null) {
            String libs = classpathEntries.stream().map(e -> e.getPath().toOSString()).collect(Collectors.joining("|"));
            PythonNature.addNature((IProject)javaProject.getProject(), (IProgressMonitor)monitor, (String)"jython 2.7", null, (String)libs, (String)jythonInterpreterName, null);
        }
    }

    public static void startPyDevRemoteDebugger() throws NoClassDefFoundError, NoSuchMethodError {
        PydevRemoteDebuggerServer.startServer();
    }

    private PyDevUtilsInternal() throws NoClassDefFoundError {
    }
}

