/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards;

import ghidra.GhidraApplicationLayout;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraModuleUtils;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseGhidraInstallationWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.ConfigureGhidraModuleProjectWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.CreateGhidraProjectWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.EnablePythonWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import utilities.util.FileUtilities;

public class CreateGhidraModuleProjectWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private CreateGhidraProjectWizardPage projectPage;
    private ConfigureGhidraModuleProjectWizardPage projectConfigPage;
    private ChooseGhidraInstallationWizardPage ghidraInstallationPage;
    private EnablePythonWizardPage pythonPage;

    public CreateGhidraModuleProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.workbench = wb;
        this.projectPage = new CreateGhidraProjectWizardPage();
        this.projectConfigPage = new ConfigureGhidraModuleProjectWizardPage();
        this.ghidraInstallationPage = new ChooseGhidraInstallationWizardPage();
        this.pythonPage = new EnablePythonWizardPage(this.ghidraInstallationPage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.projectConfigPage);
        this.addPage((IWizardPage)this.ghidraInstallationPage);
        this.addPage((IWizardPage)this.pythonPage);
    }

    public boolean performFinish() {
        if (!this.validate()) {
            return false;
        }
        File ghidraInstallDir = this.ghidraInstallationPage.getGhidraInstallDir();
        String projectName = this.projectPage.getProjectName();
        boolean createRunConfig = this.projectPage.shouldCreateRunConfig();
        String runConfigMemory = this.projectPage.getRunConfigMemory();
        File projectDir = this.projectPage.getProjectDir();
        String jythonInterpreterName = this.pythonPage.getJythonInterpreterName();
        Set<GhidraModuleUtils.ModuleTemplateType> moduleTemplateTypes = this.projectConfigPage.getModuleTemplateTypes();
        try {
            this.getContainer().run(true, false, monitor -> this.create(ghidraInstallDir, projectName, projectDir, createRunConfig, runConfigMemory, moduleTemplateTypes, jythonInterpreterName, monitor));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            EclipseMessageUtils.error(EclipseMessageUtils.showWizardErrorDialog(this.getShell(), e), e);
            return false;
        }
        return true;
    }

    private void create(File ghidraInstallDir, String projectName, File projectDir, boolean createRunConfig, String runConfigMemory, Set<GhidraModuleUtils.ModuleTemplateType> moduleTemplateTypes, String jythonInterpreterName, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                EclipseMessageUtils.info("Creating " + projectName + " at " + String.valueOf(projectDir));
                monitor.beginTask("Creating " + projectName, 3);
                GhidraApplicationLayout ghidraLayout = new GhidraApplicationLayout(ghidraInstallDir);
                monitor.worked(1);
                IJavaProject javaProject = GhidraModuleUtils.createGhidraModuleProject(projectName, projectDir, createRunConfig, runConfigMemory, ghidraLayout, jythonInterpreterName, monitor);
                monitor.worked(1);
                IFile sourceFile = GhidraModuleUtils.configureModuleSource(javaProject, projectDir, ghidraLayout, moduleTemplateTypes, monitor);
                monitor.worked(1);
                if (sourceFile != null) {
                    EclipseMessageUtils.displayInEditor(sourceFile, this.workbench);
                }
                EclipseMessageUtils.info("Finished creating " + projectName);
            }
            catch (IOException | ParseException | CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean validate() {
        if (FileUtilities.isPathContainedWithin((File)this.ghidraInstallationPage.getGhidraInstallDir(), (File)this.projectPage.getProjectDir())) {
            EclipseMessageUtils.showErrorDialog("Invalid Project Root Directory", "Project root directory cannot reside inside of the selected Ghidra installation directory.");
            return false;
        }
        return true;
    }
}

