/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards;

import ghidra.GhidraApplicationLayout;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraScriptUtils;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseGhidraInstallationWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.ConfigureGhidraScriptProjectWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.CreateGhidraProjectWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.EnablePythonWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import utilities.util.FileUtilities;

public class CreateGhidraScriptProjectWizard
extends Wizard
implements INewWizard {
    private CreateGhidraProjectWizardPage projectPage;
    private ConfigureGhidraScriptProjectWizardPage projectConfigPage;
    private ChooseGhidraInstallationWizardPage ghidraInstallationPage;
    private EnablePythonWizardPage pythonPage;

    public CreateGhidraScriptProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.projectPage = new CreateGhidraProjectWizardPage("GhidraScripts");
        this.projectConfigPage = new ConfigureGhidraScriptProjectWizardPage();
        this.ghidraInstallationPage = new ChooseGhidraInstallationWizardPage();
        this.pythonPage = new EnablePythonWizardPage(this.ghidraInstallationPage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.projectConfigPage);
        this.addPage((IWizardPage)this.ghidraInstallationPage);
        this.addPage((IWizardPage)this.pythonPage);
    }

    public boolean performFinish() {
        if (!this.validate()) {
            return false;
        }
        File ghidraInstallDir = this.ghidraInstallationPage.getGhidraInstallDir();
        String projectName = this.projectPage.getProjectName();
        File projectDir = this.projectPage.getProjectDir();
        boolean createRunConfig = this.projectPage.shouldCreateRunConfig();
        String runConfigMemory = this.projectPage.getRunConfigMemory();
        boolean linkUserScripts = this.projectConfigPage.shouldLinkUsersScripts();
        boolean linkSystemScripts = this.projectConfigPage.shouldLinkSystemScripts();
        String jythonInterpreterName = this.pythonPage.getJythonInterpreterName();
        try {
            this.getContainer().run(true, false, monitor -> this.create(ghidraInstallDir, projectName, projectDir, createRunConfig, runConfigMemory, linkUserScripts, linkSystemScripts, jythonInterpreterName, monitor));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            EclipseMessageUtils.error(EclipseMessageUtils.showWizardErrorDialog(this.getShell(), e), e);
            return false;
        }
        return true;
    }

    private void create(File ghidraInstallDir, String projectName, File projectDir, boolean createRunConfig, String runConfigMemory, boolean linkUserScripts, boolean linkSystemScripts, String jythonInterpreterName, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                EclipseMessageUtils.info("Creating " + projectName + " at " + String.valueOf(projectDir));
                monitor.beginTask("Creating " + projectName, 2);
                GhidraApplicationLayout ghidraLayout = new GhidraApplicationLayout(ghidraInstallDir);
                monitor.worked(1);
                GhidraScriptUtils.createGhidraScriptProject(projectName, projectDir, createRunConfig, runConfigMemory, linkUserScripts, linkSystemScripts, ghidraLayout, jythonInterpreterName, monitor);
                monitor.worked(1);
                EclipseMessageUtils.info("Finished creating " + projectName);
            }
            catch (IOException | ParseException | CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean validate() {
        if (FileUtilities.isPathContainedWithin((File)this.ghidraInstallationPage.getGhidraInstallDir(), (File)this.projectPage.getProjectDir())) {
            EclipseMessageUtils.showErrorDialog("Invalid Project Root Directory", "Project root directory cannot reside inside of the selected Ghidra installation directory.");
            return false;
        }
        return true;
    }
}

