/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards;

import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraScriptUtils;
import ghidradev.ghidraprojectcreator.wizards.pages.CreateGhidraScriptWizardPage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateGhidraScriptWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private CreateGhidraScriptWizardPage scriptPage;

    public CreateGhidraScriptWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.workbench = wb;
        IPackageFragmentRoot selectedPackageFragmentRoot = null;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IPackageFragmentRoot) {
            selectedPackageFragmentRoot = (IPackageFragmentRoot)firstElement;
        }
        this.scriptPage = new CreateGhidraScriptWizardPage(selectedPackageFragmentRoot);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.scriptPage);
    }

    public boolean performFinish() {
        IFolder scriptFolder = this.scriptPage.getScriptFolder();
        String scriptName = this.scriptPage.getScriptName();
        String scriptAuthor = this.scriptPage.getScriptAuthor();
        String scriptCategory = this.scriptPage.getScriptCategory();
        String[] scriptDescription = this.scriptPage.getScriptDescription();
        try {
            this.getContainer().run(true, false, monitor -> this.create(scriptFolder, scriptName, scriptAuthor, scriptCategory, scriptDescription, monitor));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            EclipseMessageUtils.error(EclipseMessageUtils.showWizardErrorDialog(this.getShell(), e), e);
            return false;
        }
        return true;
    }

    private void create(IFolder scriptFolder, String scriptName, String scriptAuthor, String scriptCategory, String[] scriptDescription, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                EclipseMessageUtils.info("Creating " + scriptName + " in " + scriptFolder.toString());
                monitor.beginTask("Creating " + scriptName + " in " + scriptFolder.toString(), 1);
                IFile scriptFile = GhidraScriptUtils.createGhidraScript(scriptFolder, scriptName, scriptAuthor, scriptCategory, scriptDescription, monitor);
                monitor.worked(1);
                if (scriptFile != null) {
                    EclipseMessageUtils.displayInEditor(scriptFile, this.workbench);
                }
                EclipseMessageUtils.info("Finished creating " + scriptName);
            }
            catch (IOException | CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

