/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards;

import ghidra.GhidraApplicationLayout;
import ghidra.launch.JavaConfig;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseGhidraModuleProjectWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.ConfigureGradleWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import utilities.util.FileUtilities;

public class ExportGhidraModuleWizard
extends Wizard
implements INewWizard {
    private ChooseGhidraModuleProjectWizardPage projectPage;
    private ConfigureGradleWizardPage gradlePage;

    public ExportGhidraModuleWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.projectPage = new ChooseGhidraModuleProjectWizardPage(GhidraProjectUtils.getSelectedProject((ISelection)selection));
        this.gradlePage = new ConfigureGradleWizardPage(this.projectPage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.gradlePage);
    }

    public boolean performFinish() {
        IJavaProject javaProject = this.projectPage.getGhidraModuleProject();
        GradleDistribution gradleDist = this.gradlePage.getGradleDistribution();
        try {
            this.getContainer().run(true, false, monitor -> this.export(javaProject, gradleDist, monitor));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            EclipseMessageUtils.error(EclipseMessageUtils.showWizardErrorDialog(this.getShell(), e), e);
            return false;
        }
        return true;
    }

    private void export(IJavaProject javaProject, GradleDistribution gradleDistribution, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                IProject project = javaProject.getProject();
                EclipseMessageUtils.info("Exporting " + project.getName());
                monitor.beginTask("Exporting " + project.getName(), 2);
                String ghidraInstallDirPath = project.getFolder("Ghidra").getLocation().toOSString();
                GhidraApplicationLayout ghidraLayout = new GhidraApplicationLayout(new File(ghidraInstallDirPath));
                File javaHomeDir = new JavaConfig(ghidraLayout.getApplicationInstallationDir().getFile(false)).getSavedJavaHome();
                if (javaHomeDir == null) {
                    throw new IOException("Failed to get the Java home associated with the project.  Perform a \"Link Ghidra\" operation on the project and try again.");
                }
                ArrayList tasks = new ArrayList();
                String workingDir = project.getLocation().toOSString();
                String gradleDist = gradleDistribution.toString();
                String gradleUserHome = "";
                String javaHome = javaHomeDir.getAbsolutePath();
                ArrayList jvmArgs = new ArrayList();
                List<String> gradleArgs = Arrays.asList("-PGHIDRA_INSTALL_DIR=" + ghidraInstallDirPath);
                boolean showExecutionView = false;
                boolean showConsoleView = true;
                boolean overrideWorkspaceSettings = true;
                boolean isOffline = true;
                boolean isBuildScansEnabled = false;
                GradleRunConfigurationAttributes gradleAttributes = new GradleRunConfigurationAttributes(tasks, workingDir, gradleDist, gradleUserHome, javaHome, jvmArgs, gradleArgs, showExecutionView, showConsoleView, overrideWorkspaceSettings, isOffline, isBuildScansEnabled);
                GradleLaunchConfigurationManager lm = CorePlugin.gradleLaunchConfigurationManager();
                ILaunchConfiguration lc = lm.getOrCreateRunConfiguration(gradleAttributes);
                lc.launch("run", monitor, true, true);
                lc.delete();
                monitor.worked(1);
                File buildDir = new File(workingDir, "build");
                FileUtilities.deleteDir((File)buildDir);
                project.refreshLocal(2, monitor);
                monitor.worked(1);
                EclipseMessageUtils.info("Finished exporting " + project.getName());
            }
            catch (IOException | ParseException | CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

