/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards;

import ghidra.GhidraApplicationLayout;
import ghidra.launch.JavaConfig;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseGhidraInstallationWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseJavaProjectWizardPage;
import ghidradev.ghidraprojectcreator.wizards.pages.EnablePythonWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class LinkGhidraWizard
extends Wizard {
    private ChooseGhidraInstallationWizardPage ghidraInstallationPage;
    private ChooseJavaProjectWizardPage projectPage;
    private EnablePythonWizardPage pythonPage;

    public LinkGhidraWizard(ISelection selection) {
        this.setNeedsProgressMonitor(true);
        this.ghidraInstallationPage = new ChooseGhidraInstallationWizardPage();
        this.projectPage = new ChooseJavaProjectWizardPage(GhidraProjectUtils.getSelectedProject(selection));
        this.pythonPage = new EnablePythonWizardPage(this.ghidraInstallationPage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.ghidraInstallationPage);
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)this.pythonPage);
    }

    public boolean performFinish() {
        File ghidraInstallDir = this.ghidraInstallationPage.getGhidraInstallDir();
        IJavaProject javaProject = this.projectPage.getJavaProject();
        String jythonInterpreterName = this.pythonPage.getJythonInterpreterName();
        try {
            this.getContainer().run(true, false, monitor -> this.link(ghidraInstallDir, javaProject, jythonInterpreterName, monitor));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            EclipseMessageUtils.error(EclipseMessageUtils.showWizardErrorDialog(this.getShell(), e), e);
            return false;
        }
        return true;
    }

    private void link(File ghidraInstallDir, IJavaProject javaProject, String jythonInterpreterName, IProgressMonitor monitor) throws InvocationTargetException {
        IProject project = javaProject.getProject();
        try {
            try {
                EclipseMessageUtils.info("Linking " + project.getName());
                monitor.beginTask("Linking " + project.getName(), 2);
                GhidraApplicationLayout ghidraLayout = new GhidraApplicationLayout(ghidraInstallDir);
                JavaConfig javaConfig = new JavaConfig(ghidraLayout.getApplicationInstallationDir().getFile(false));
                GhidraProjectUtils.linkGhidraToProject(javaProject, ghidraLayout, javaConfig, jythonInterpreterName, monitor);
                monitor.worked(1);
                project.refreshLocal(2, monitor);
                monitor.worked(1);
                EclipseMessageUtils.info("Finished linking " + project.getName());
            }
            catch (IOException | ParseException | CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

