/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidra.launch.JavaConfig;
import ghidra.launch.JavaFinder;
import ghidradev.ghidraprojectcreator.preferences.GhidraProjectCreatorPreferencePage;
import ghidradev.ghidraprojectcreator.preferences.GhidraProjectCreatorPreferences;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ChooseGhidraInstallationWizardPage
extends WizardPage {
    private Combo ghidraInstallDirCombo;
    private Button addGhidraInstallDirButton;

    public ChooseGhidraInstallationWizardPage() {
        super("ChooseGhidraInstallationWizardPage");
        this.setTitle("Choose a Ghidra Installation");
        this.setDescription("Choose the Ghidra installation to use.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label ghidraInstallDirLabel = new Label(container, 0);
        ghidraInstallDirLabel.setText("Ghidra installation:");
        this.ghidraInstallDirCombo = new Combo(container, 12);
        this.ghidraInstallDirCombo.setLayoutData((Object)new GridData(768));
        this.populateGhidraInstallationCombo();
        this.ghidraInstallDirCombo.addModifyListener(evt -> this.validate());
        this.ghidraInstallDirCombo.setToolTipText("The wizard requires a Ghidra installation to be selected.  Click the + button to add or manage Ghidra installations.");
        this.addGhidraInstallDirButton = new Button(container, 524288);
        this.addGhidraInstallDirButton.setText("+");
        this.addGhidraInstallDirButton.setToolTipText("Adds/manages Ghidra installations.");
        this.addGhidraInstallDirButton.addListener(13, evt -> {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)GhidraProjectCreatorPreferencePage.class.getName(), null, null);
            dialog.open();
            this.populateGhidraInstallationCombo();
            this.validate();
        });
        this.validate();
        this.setControl((Control)container);
    }

    public File getGhidraInstallDir() {
        return new File(this.ghidraInstallDirCombo.getText());
    }

    private void validate() {
        Object message = null;
        if (GhidraProjectCreatorPreferences.getGhidraInstallDirs().isEmpty()) {
            message = "No Ghidra installations found.  Click the + button to add one.";
        } else if (this.ghidraInstallDirCombo.getText().isEmpty()) {
            message = "Ghidra installation must be specified.";
        } else {
            try {
                File ghidraInstallDir = new File(this.ghidraInstallDirCombo.getText());
                GhidraProjectCreatorPreferencePage.validateGhidraInstallation(ghidraInstallDir);
                try {
                    JavaConfig javaConfig = new JavaConfig(ghidraInstallDir);
                    if (!javaConfig.isSupportedJavaHomeDir(javaConfig.getSavedJavaHome(), JavaFinder.JavaFilter.JDK_ONLY)) {
                        message = "A supported JDK is not associated with this Ghidra installation. Please run this Ghidra and try again.";
                    }
                }
                catch (IOException | ParseException e) {
                    message = "Failed to determine Ghidra's JDK version.  " + e.getMessage();
                }
            }
            catch (IOException e) {
                message = e.getMessage();
            }
        }
        this.setErrorMessage((String)message);
        this.setPageComplete(message == null);
    }

    private void populateGhidraInstallationCombo() {
        this.ghidraInstallDirCombo.removeAll();
        for (File dir : GhidraProjectCreatorPreferences.getGhidraInstallDirs()) {
            this.ghidraInstallDirCombo.add(dir.getAbsolutePath());
            if (!dir.equals(GhidraProjectCreatorPreferences.getGhidraDefaultInstallDir())) continue;
            this.ghidraInstallDirCombo.setText(dir.getAbsolutePath());
        }
    }
}

