/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidradev.ghidraprojectcreator.utils.GhidraProjectUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChooseJavaProjectWizardPage
extends WizardPage {
    private IProject selectedProject;
    private Combo projectCombo;

    public ChooseJavaProjectWizardPage(IProject selectedProject) {
        super("ChooseJavaProjectWizardPage");
        this.setTitle("Choose Java Project");
        this.setDescription("Choose an existing Java project.");
        this.selectedProject = selectedProject;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label projectNameLabel = new Label(container, 0);
        projectNameLabel.setText("Java project:");
        this.projectCombo = new Combo(container, 12);
        GridData gd = new GridData(768);
        this.projectCombo.setLayoutData((Object)gd);
        this.projectCombo.addModifyListener(evt -> this.validate());
        for (IJavaProject javaProject : GhidraProjectUtils.getJavaProjects()) {
            IProject project = javaProject.getProject();
            this.projectCombo.add(project.getName());
            if (!project.equals((Object)this.selectedProject)) continue;
            this.projectCombo.setText(project.getName());
        }
        this.validate();
        this.setControl((Control)container);
    }

    public IJavaProject getJavaProject() {
        for (IJavaProject javaProject : GhidraProjectUtils.getJavaProjects()) {
            IProject project = javaProject.getProject();
            if (!project.getName().equals(this.projectCombo.getText())) continue;
            return javaProject;
        }
        return null;
    }

    private void validate() {
        String message = null;
        String projectName = this.projectCombo.getText();
        if (projectName.isEmpty()) {
            message = "Existing Java project must be specified";
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

