/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidradev.ghidraprojectcreator.utils.GhidraModuleUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConfigureGhidraModuleProjectWizardPage
extends WizardPage {
    private Map<Button, GhidraModuleUtils.ModuleTemplateType> moduleTemplateCheckboxMap;

    public ConfigureGhidraModuleProjectWizardPage() {
        super("ConfigureGhidraModuleProjectWizardPage");
        this.setTitle("Configure Ghidra Module Project");
        this.setDescription("Configure a new Ghidra module project.");
        this.moduleTemplateCheckboxMap = new HashMap<Button, GhidraModuleUtils.ModuleTemplateType>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Label moduleTemplateLabel = new Label(container, 0);
        moduleTemplateLabel.setText("Module template:");
        Group moduleTemplateGroup = new Group(container, 64);
        moduleTemplateGroup.setLayout((Layout)new RowLayout(512));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigureGhidraModuleProjectWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                ConfigureGhidraModuleProjectWizardPage.this.validate();
            }
        };
        GhidraModuleUtils.ModuleTemplateType[] moduleTemplateTypeArray = GhidraModuleUtils.ModuleTemplateType.values();
        int n = moduleTemplateTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GhidraModuleUtils.ModuleTemplateType moduleTemplateType = moduleTemplateTypeArray[n2];
            Button checkboxButton = new Button((Composite)moduleTemplateGroup, 32);
            checkboxButton.setSelection(true);
            checkboxButton.setText(moduleTemplateType.getName() + " - " + moduleTemplateType.getDescription());
            checkboxButton.setToolTipText(moduleTemplateType.getDescription());
            checkboxButton.addSelectionListener(selectionListener);
            this.moduleTemplateCheckboxMap.put(checkboxButton, moduleTemplateType);
            ++n2;
        }
        this.validate();
        this.setControl((Control)container);
    }

    public Set<GhidraModuleUtils.ModuleTemplateType> getModuleTemplateTypes() {
        HashSet<GhidraModuleUtils.ModuleTemplateType> moduleTemplateTypes = new HashSet<GhidraModuleUtils.ModuleTemplateType>();
        for (Button checkboxButton : this.moduleTemplateCheckboxMap.keySet()) {
            if (!checkboxButton.isEnabled() || !checkboxButton.getSelection()) continue;
            moduleTemplateTypes.add(this.moduleTemplateCheckboxMap.get(checkboxButton));
        }
        return moduleTemplateTypes;
    }

    private void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

