/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidra.GhidraApplicationLayout;
import ghidra.framework.ApplicationProperties;
import ghidradev.EclipseMessageUtils;
import ghidradev.ghidraprojectcreator.preferences.GhidraProjectCreatorPreferences;
import ghidradev.ghidraprojectcreator.wizards.pages.ChooseGhidraModuleProjectWizardPage;
import java.io.File;
import java.io.IOException;
import org.eclipse.buildship.core.FixedVersionGradleDistribution;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.LocalGradleDistribution;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConfigureGradleWizardPage
extends WizardPage {
    private Button gradleWrapperChoiceButton;
    private Button gradleLocalChoiceButton;
    private Text gradleLocalDirText;
    private Button gradlLocalDirButton;
    private ChooseGhidraModuleProjectWizardPage projectPage;
    private String gradleVersion;

    public ConfigureGradleWizardPage(ChooseGhidraModuleProjectWizardPage projectPage) {
        super("ConfigureGradleWizardPage");
        this.setTitle("Configure Gradle");
        this.setDescription("Configure Gradle.");
        this.projectPage = projectPage;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigureGradleWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                ConfigureGradleWizardPage.this.validate();
            }
        };
        String gradleLocalTooltip = "Use a local installation of Gradle.  For best results, ensure that the version of this local Gradle matches the version specified on this wizard page's description.";
        this.gradleLocalChoiceButton = new Button(container, 16);
        this.gradleLocalChoiceButton.addSelectionListener(selectionListener);
        this.gradleLocalChoiceButton.setToolTipText(gradleLocalTooltip);
        Label gradleLocalDirLabel = new Label(container, 0);
        gradleLocalDirLabel.setText("Local installation directory:");
        this.gradleLocalDirText = new Text(container, 2052);
        this.gradleLocalDirText.setToolTipText(gradleLocalTooltip);
        this.gradleLocalDirText.setLayoutData((Object)new GridData(768));
        this.gradleLocalDirText.addModifyListener(evt -> this.validate());
        this.gradlLocalDirButton = new Button(container, 524288);
        this.gradlLocalDirButton.setText("...");
        this.gradlLocalDirButton.addListener(13, evt -> {
            DirectoryDialog dialog = new DirectoryDialog(container.getShell());
            String path = dialog.open();
            if (path != null) {
                this.gradleLocalDirText.setText(path);
            }
            this.validate();
        });
        String gradleWrapperTooltip = "Use the Gradle Wrapper, which will automatically download the correct version of Gradle to use from the Internet.";
        this.gradleWrapperChoiceButton = new Button(container, 16);
        this.gradleWrapperChoiceButton.addSelectionListener(selectionListener);
        this.gradleWrapperChoiceButton.setToolTipText(gradleWrapperTooltip);
        Label gradleWrapperDirLabel = new Label(container, 0);
        gradleWrapperDirLabel.setText("Gradle Wrapper");
        Label internetLabel = new Label(container, 0);
        internetLabel.setText("INTERNET CONNECTION REQUIRED");
        internetLabel.setForeground(parent.getDisplay().getSystemColor(3));
        internetLabel.setToolTipText(gradleWrapperTooltip);
        new Label(container, 0).setText("");
        GradleDistribution lastGradleDistribution = GhidraProjectCreatorPreferences.getGhidraLastGradleDistribution();
        if (lastGradleDistribution instanceof LocalGradleDistribution) {
            this.gradleLocalChoiceButton.setSelection(true);
            LocalGradleDistribution localGradleDistribution = (LocalGradleDistribution)lastGradleDistribution;
            if (localGradleDistribution.getLocation() != null) {
                this.gradleLocalDirText.setText(localGradleDistribution.getLocation().getAbsolutePath());
            }
        } else if (lastGradleDistribution instanceof WrapperGradleDistribution || lastGradleDistribution instanceof FixedVersionGradleDistribution) {
            this.gradleWrapperChoiceButton.setSelection(true);
        } else {
            this.gradleLocalChoiceButton.setSelection(true);
        }
        this.validate();
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IProject project = this.projectPage.getGhidraModuleProject().getProject();
            IFolder ghidraFolder = project.getFolder("Ghidra");
            File ghidraDir = ghidraFolder.getLocation().toFile();
            try {
                GhidraApplicationLayout ghidraLayout = new GhidraApplicationLayout(ghidraDir);
                ApplicationProperties props = ghidraLayout.getApplicationProperties();
                this.gradleVersion = props.getProperty("application.gradle.min");
                if (this.gradleVersion != null && !this.gradleVersion.isEmpty()) {
                    this.setDescription("Configure Gradle.  Version " + this.gradleVersion + " is expected.");
                }
            }
            catch (IOException iOException) {
                EclipseMessageUtils.error("Unable to determine required Gradle version.");
            }
        }
    }

    public GradleDistribution getGradleDistribution() {
        if (this.gradleLocalChoiceButton.getSelection()) {
            return GradleDistribution.forLocalInstallation((File)new File(this.gradleLocalDirText.getText()));
        }
        if (this.gradleVersion != null) {
            return GradleDistribution.forVersion((String)this.gradleVersion);
        }
        return GradleDistribution.fromBuild();
    }

    private void validate() {
        String message = null;
        if (this.gradleLocalChoiceButton.getSelection()) {
            String path = this.gradleLocalDirText.getText().trim();
            File dir = new File(path);
            if (path.isEmpty()) {
                message = "Path to local Gradle installation must be specified.";
            } else if (!dir.exists()) {
                message = "Path to local Gradle installation does not exist.";
            } else if (!dir.isDirectory()) {
                message = "Path to local Gradle installation is not a directory.";
            } else if (!new File(dir, "bin/gradle").exists()) {
                message = "Path to local Gradle installation appears invalid.  Missing gradle binary.";
            }
        }
        if (message == null) {
            GhidraProjectCreatorPreferences.setGhidraLastGradleDistribution(this.getGradleDistribution());
        } else {
            GhidraProjectCreatorPreferences.setGhidraLastGradleDistribution(null);
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

