/*
 * Decompiled with CFR 0.152.
 */
package ghidradev.ghidraprojectcreator.wizards.pages;

import ghidradev.ghidraprojectcreator.preferences.GhidraProjectCreatorPreferences;
import ghidradev.ghidraprojectcreator.utils.GhidraLaunchUtils;
import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateGhidraProjectWizardPage
extends WizardPage {
    private String suggestedProjectName;
    private Text projectNameText;
    private Text projectRootDirText;
    private Button projectDirButton;
    private Button createRunConfigCheckboxButton;
    private Text runConfigMemoryText;

    public CreateGhidraProjectWizardPage(String suggestedProjectName) {
        super("CreateGhidraProjectWizardPage");
        this.setTitle("Create Ghidra Project");
        this.setDescription("Create a new Ghidra project.");
        this.suggestedProjectName = suggestedProjectName;
    }

    public CreateGhidraProjectWizardPage() {
        this("");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label projectNameLabel = new Label(container, 0);
        projectNameLabel.setText("Project name:");
        this.projectNameText = new Text(container, 2052);
        this.projectNameText.setText(this.suggestedProjectName);
        this.projectNameText.setLayoutData((Object)new GridData(768));
        this.projectNameText.addModifyListener(evt -> this.validate());
        new Label(container, 0).setText("");
        Label projectDirLabel = new Label(container, 0);
        String projectDirToolTip = "The directory where this project will be created.";
        projectDirLabel.setText("Project root directory:");
        projectDirLabel.setToolTipText(projectDirToolTip);
        this.projectRootDirText = new Text(container, 2052);
        this.projectRootDirText.setLayoutData((Object)new GridData(768));
        this.projectRootDirText.setText(GhidraProjectCreatorPreferences.getGhidraLastProjectRootPath());
        this.projectRootDirText.addModifyListener(evt -> this.validate());
        this.projectRootDirText.setToolTipText(projectDirToolTip);
        this.projectDirButton = new Button(container, 524288);
        this.projectDirButton.setText("...");
        this.projectDirButton.setToolTipText("Browse to select project root directory");
        this.projectDirButton.addListener(13, evt -> {
            DirectoryDialog dialog = new DirectoryDialog(container.getShell());
            String path = dialog.open();
            if (path != null) {
                this.projectRootDirText.setText(path);
            }
        });
        this.createRunConfigCheckboxButton = new Button(container, 32);
        this.createRunConfigCheckboxButton.setText("Create run configuration");
        this.createRunConfigCheckboxButton.setToolTipText("Automatically create a Ghidra run configuration that can be used to launch and debug this project in Ghidra.  Run configurations can be created later and modified in the \"Run --> Run Configurations\" menu.");
        this.createRunConfigCheckboxButton.setSelection(true);
        this.createRunConfigCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                CreateGhidraProjectWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                CreateGhidraProjectWizardPage.this.validate();
            }
        });
        new Label(container, 0).setText("");
        new Label(container, 0).setText("");
        Label runConfigMemoryLabel = new Label(container, 0);
        String runConfigMemoryToolTip = "The maximum Java heap size (-Xmx) Ghidra will use when launched with the created run configuration (ex: 4G, 1500m, etc).  If left blank, Java's default heap size will be used, which is determined by your system's memory capacity.";
        runConfigMemoryLabel.setText("Run configuration memory:");
        runConfigMemoryLabel.setToolTipText(runConfigMemoryToolTip);
        this.runConfigMemoryText = new Text(container, 2052);
        this.runConfigMemoryText.addModifyListener(evt -> this.validate());
        this.runConfigMemoryText.setToolTipText(runConfigMemoryToolTip);
        new Label(container, 0).setText("");
        this.validate();
        this.setControl((Control)container);
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public File getProjectDir() {
        if (this.projectNameText.getText().isEmpty()) {
            return null;
        }
        if (this.projectRootDirText.getText().isEmpty()) {
            return null;
        }
        return new File(this.projectRootDirText.getText(), this.getProjectName());
    }

    public boolean shouldCreateRunConfig() {
        return this.createRunConfigCheckboxButton.getSelection();
    }

    public String getRunConfigMemory() {
        if (!this.createRunConfigCheckboxButton.getSelection() || this.runConfigMemoryText.getText().isEmpty()) {
            return null;
        }
        return this.runConfigMemoryText.getText();
    }

    private void validate() {
        this.runConfigMemoryText.setEnabled(this.createRunConfigCheckboxButton.getSelection());
        this.runConfigMemoryText.setMessage(this.runConfigMemoryText.isEnabled() ? "default" : "");
        Object message = null;
        String projectName = this.getProjectName();
        File projectDir = this.getProjectDir();
        boolean launchConfigExists = false;
        try {
            ILaunchConfiguration launchConfig = GhidraLaunchUtils.getLaunchConfig(projectName);
            if (launchConfig != null) {
                String launchConfigTypeId = launchConfig.getType().getIdentifier();
                launchConfigExists = !launchConfigTypeId.equals("GhidraGuiLaunchConfigurationType") && !launchConfigTypeId.equals("GhidraHeadlessLaunchConfigurationType");
            }
        }
        catch (CoreException coreException) {}
        if (projectName.isEmpty()) {
            message = "Project name must be specified";
        } else if ("0123456789 `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?".chars().anyMatch(ch -> projectName.charAt(0) == ch)) {
            message = "Project name cannot start with an invalid character:\n 0123456789 `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?";
        } else if (" `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?".chars().anyMatch(ch -> projectName.indexOf(ch) != -1)) {
            message = "Project name cannot contain invalid characters:\n  `~!@#$%^&*()-+=[]{}\\|;:'\"<>,./?";
        } else if (projectDir == null) {
            message = "Project root directory must be specified";
        } else if (projectDir.exists()) {
            message = "Project already exists at: " + projectDir.getAbsolutePath();
        } else if (ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
            message = "\"" + projectName + "\" project already exists in workspace";
        } else if (this.shouldCreateRunConfig() && launchConfigExists) {
            message = "Run configuration \"" + projectName + "\" project already exists (check run configuration filters)";
        } else if (this.createRunConfigCheckboxButton.getSelection() && !this.runConfigMemoryText.getText().isEmpty() && !Pattern.matches("^\\d+[KkMmGg]$", this.runConfigMemoryText.getText())) {
            message = "Invalid run configuration memory value.  Value must match JVM -Xmx flag syntax (4G, 1500m, etc).";
        }
        this.setErrorMessage((String)message);
        this.setPageComplete(message == null);
        if (message == null) {
            GhidraProjectCreatorPreferences.setGhidraLastProjectRootPath(this.projectRootDirText.getText());
        }
    }
}

